/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.metadata;

import java.io.OutputStream;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.json.JSONWriter;
import org.dcm4chee.arc.Scheduler;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.event.SoftwareConfiguration;
import org.dcm4chee.arc.metadata.UpdateMetadataEJB;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.storage.WriteContext;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UpdateMetadataScheduler
extends Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateMetadataScheduler.class);
    @Inject
    private DicomConfiguration conf;
    @Inject
    private UpdateMetadataEJB ejb;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private Event<SoftwareConfiguration> softwareConfigurationEvent;
    @Inject
    private StorageFactory storageFactory;

    protected UpdateMetadataScheduler() {
        super(Scheduler.Mode.scheduleWithFixedDelay);
    }

    protected Logger log() {
        return LOG;
    }

    protected Duration getPollingInterval() {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        String[] seriesMetadataStorageIDs = arcDev.getSeriesMetadataStorageIDs();
        if (seriesMetadataStorageIDs.length > 0) {
            try {
                arcDev.getStorageDescriptorNotNull(seriesMetadataStorageIDs[0]);
                return arcDev.getSeriesMetadataPollingInterval();
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        List<Series.MetadataUpdate> metadataUpdates;
        Semaphore semaphore;
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        String[] storageIDs = arcDev.getSeriesMetadataStorageIDs();
        if (storageIDs.length == 0) {
            return;
        }
        int fetchSize = arcDev.getSeriesMetadataFetchSize();
        int threads = arcDev.getSeriesMetadataThreads();
        Semaphore semaphore2 = semaphore = threads > 1 ? new Semaphore(threads) : null;
        do {
            if (this.getPollingInterval() == null) {
                return;
            }
            LOG.debug("Query for Series scheduled for Creating/Updating Metadata");
            metadataUpdates = this.ejb.findSeriesForScheduledMetadataUpdate(fetchSize);
            if (metadataUpdates.isEmpty()) {
                LOG.debug("No Series scheduled for Creating/Updating Metadata");
                break;
            }
            LOG.info("Start Creating/Updating Metadata of {} Series", (Object)metadataUpdates.size());
            AtomicInteger success = new AtomicInteger();
            AtomicInteger skipped = new AtomicInteger();
            try (StorageFactory.UsableStorage usableStorage = this.storageFactory.getUsableStorage(arcDev.getFreeStorageDescriptors(storageIDs), arcDev.getFullStorageDescriptors(storageIDs));){
                if (usableStorage.updateStorageIDs != null) {
                    arcDev.setSeriesMetadataStorageIDs(usableStorage.updateStorageIDs);
                    this.updateDeviceConfiguration(arcDev);
                }
                for (Series.MetadataUpdate metadataUpdate : metadataUpdates) {
                    if (semaphore == null) {
                        this.updateMetadata(arcDev, usableStorage.storage, metadataUpdate, success, skipped);
                        continue;
                    }
                    semaphore.acquire();
                    this.device.execute(() -> {
                        try {
                            this.updateMetadata(arcDev, usableStorage.storage, metadataUpdate, success, skipped);
                        }
                        finally {
                            semaphore.release();
                        }
                    });
                }
                if (semaphore != null) {
                    LOG.debug("Waiting for finishing Creating/Updating Metadata of {} Series", (Object)metadataUpdates.size());
                    semaphore.acquire(threads);
                    semaphore.release(threads);
                }
            }
            catch (Exception e) {
                try {
                    LOG.error("Failed to access Storage:\n", (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOG.info("Finished Creating/Updating Metadata of {} (skipped={}, failed={}) Series", new Object[]{success, skipped, metadataUpdates.size() - success.get() - skipped.get()});
                    throw throwable;
                }
                LOG.info("Finished Creating/Updating Metadata of {} (skipped={}, failed={}) Series", new Object[]{success, skipped, metadataUpdates.size() - success.get() - skipped.get()});
            }
            LOG.info("Finished Creating/Updating Metadata of {} (skipped={}, failed={}) Series", new Object[]{success, skipped, metadataUpdates.size() - success.get() - skipped.get()});
        } while (metadataUpdates.size() == fetchSize);
    }

    private void updateDeviceConfiguration(ArchiveDeviceExtension arcDev) {
        try {
            LOG.info("Update Storage configuration of Device: {}:\n", (Object)this.device.getDeviceName());
            ConfigurationChanges diffs = this.conf.merge(this.device, EnumSet.of(DicomConfiguration.Option.PRESERVE_VENDOR_DATA, DicomConfiguration.Option.PRESERVE_CERTIFICATE, arcDev.isAuditSoftwareConfigurationVerbose() ? DicomConfiguration.Option.CONFIGURATION_CHANGES_VERBOSE : DicomConfiguration.Option.CONFIGURATION_CHANGES));
            this.softwareConfigurationEvent.fire((Object)new SoftwareConfiguration(null, this.device.getDeviceName(), diffs));
        }
        catch (ConfigurationException e) {
            LOG.warn("Failed to update Storage configuration of Device: {}:\n", (Object)this.device.getDeviceName(), (Object)e);
        }
    }

    private void updateMetadata(ArchiveDeviceExtension arcDev, Storage storage, Series.MetadataUpdate metadataUpdate, AtomicInteger success, AtomicInteger skipped) {
        block24: {
            try {
                RetrieveContext ctx = this.retrieveService.newRetrieveContextSeriesMetadata(metadataUpdate);
                try {
                    if (this.claim(metadataUpdate, storage) && this.retrieveService.calculateMatches(ctx)) {
                        LOG.debug("Creating/Updating Metadata for Series[pk={}] on {}", (Object)metadataUpdate.seriesPk, (Object)storage.getStorageDescriptor());
                        WriteContext writeCtx = this.createWriteContext(storage, (InstanceLocations)ctx.getMatches().iterator().next());
                        try {
                            try (ZipOutputStream out = new ZipOutputStream(storage.openOutputStream(writeCtx));){
                                for (InstanceLocations match : ctx.getMatches()) {
                                    out.putNextEntry(new ZipEntry(match.getSopInstanceUID()));
                                    JsonGenerator gen = Json.createGenerator((OutputStream)out);
                                    arcDev.encodeAsJSONNumber(new JSONWriter(gen)).write(this.loadMetadata(ctx, match));
                                    gen.flush();
                                    out.closeEntry();
                                }
                                out.finish();
                            }
                            storage.commitStorage(writeCtx);
                            this.ejb.commit(metadataUpdate.seriesPk, this.createMetadata(writeCtx));
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to Create/Update Metadata for Series[pk={}] on {}:\n", new Object[]{metadataUpdate.seriesPk, storage.getStorageDescriptor(), e});
                            try {
                                this.ejb.incrementMetadataUpdateFailures(metadataUpdate.seriesPk, UpdateMetadataScheduler.nextRetry(arcDev, metadataUpdate.updateFailures));
                            }
                            catch (Exception e1) {
                                LOG.warn("Failed to update Metadata Update time", (Throwable)e1);
                            }
                            try {
                                storage.revokeStorage(writeCtx);
                            }
                            catch (Exception e1) {
                                LOG.warn("Failed to revoke storage", (Throwable)e1);
                            }
                            if (ctx != null) {
                                ctx.close();
                            }
                            return;
                        }
                        LOG.debug("Created/Updated Metadata for Series[pk={}] on {}", (Object)metadataUpdate.seriesPk, (Object)storage.getStorageDescriptor());
                        success.getAndIncrement();
                        break block24;
                    }
                    skipped.getAndIncrement();
                }
                finally {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Unexpected exception on closing Retrieve Context for {}:\n", (Object)metadataUpdate, (Object)e);
            }
        }
    }

    private static Date nextRetry(ArchiveDeviceExtension arcDev, int updateFailures) {
        int maxRetries = arcDev.getSeriesMetadataMaxRetries();
        Duration retryInterval = arcDev.getSeriesMetadataRetryInterval();
        return retryInterval != null && (maxRetries < 0 || maxRetries > updateFailures) ? new Date(System.currentTimeMillis() + retryInterval.getSeconds() * 1000L) : null;
    }

    private boolean claim(Series.MetadataUpdate metadataUpdate, Storage storage) {
        try {
            return this.ejb.claim(metadataUpdate);
        }
        catch (Exception e) {
            LOG.info("Failed to claim create/update Metadata for Series[pk={}] on {}]:\n", new Object[]{metadataUpdate.seriesPk, storage.getStorageDescriptor(), e});
            return false;
        }
    }

    private Attributes loadMetadata(RetrieveContext ctx, InstanceLocations match) throws Exception {
        return match.isContainsMetadata() ? match.getAttributes() : this.retrieveService.loadMetadata(ctx, match);
    }

    private Metadata createMetadata(WriteContext writeContext) {
        Metadata metadata = new Metadata();
        metadata.setStorageID(writeContext.getStorage().getStorageDescriptor().getStorageID());
        metadata.setStoragePath(writeContext.getStoragePath());
        metadata.setSize(writeContext.getSize());
        metadata.setDigest(writeContext.getDigest());
        return metadata;
    }

    private WriteContext createWriteContext(Storage storage, InstanceLocations match) {
        WriteContext writeCtx = storage.createWriteContext(match.getAttributes());
        writeCtx.setMessageDigest(storage.getStorageDescriptor().getMessageDigest());
        return writeCtx;
    }
}

