/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.mgt.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.entity.Task_;
import org.dcm4chee.arc.export.mgt.ExportBatch;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class ExportManagerEJB
implements ExportManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExportManagerEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private Device device;

    @Override
    public void createOrUpdateStudyExportTask(String deviceName, ExporterDescriptor exporterDesc, String studyIUID, Date scheduledTime) {
        this.createOrUpdateStudyExportTask(deviceName, exporterDesc, studyIUID, null, scheduledTime);
    }

    private void createOrUpdateStudyExportTask(String deviceName, ExporterDescriptor exporterDesc, String studyIUID, String batchID, Date scheduledTime) {
        try {
            Task task = (Task)this.em.createNamedQuery("Task.FindByExporterIDAndStudyIUID", Task.class).setParameter(1, (Object)exporterDesc.getExporterID()).setParameter(2, (Object)studyIUID).setParameter(3, (Object)Task.Status.SCHEDULED).setParameter(4, (Object)Task.Type.EXPORT).getSingleResult();
            this.updateExportTask(deviceName, task, "*", "*", scheduledTime);
        }
        catch (NoResultException nre) {
            this.createExportTask(deviceName, exporterDesc, studyIUID, "*", "*", batchID, scheduledTime, null);
        }
    }

    @Override
    public void createOrUpdateSeriesExportTask(String deviceName, ExporterDescriptor exporterDesc, String studyIUID, String seriesIUID, Date scheduledTime) {
        try {
            Task task = (Task)this.em.createNamedQuery("Task.FindByExporterIDAndStudyIUIDAndSeriesIUID", Task.class).setParameter(1, (Object)exporterDesc.getExporterID()).setParameter(2, (Object)studyIUID).setParameter(3, (Object)seriesIUID).setParameter(4, (Object)Task.Status.SCHEDULED).setParameter(5, (Object)Task.Type.EXPORT).getSingleResult();
            this.updateExportTask(deviceName, task, seriesIUID, "*", scheduledTime);
        }
        catch (NoResultException nre) {
            this.createExportTask(deviceName, exporterDesc, studyIUID, seriesIUID, "*", null, scheduledTime, null);
        }
    }

    @Override
    public void createOrUpdateInstanceExportTask(String deviceName, ExporterDescriptor exporterDesc, String studyIUID, String seriesIUID, String sopIUID, Date scheduledTime) {
        try {
            Task task = (Task)this.em.createNamedQuery("Task.FindByExporterIDAndStudyIUIDAndSeriesIUIDAndSopInstanceUID", Task.class).setParameter(1, (Object)exporterDesc.getExporterID()).setParameter(2, (Object)studyIUID).setParameter(3, (Object)seriesIUID).setParameter(4, (Object)sopIUID).setParameter(5, (Object)Task.Status.SCHEDULED).setParameter(6, (Object)Task.Type.EXPORT).getSingleResult();
            this.updateExportTask(deviceName, task, seriesIUID, sopIUID, scheduledTime);
        }
        catch (NoResultException nre) {
            this.createExportTask(deviceName, exporterDesc, studyIUID, seriesIUID, sopIUID, null, scheduledTime, null);
        }
    }

    private void updateExportTask(String deviceName, Task task, String seriesIUID, String sopIUID, Date scheduledTime) {
        task.setDeviceName(deviceName);
        if (!task.getSeriesInstanceUID().equals("*")) {
            task.setSeriesInstanceUID(seriesIUID);
        }
        if (!task.getSOPInstanceUID().equals("*")) {
            task.setSOPInstanceUID(sopIUID);
        }
        if (task.getScheduledTime() != null && task.getScheduledTime().before(scheduledTime)) {
            task.setScheduledTime(scheduledTime);
        }
        LOG.debug("Update {}", (Object)task);
    }

    @Override
    public Task createExportTask(String deviceName, ExporterDescriptor exporterDesc, String studyIUID, String seriesIUID, String sopIUID, String batchID, Date scheduledTime, HttpServletRequestInfo httpServletRequestInfo) {
        Task task = new Task();
        task.setDeviceName(deviceName);
        task.setQueueName(exporterDesc.getQueueName());
        task.setType(Task.Type.EXPORT);
        if (httpServletRequestInfo != null) {
            task.setRequesterUserID(httpServletRequestInfo.requesterUserID);
            task.setRequesterHost(httpServletRequestInfo.requesterHost);
            task.setRequestURI(this.requestURL(httpServletRequestInfo));
        }
        task.setStatus(Task.Status.SCHEDULED);
        task.setBatchID(batchID);
        task.setExporterID(exporterDesc.getExporterID());
        task.setLocalAET(exporterDesc.getAETitle());
        task.setStudyInstanceUID(studyIUID);
        task.setSeriesInstanceUID(seriesIUID);
        task.setSOPInstanceUID(sopIUID);
        task.setScheduledTime(scheduledTime);
        this.em.persist((Object)task);
        LOG.info("Create {}", (Object)task);
        return task;
    }

    private String requestURL(HttpServletRequestInfo httpServletRequestInfo) {
        String requestURI = httpServletRequestInfo.requestURI;
        String queryString = httpServletRequestInfo.queryString;
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @Override
    public boolean scheduleStudyExport(String studyUID, ExporterDescriptor exporter, Date notExportedAfter, String batchID, Date scheduledTime) {
        List prevTasks = this.em.createNamedQuery("Task.FindStudyExportAfter", Task.class).setParameter(1, (Object)notExportedAfter).setParameter(2, (Object)exporter.getExporterID()).setParameter(3, (Object)studyUID).setParameter(4, (Object)Task.Type.EXPORT).getResultList();
        if (!prevTasks.isEmpty()) {
            for (Task prevTask : prevTasks) {
                LOG.info("Previous {} found - suppress duplicate Export", (Object)prevTask);
            }
            return false;
        }
        this.createExportTask(this.device.getDeviceName(), exporter, studyUID, "*", "*", batchID, scheduledTime, null);
        return true;
    }

    @Override
    public List<ExportBatch> listExportBatches(TaskQueryParam queryParam, int offset, int limit) {
        ListExportBatches listExportBatches = new ListExportBatches(queryParam);
        TypedQuery query = this.em.createQuery(listExportBatches.query);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultStream().map(listExportBatches::toExportBatch).collect(Collectors.toList());
    }

    @Override
    public void merge(Task task) {
        this.em.merge((Object)task);
    }

    private class ListExportBatches {
        final CriteriaBuilder cb;
        final QueryBuilder queryBuilder;
        final CriteriaQuery<Tuple> query;
        final Root<Task> task;
        Expression<Date> minProcessingStartTime;
        Expression<Date> maxProcessingStartTime;
        Expression<Date> minProcessingEndTime;
        Expression<Date> maxProcessingEndTime;
        final Expression<Date> minScheduledTime;
        final Expression<Date> maxScheduledTime;
        final Expression<Date> minCreatedTime;
        final Expression<Date> maxCreatedTime;
        final Expression<Date> minUpdatedTime;
        final Expression<Date> maxUpdatedTime;
        final Path<String> batchIDPath;
        final Expression<Long> completed;
        final Expression<Long> failed;
        final Expression<Long> warning;
        final Expression<Long> canceled;
        final Expression<Long> scheduled;
        final Expression<Long> inprocess;
        final TaskQueryParam queryParam;

        ListExportBatches(TaskQueryParam queryParam) {
            this.cb = ExportManagerEJB.this.em.getCriteriaBuilder();
            this.queryBuilder = new QueryBuilder(this.cb);
            this.query = this.cb.createTupleQuery();
            this.task = this.query.from(Task.class);
            this.minScheduledTime = this.cb.least((Expression)this.task.get(Task_.scheduledTime));
            this.maxScheduledTime = this.cb.greatest((Expression)this.task.get(Task_.scheduledTime));
            this.minCreatedTime = this.cb.least((Expression)this.task.get(Task_.createdTime));
            this.maxCreatedTime = this.cb.greatest((Expression)this.task.get(Task_.createdTime));
            this.minUpdatedTime = this.cb.least((Expression)this.task.get(Task_.updatedTime));
            this.maxUpdatedTime = this.cb.greatest((Expression)this.task.get(Task_.updatedTime));
            this.batchIDPath = this.task.get(Task_.batchID);
            this.queryParam = queryParam;
            this.minProcessingStartTime = this.cb.least((Expression)this.task.get(Task_.processingStartTime));
            this.maxProcessingStartTime = this.cb.greatest((Expression)this.task.get(Task_.processingStartTime));
            this.minProcessingEndTime = this.cb.least((Expression)this.task.get(Task_.processingEndTime));
            this.maxProcessingEndTime = this.cb.greatest((Expression)this.task.get(Task_.processingEndTime));
            this.completed = this.statusSubquery(Task.Status.COMPLETED).getSelection();
            this.failed = this.statusSubquery(Task.Status.FAILED).getSelection();
            this.warning = this.statusSubquery(Task.Status.WARNING).getSelection();
            this.canceled = this.statusSubquery(Task.Status.CANCELED).getSelection();
            this.scheduled = this.statusSubquery(Task.Status.SCHEDULED).getSelection();
            this.inprocess = this.statusSubquery(Task.Status.IN_PROCESS).getSelection();
            this.query.multiselect(new Selection[]{this.batchIDPath, this.minProcessingStartTime, this.maxProcessingStartTime, this.minProcessingEndTime, this.maxProcessingEndTime, this.minScheduledTime, this.maxScheduledTime, this.minCreatedTime, this.maxCreatedTime, this.minUpdatedTime, this.maxUpdatedTime, this.completed, this.failed, this.warning, this.canceled, this.scheduled, this.inprocess});
            this.query.groupBy(new Expression[]{this.task.get(Task_.batchID)});
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)this.task.get(Task_.type), (Object)queryParam.getType()));
            if (queryParam.getBatchID() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.batchID), (Object)queryParam.getBatchID()));
            } else {
                predicates.add(this.task.get(Task_.batchID).isNotNull());
            }
            if (queryParam.getStatus() != null) {
                predicates.add(this.cb.equal((Expression)this.task.get(Task_.status), (Object)queryParam.getStatus()));
            }
            this.queryBuilder.matchExportBatch(predicates, queryParam, this.task);
            if (!predicates.isEmpty()) {
                this.query.where(predicates.toArray(new Predicate[0]));
            }
            if (queryParam.getOrderBy() != null) {
                this.query.orderBy(new Order[]{this.queryBuilder.orderBatches(this.task, queryParam.getOrderBy())});
            }
        }

        private Subquery<Long> statusSubquery(Task.Status status) {
            CriteriaQuery query = this.cb.createQuery(Task.class);
            Subquery sq = query.subquery(Long.class);
            Root sqtask = sq.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.status), (Object)status));
            predicates.add(this.cb.equal((Expression)sqtask.get(Task_.batchID), (Expression)this.task.get(Task_.batchID)));
            this.queryBuilder.matchExportBatch(predicates, this.queryParam, (Path)sqtask);
            sq.where(predicates.toArray(new Predicate[0]));
            sq.select(this.cb.count((Expression)sqtask));
            return sq;
        }

        ExportBatch toExportBatch(Tuple tuple) {
            String batchID = (String)tuple.get(this.batchIDPath);
            ExportBatch exportBatch = new ExportBatch(batchID);
            exportBatch.setScheduledTimeRange((Date)tuple.get(this.minScheduledTime), (Date)tuple.get(this.maxScheduledTime));
            exportBatch.setCreatedTimeRange((Date)tuple.get(this.minCreatedTime), (Date)tuple.get(this.maxCreatedTime));
            exportBatch.setUpdatedTimeRange((Date)tuple.get(this.minUpdatedTime), (Date)tuple.get(this.maxUpdatedTime));
            exportBatch.setProcessingStartTimeRange((Date)tuple.get(this.minProcessingStartTime), (Date)tuple.get(this.maxProcessingStartTime));
            exportBatch.setProcessingEndTimeRange((Date)tuple.get(this.minProcessingEndTime), (Date)tuple.get(this.maxProcessingEndTime));
            CriteriaQuery distinct = this.cb.createQuery(String.class).distinct(true);
            Root exportTask = distinct.from(Task.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(this.cb.equal((Expression)exportTask.get(Task_.batchID), (Object)batchID));
            this.queryBuilder.matchExportBatch(predicates, this.queryParam, (Path)exportTask);
            distinct.where(predicates.toArray(new Predicate[0]));
            exportBatch.setDeviceNames(this.select((CriteriaQuery<String>)distinct, (Path<String>)exportTask.get(Task_.deviceName)));
            exportBatch.setExporterIDs(this.select((CriteriaQuery<String>)distinct, (Path<String>)exportTask.get(Task_.exporterID)));
            exportBatch.setCompleted((Long)tuple.get(this.completed));
            exportBatch.setCanceled((Long)tuple.get(this.canceled));
            exportBatch.setWarning((Long)tuple.get(this.warning));
            exportBatch.setFailed((Long)tuple.get(this.failed));
            exportBatch.setScheduled((Long)tuple.get(this.scheduled));
            exportBatch.setInProcess((Long)tuple.get(this.inprocess));
            return exportBatch;
        }

        private List<String> select(CriteriaQuery<String> query, Path<String> path) {
            return ExportManagerEJB.this.em.createQuery(query.select(path)).getResultList();
        }
    }
}

