/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.time.LocalDate;
import java.time.Period;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.ItemPointer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.AttributesBuilder;
import org.dcm4chee.arc.conf.HL7Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySelector {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySelector.class);
    private static final long MILLIS_PER_DAY = 86400000L;
    private final String value;
    private final Attributes keys = new Attributes();
    private final Attributes dynamicKeys = new Attributes();
    private final int numberOfPriors;

    public static EntitySelector[] valuesOf(String ... ss) {
        EntitySelector[] selectors = new EntitySelector[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            selectors[i] = new EntitySelector(ss[i]);
        }
        return selectors;
    }

    public EntitySelector(String value) {
        this.numberOfPriors = this.parseKeys(value);
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    private int parseKeys(String queryParams) {
        AttributesBuilder builder = new AttributesBuilder(this.keys);
        AttributesBuilder dynamicBuilder = new AttributesBuilder(this.dynamicKeys);
        int priors = -1;
        for (String queryParam : StringUtils.split((String)queryParams, (char)'&')) {
            String[] keyValue = StringUtils.split((String)queryParam, (char)'=');
            if (keyValue.length != 2) {
                throw new IllegalArgumentException(queryParam);
            }
            try {
                if (keyValue[0].equals("priors")) {
                    priors = Integer.parseInt(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals("StudyAge")) {
                    String[] studyAge = StringUtils.split((String)keyValue[1], (char)'-');
                    if (studyAge.length != 2) {
                        throw new IllegalArgumentException();
                    }
                    this.keys.setDateRange(524320, VR.DA, new DateRange(EntitySelector.age2Date(studyAge[1]), EntitySelector.age2Date(studyAge[0])));
                    continue;
                }
                if (keyValue[1].startsWith("$")) {
                    dynamicBuilder.setString(TagUtils.parseTagPath((String)keyValue[0]), keyValue[1].substring(1));
                    continue;
                }
                builder.setString(TagUtils.parseTagPath((String)keyValue[0]), keyValue[1]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(queryParam);
            }
        }
        return priors;
    }

    private static Date age2Date(String age) {
        return age.isEmpty() ? null : new Date(LocalDate.now().minus(EntitySelector.age2Period(age)).toEpochDay() * 86400000L);
    }

    private static Period age2Period(String age) {
        int n;
        int last = age.length() - 1;
        if (last > 0 && (n = Integer.parseInt(age.substring(0, last))) > 0) {
            switch (age.charAt(last)) {
                case 'D': {
                    return Period.ofDays(n);
                }
                case 'M': {
                    return Period.ofMonths(n);
                }
                case 'W': {
                    return Period.ofWeeks(n);
                }
                case 'Y': {
                    return Period.ofYears(n);
                }
            }
        }
        throw new IllegalArgumentException(age);
    }

    public Attributes getQueryKeys(final HL7Fields hl7Fields) {
        if (this.dynamicKeys.isEmpty()) {
            return this.keys;
        }
        final Attributes queryKeys = new Attributes(this.keys);
        try {
            this.dynamicKeys.accept((Attributes.Visitor)new Attributes.ItemPointerVisitor(){

                public boolean visit(Attributes item, int tag, VR vr, Object value) {
                    return EntitySelector.addDynamicKey(queryKeys, this.itemPointers, tag, vr, hl7Fields.get(item.getString(tag), null));
                }
            }, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return queryKeys;
    }

    public Attributes getQueryKeys(final Attributes attrs) {
        if (this.dynamicKeys.isEmpty()) {
            return this.keys;
        }
        final Attributes queryKeys = new Attributes(this.keys);
        try {
            this.dynamicKeys.accept((Attributes.Visitor)new Attributes.ItemPointerVisitor(){

                public boolean visit(Attributes item, int tag, VR vr, Object value) {
                    return EntitySelector.addDynamicKey(queryKeys, this.itemPointers, tag, vr, EntitySelector.valueFrom(attrs, item.getString(tag)));
                }
            }, true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return queryKeys;
    }

    private static boolean addDynamicKey(Attributes queryKeys, List<ItemPointer> itemPointers, int tag, VR vr, String value) {
        if (value == null) {
            return true;
        }
        Attributes item = queryKeys;
        for (ItemPointer itemPointer : itemPointers) {
            Sequence sq = item.getSequence(itemPointer.sequenceTag);
            if (sq == null) {
                sq = item.newSequence(itemPointer.sequenceTag, 1);
            }
            if (sq.isEmpty()) {
                sq.add(new Attributes());
            }
            item = (Attributes)sq.get(0);
        }
        item.setString(tag, vr, value);
        return true;
    }

    private static String valueFrom(Attributes src, String tagPathStr) {
        int i = 0;
        int[] tagPath = TagUtils.parseTagPath((String)tagPathStr);
        int last = tagPath.length - 1;
        if (i < last) {
            if ((src = src.getNestedDataset(tagPath[i])) == null) {
                // empty if block
            }
            return null;
        }
        return src.getString(tagPath[last]);
    }

    public int getNumberOfPriors() {
        return this.numberOfPriors;
    }
}

