/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AttributeSet
implements Comparable<AttributeSet> {
    private Type type;
    private String id;
    private String title;
    private String description;
    private int number;
    private int[] selection;
    private boolean installed = true;
    private final Map<String, String> properties = new HashMap<String, String>();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int[] getSelection() {
        return this.selection;
    }

    public void setSelection(int[] selection) {
        this.selection = selection;
        Arrays.sort(selection);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name, String defValue) {
        String value = this.properties.get(name);
        return value != null ? value : defValue;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(String[] ss) {
        this.properties.clear();
        for (String s : ss) {
            int index = s.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException("Property in incorrect format : " + s);
            }
            this.setProperty(s.substring(0, index), s.substring(index + 1));
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    @Override
    public int compareTo(AttributeSet other) {
        return this.number - other.number;
    }

    public static enum Type {
        QIDO_RS,
        WADO_RS,
        DIFF_RS,
        LEADING_CFIND_SCP;

    }
}

