/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.coerce.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.coerce.CoercionProcessor;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="sup-from-dev")
public class SupplementFromDeviceCoercionProcessor
implements CoercionProcessor {
    static final Logger LOG = LoggerFactory.getLogger(SupplementFromDeviceCoercionProcessor.class);
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();

    public boolean coerce(ArchiveAttributeCoercion2 coercion, String sopClassUID, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attributes, Attributes coercedAttributes) throws Exception {
        switch (sopClassUID) {
            case "1.2.840.10008.5.1.4.31": {
                this.supplementMWL(coercion, attributes);
                break;
            }
            case "1.2.840.10008.3.1.2.3.3": {
                this.supplementMPPS(coercion, attributes);
                break;
            }
            case "1.2.840.10008.5.1.4.1.2.1.1": 
            case "1.2.840.10008.5.1.4.1.2.2.1": 
            case "1.2.840.10008.5.1.4.1.2.3.1": {
                this.supplementQuery(coercion, attributes);
                break;
            }
            default: {
                this.supplementInstance(coercion, attributes);
            }
        }
        return true;
    }

    private void supplementInstance(ArchiveAttributeCoercion2 coercion, Attributes attrs) {
        Device device = coercion.getOtherDevice();
        this.supplementValue(attrs, 524400, VR.LO, device.getManufacturer());
        this.supplementValue(attrs, 528528, VR.LO, device.getManufacturerModelName());
        this.supplementValue(attrs, 528400, VR.SH, device.getStationName());
        this.supplementValue(attrs, 0x181000, VR.LO, device.getDeviceSerialNumber());
        this.supplementValues(attrs, 1576992, VR.LO, device.getSoftwareVersions());
        this.supplementValue(attrs, 524416, VR.LO, device.getInstitutionNames());
        this.supplementCode(attrs, 524418, device.getInstitutionCodes());
        this.supplementValue(attrs, 528448, VR.LO, device.getInstitutionalDepartmentNames());
        this.supplementValue(attrs, 524417, VR.ST, device.getInstitutionAddresses());
        this.supplementIssuers(device, attrs);
        this.supplementRequestIssuers(device, attrs.getSequence(4194933));
        LOG.info("Supplement composite object from device: {} using coercion {}", (Object)device.getDeviceName(), (Object)coercion);
    }

    private void supplementMPPS(ArchiveAttributeCoercion2 coercion, Attributes attrs) {
        Device device = coercion.getOtherDevice();
        this.supplementIssuers(device, attrs);
        this.supplementRequestIssuers(device, attrs.getSequence(4194928));
        LOG.info("Supplement MPPS from device: {} using coercion {}", (Object)device.getDeviceName(), (Object)coercion);
    }

    private void supplementMWL(ArchiveAttributeCoercion2 coercion, Attributes attrs) {
        Device device = coercion.getOtherDevice();
        this.supplementIssuers(device, attrs);
        this.supplementRequestIssuers(device, attrs);
        LOG.info("Supplement MWL from device: {} using coercion {}", (Object)device.getDeviceName(), (Object)coercion);
    }

    private void supplementQuery(ArchiveAttributeCoercion2 coercion, Attributes attrs) {
        Device device = coercion.getOtherDevice();
        this.supplementIssuers(device, attrs);
        this.supplementRequestIssuers(device, attrs.getSequence(4194933));
        LOG.info("Supplement composite query from device: {} using coercion {}", (Object)device.getDeviceName(), (Object)coercion);
    }

    private void supplementValue(Attributes attrs, int tag, VR vr, String ... values) {
        if (values.length == 0 || values[0] == null || attrs.containsValue(tag)) {
            return;
        }
        attrs.setString(tag, vr, values[0]);
        this.log(tag, vr, values[0]);
    }

    private void supplementValues(Attributes attrs, int tag, VR vr, String ... values) {
        if (values.length == 0 || attrs.containsValue(tag)) {
            return;
        }
        attrs.setString(tag, vr, values);
        this.log(tag, vr, values);
    }

    private void supplementCode(Attributes attrs, int seqTag, Code ... codes) {
        if (codes.length == 0 || codes[0] == null || attrs.containsValue(seqTag)) {
            return;
        }
        Attributes item = new Attributes(attrs.bigEndian(), 4);
        item.setString(524544, VR.SH, codes[0].getCodeValue());
        item.setString(524546, VR.SH, codes[0].getCodingSchemeDesignator());
        String version = codes[0].getCodingSchemeVersion();
        if (version != null) {
            item.setString(524547, VR.SH, version);
        }
        item.setString(524548, VR.LO, codes[0].getCodeMeaning());
        attrs.newSequence(seqTag, 1).add(item);
        this.log(seqTag, VR.SQ, item);
    }

    private void supplementIssuers(Device device, Attributes attrs) {
        this.supplementIssuerOfPatientID(device, attrs);
        this.supplementIssuer(attrs, 524368, 524369, device.getIssuerOfAccessionNumber());
        this.supplementIssuer(attrs, 3670032, 3670036, device.getIssuerOfAdmissionID());
        this.supplementIssuer(attrs, 3670112, 3670116, device.getIssuerOfServiceEpisodeID());
        this.supplementIssuer(attrs, 4195602, 4195603, device.getIssuerOfContainerIdentifier());
        this.supplementIssuer(attrs, 4195665, 4195682, device.getIssuerOfSpecimenIdentifier());
    }

    private void supplementIssuerOfPatientID(Device device, Attributes attrs) {
        String universalEntityID;
        if (this.supplementIssuerOfPID(device, attrs)) {
            return;
        }
        Issuer issuer = device.getIssuerOfPatientID();
        String localNamespaceEntityID = issuer.getLocalNamespaceEntityID();
        if (localNamespaceEntityID != null) {
            attrs.setString(0x100021, VR.LO, localNamespaceEntityID);
            this.log(0x100021, VR.LO, localNamespaceEntityID);
        }
        if ((universalEntityID = issuer.getUniversalEntityID()) != null) {
            Attributes item = new Attributes(attrs.bigEndian(), 2);
            item.setString(4194354, VR.UT, universalEntityID);
            item.setString(0x400033, VR.CS, issuer.getUniversalEntityIDType());
            attrs.newSequence(1048612, 1).add(item);
            this.log(1048612, VR.SQ, item);
        }
    }

    private boolean supplementIssuerOfPID(Device device, Attributes attrs) {
        Attributes issuerOfPIDQualifier = attrs.getNestedDataset(1048612);
        return !attrs.containsValue(0x100020) || device.getIssuerOfPatientID() == null || attrs.containsValue(0x100021) || issuerOfPIDQualifier != null && !issuerOfPIDQualifier.isEmpty();
    }

    private void supplementIssuer(Attributes attrs, int idTag, int seqTag, Issuer issuer) {
        String universalEntityID;
        if (issuer == null || !attrs.containsValue(idTag) || attrs.containsValue(seqTag)) {
            return;
        }
        Attributes item = new Attributes(attrs.bigEndian(), 3);
        String localNamespaceEntityID = issuer.getLocalNamespaceEntityID();
        if (localNamespaceEntityID != null) {
            item.setString(4194353, VR.UT, localNamespaceEntityID);
        }
        if ((universalEntityID = issuer.getUniversalEntityID()) != null) {
            item.setString(4194354, VR.UT, universalEntityID);
            item.setString(0x400033, VR.CS, issuer.getUniversalEntityIDType());
        }
        attrs.newSequence(seqTag, 1).add(item);
        this.log(seqTag, VR.SQ, item);
    }

    private void supplementRequestIssuers(Device device, Sequence rqSeq) {
        if (rqSeq != null) {
            for (Attributes rq : rqSeq) {
                this.supplementRequestIssuers(device, rq);
            }
        }
    }

    private void supplementRequestIssuers(Device device, Attributes rq) {
        this.supplementIssuer(rq, 524368, 524369, device.getIssuerOfAccessionNumber());
        this.supplementIssuer(rq, 4202518, 4194342, device.getOrderPlacerIdentifier());
        this.supplementIssuer(rq, 4202519, 4194343, device.getOrderFillerIdentifier());
    }

    private void log(int tag, VR vr, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Supplements {} {} [{}] {}", new Object[]{TagUtils.toString((int)tag), vr, value, DICT.keywordOf(tag)});
        }
    }
}

