/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.code.impl;

import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.data.Code;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.code.CodeService;
import org.dcm4chee.arc.entity.CodeEntity;

@ApplicationScoped
public class CodeCacheImpl
implements CodeCache {
    @Inject
    private CodeService service;
    private ConcurrentHashMap<Code.Key, CodeEntity> cache = new ConcurrentHashMap();

    @Override
    public CodeEntity findOrCreate(Code code) {
        CodeEntity entry = this.cache.get(code.key());
        if (entry == null) {
            entry = this.service.findOrCreate(code);
            this.cache.put(code.key(), entry);
        }
        return entry;
    }

    @Override
    public CodeEntity[] findOrCreateEntities(Code ... codes) {
        CodeEntity[] entities = new CodeEntity[codes.length];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = this.findOrCreate(codes[i]);
        }
        return entities;
    }
}

