/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.audit;

import java.net.InetAddress;
import java.nio.file.Path;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.ActiveParticipantBuilder;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.audit.AuditInfo;
import org.dcm4chee.arc.audit.AuditInfoBuilder;
import org.dcm4chee.arc.audit.AuditService;
import org.dcm4chee.arc.audit.AuditUtils;
import org.dcm4chee.arc.audit.EventID;
import org.dcm4chee.arc.audit.HL7AuditUtils;
import org.dcm4chee.arc.audit.ParticipantObjectID;
import org.dcm4chee.arc.audit.SpoolFileReader;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;

class PatientRecordAuditService {
    private final ArchiveDeviceExtension arcDev;
    private PatientMgtContext ctx;
    private HL7ConnectionEvent hl7ConnEvent;
    private AuditInfoBuilder.Builder infoBuilder;

    PatientRecordAuditService(PatientMgtContext ctx, ArchiveDeviceExtension arcDev) {
        String callingUserID;
        this.ctx = ctx;
        this.arcDev = arcDev;
        HttpServletRequestInfo httpServletRequestInfo = ctx.getHttpServletRequestInfo();
        Association association = ctx.getAssociation();
        String string = httpServletRequestInfo != null ? httpServletRequestInfo.requesterUserID : (association != null ? association.getCallingAET() : (callingUserID = ctx.getSourceMwlScp() != null ? ctx.getSourceMwlScp() : arcDev.getDevice().getDeviceName()));
        String calledUserID = httpServletRequestInfo != null ? this.requestURLWithQueryParams(httpServletRequestInfo) : (association != null ? association.getCalledAET() : (ctx.getLocalAET() != null ? ctx.getLocalAET() : null));
        this.infoBuilder = new AuditInfoBuilder.Builder().callingHost(ctx.getRemoteHostName()).callingUserID(callingUserID).calledUserID(calledUserID).outcome(PatientRecordAuditService.outcome(ctx.getException())).patVerificationStatus(ctx.getPatientVerificationStatus()).pdqServiceURI(ctx.getPDQServiceURI()).findSCP(ctx.getSourceMwlScp()).destUserID(ctx.getLocalAET());
    }

    PatientRecordAuditService(HL7ConnectionEvent hl7ConnEvent, ArchiveDeviceExtension arcDev) {
        ArchiveHL7Message archiveHL7Message;
        HttpServletRequestInfo httpServletRequestInfo;
        String callingHost;
        this.arcDev = arcDev;
        this.hl7ConnEvent = hl7ConnEvent;
        HL7Segment msh = hl7ConnEvent.getHL7Message().msh();
        String callingUserID = msh.getSendingApplicationWithFacility();
        String calledUserID = msh.getReceivingApplicationWithFacility();
        String string = callingHost = hl7ConnEvent.getConnection() != null ? hl7ConnEvent.getConnection().getHostname() : ReverseDNS.hostNameOf((InetAddress)hl7ConnEvent.getSocket().getInetAddress());
        if (this.isArchiveHL7MsgAndNotOrder() && (httpServletRequestInfo = (archiveHL7Message = (ArchiveHL7Message)hl7ConnEvent.getHL7Message()).getHttpServletRequestInfo()) != null) {
            callingHost = httpServletRequestInfo.requesterHost;
            callingUserID = httpServletRequestInfo.requesterUserID;
            calledUserID = this.requestURLWithQueryParams(httpServletRequestInfo);
        }
        this.infoBuilder = new AuditInfoBuilder.Builder().callingHost(callingHost).callingUserID(callingUserID).calledUserID(calledUserID).outcome(PatientRecordAuditService.outcome(hl7ConnEvent.getException()));
    }

    private String requestURLWithQueryParams(HttpServletRequestInfo httpServletRequestInfo) {
        return httpServletRequestInfo.queryString == null ? httpServletRequestInfo.requestURI : httpServletRequestInfo.requestURI + "?" + httpServletRequestInfo.queryString;
    }

    AuditInfoBuilder getPatAuditInfo() {
        return this.infoBuilder.pIDAndName(this.ctx.getAttributes(), this.arcDev).build();
    }

    AuditInfoBuilder getPrevPatAuditInfo() {
        return this.infoBuilder.pIDAndName(this.ctx.getPreviousAttributes(), this.arcDev).build();
    }

    AuditInfoBuilder getHL7IncomingPatInfo() {
        HL7Segment pid = HL7AuditUtils.getHL7Segment(this.hl7ConnEvent.getHL7Message(), "PID");
        return this.infoBuilder.patID(pid.getField(3, null), this.arcDev).patName(pid.getField(5, null), this.arcDev).build();
    }

    AuditInfoBuilder getHL7IncomingPrevPatInfo(HL7Segment mrg) {
        return this.infoBuilder.patID(mrg.getField(1, null), this.arcDev).patName(mrg.getField(7, null), this.arcDev).build();
    }

    AuditInfoBuilder getHL7OutgoingPatInfo() {
        HL7Segment msh = this.hl7ConnEvent.getHL7Message().msh();
        HL7Segment pid = HL7AuditUtils.getHL7Segment(this.hl7ConnEvent.getHL7Message(), "PID");
        return this.infoBuilder.patID(pid.getField(3, null), this.arcDev).patName(pid.getField(5, null), this.arcDev).isOutgoingHL7().outgoingHL7Sender(msh.getSendingApplicationWithFacility()).outgoingHL7Receiver(msh.getReceivingApplicationWithFacility()).build();
    }

    AuditInfoBuilder getHL7OutgoingPrevPatInfo(HL7Segment mrg) {
        HL7Segment msh = this.hl7ConnEvent.getHL7Message().msh();
        return this.infoBuilder.patID(mrg.getField(1, null), this.arcDev).patName(mrg.getField(7, null), this.arcDev).isOutgoingHL7().outgoingHL7Sender(msh.getSendingApplicationWithFacility()).outgoingHL7Receiver(msh.getReceivingApplicationWithFacility()).build();
    }

    boolean isArchiveHL7MsgAndNotOrder() {
        return this.hl7ConnEvent.getHL7Message() instanceof ArchiveHL7Message && !HL7AuditUtils.isOrderProcessed(this.hl7ConnEvent);
    }

    private static String outcome(Exception e) {
        return e != null ? e.getMessage() : null;
    }

    static AuditMessage auditMsg(AuditLogger auditLogger, Path path, AuditUtils.EventType eventType, IHL7ApplicationCache hl7AppCache, IApplicationEntityCache aeCache) throws ConfigurationException {
        ActiveParticipant[] activeParticipantArray;
        SpoolFileReader reader = new SpoolFileReader(path.toFile());
        AuditInfo auditInfo = new AuditInfo(reader.getMainInfo());
        if (auditInfo.getField(33) != null) {
            activeParticipantArray = PatientRecordAuditService.patVerActiveParticipants(auditLogger, eventType, auditInfo);
        } else if (eventType.source == null) {
            ActiveParticipant[] activeParticipantArray2 = new ActiveParticipant[1];
            activeParticipantArray = activeParticipantArray2;
            activeParticipantArray2[0] = PatientRecordAuditService.schedulerTriggered(auditLogger, auditInfo).build();
        } else {
            activeParticipantArray = auditInfo.getField(22) != null ? PatientRecordAuditService.outgoingActiveParticipants(auditLogger, eventType, auditInfo, hl7AppCache) : PatientRecordAuditService.incomingActiveParticipants(auditLogger, eventType, auditInfo, aeCache);
        }
        ActiveParticipant[] activeParticipants = activeParticipantArray;
        return AuditMessages.createMessage((EventIdentification)EventID.toEventIdentification(auditLogger, path, eventType, auditInfo), (ActiveParticipant[])activeParticipants, (ParticipantObjectIdentification[])new ParticipantObjectIdentification[]{ParticipantObjectID.patientPOI(auditInfo, reader)});
    }

    private static ActiveParticipantBuilder schedulerTriggered(AuditLogger auditLogger, AuditInfo auditInfo) {
        return new ActiveParticipantBuilder(auditInfo.getField(1), PatientRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).isRequester();
    }

    private static ActiveParticipant[] patVerActiveParticipants(AuditLogger auditLogger, AuditUtils.EventType et, AuditInfo auditInfo) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        String calledUserID = auditInfo.getField(2);
        String callingUserID = auditInfo.getField(1);
        ActiveParticipantBuilder calledUser = calledUserID == null ? PatientRecordAuditService.schedulerTriggered(auditLogger, auditInfo) : new ActiveParticipantBuilder(calledUserID, PatientRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).altUserID(AuditLogger.processID());
        activeParticipants[0] = PatientRecordAuditService.pdqService(et, auditInfo);
        activeParticipants[1] = calledUser.roleIDCode(new AuditMessages.RoleIDCode[]{et.destination}).build();
        if (calledUserID != null) {
            activeParticipants[2] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build();
        }
        return activeParticipants;
    }

    private static ActiveParticipant pdqService(AuditUtils.EventType et, AuditInfo auditInfo) {
        String pdqServiceURI = auditInfo.getField(33);
        return new ActiveParticipantBuilder(pdqServiceURI, null).userIDTypeCode(pdqServiceURI.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{et.source}).build();
    }

    private static ActiveParticipant[] incomingActiveParticipants(AuditLogger auditLogger, AuditUtils.EventType et, AuditInfo auditInfo, IApplicationEntityCache aeCache) {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[3];
        String archiveUserID = auditInfo.getField(2);
        String callingUserID = auditInfo.getField(1);
        AuditMessages.UserIDTypeCode archiveUserIDTypeCode = PatientRecordAuditService.userIDTypeCode(archiveUserID);
        ActiveParticipantBuilder calledUser = new ActiveParticipantBuilder(archiveUserID, PatientRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{et.destination});
        ActiveParticipantBuilder callingUser = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditService.remoteUserIDTypeCode(archiveUserIDTypeCode, callingUserID)).roleIDCode(new AuditMessages.RoleIDCode[]{et.source});
        String findScp = auditInfo.getField(37);
        if (findScp == null) {
            activeParticipants[0] = calledUser.build();
            activeParticipants[1] = callingUser.isRequester().build();
        } else if (callingUserID.equals(findScp)) {
            activeParticipants[0] = callingUser.build();
            activeParticipants[1] = calledUser.isRequester().build();
        } else {
            activeParticipants[0] = callingUser.isRequester().build();
            activeParticipants[1] = new ActiveParticipantBuilder(auditInfo.getField(12), PatientRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(archiveUserIDTypeCode).altUserID(AuditLogger.processID()).roleIDCode(new AuditMessages.RoleIDCode[]{et.destination}).build();
            activeParticipants[2] = new ActiveParticipantBuilder(findScp, AuditUtils.findScpHost(findScp, aeCache)).userIDTypeCode(AuditMessages.UserIDTypeCode.StationAETitle).roleIDCode(new AuditMessages.RoleIDCode[]{et.source}).build();
        }
        return activeParticipants;
    }

    private static ActiveParticipant[] outgoingActiveParticipants(AuditLogger auditLogger, AuditUtils.EventType et, AuditInfo auditInfo, IHL7ApplicationCache hl7AppCache) throws ConfigurationException {
        ActiveParticipant[] activeParticipants = new ActiveParticipant[4];
        HL7DeviceExtension hl7Dev = (HL7DeviceExtension)auditLogger.getDevice().getDeviceExtension(HL7DeviceExtension.class);
        String calledUserID = auditInfo.getField(2);
        String callingUserID = auditInfo.getField(1);
        String hl7SendingAppWithFacility = auditInfo.getField(23);
        String hl7ReceivingAppWithFacility = auditInfo.getField(24);
        HL7Application hl7AppSender = hl7Dev.getHL7Application(hl7SendingAppWithFacility, true);
        boolean isHL7Forward = hl7SendingAppWithFacility.equals(callingUserID) && hl7ReceivingAppWithFacility.equals(calledUserID);
        activeParticipants[0] = PatientRecordAuditService.hl7Sender(et, hl7SendingAppWithFacility, hl7AppSender);
        activeParticipants[1] = PatientRecordAuditService.hl7Receiver(et, hl7AppCache, hl7ReceivingAppWithFacility);
        if (isHL7Forward) {
            activeParticipants[2] = new ActiveParticipantBuilder(auditLogger.getDevice().getDeviceName(), PatientRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.DeviceName).altUserID(AuditLogger.processID()).isRequester().build();
        } else {
            activeParticipants[2] = new ActiveParticipantBuilder(callingUserID, auditInfo.getField(0)).userIDTypeCode(AuditMessages.userIDTypeCode((String)callingUserID)).isRequester().build();
            activeParticipants[3] = new ActiveParticipantBuilder(calledUserID, PatientRecordAuditService.getLocalHostName(auditLogger)).userIDTypeCode(AuditMessages.UserIDTypeCode.URI).altUserID(AuditLogger.processID()).build();
        }
        return activeParticipants;
    }

    private static ActiveParticipant hl7Receiver(AuditUtils.EventType et, IHL7ApplicationCache hl7AppCache, String hl7ReceivingAppWithFacility) throws ConfigurationException {
        HL7Application hl7AppReceiver = hl7AppCache.findHL7Application(hl7ReceivingAppWithFacility);
        return new ActiveParticipantBuilder(hl7ReceivingAppWithFacility, ((Connection)hl7AppReceiver.getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.ApplicationFacility).roleIDCode(new AuditMessages.RoleIDCode[]{et.destination}).build();
    }

    private static ActiveParticipant hl7Sender(AuditUtils.EventType et, String hl7SendingAppWithFacility, HL7Application hl7AppSender) {
        return new ActiveParticipantBuilder(hl7SendingAppWithFacility, ((Connection)hl7AppSender.getConnections().get(0)).getHostname()).userIDTypeCode(AuditMessages.UserIDTypeCode.ApplicationFacility).roleIDCode(new AuditMessages.RoleIDCode[]{et.source}).build();
    }

    private static String getLocalHostName(AuditLogger auditLogger) {
        return ((Connection)auditLogger.getConnections().get(0)).getHostname();
    }

    private static AuditMessages.UserIDTypeCode userIDTypeCode(String userID) {
        return userID.indexOf(47) != -1 ? AuditMessages.UserIDTypeCode.URI : (userID.indexOf(124) != -1 ? AuditMessages.UserIDTypeCode.ApplicationFacility : AuditMessages.UserIDTypeCode.StationAETitle);
    }
}

