/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.imageio.codec.jpeg.PatchJPEGLSImageInputStream;
import org.dcm4che3.imageio.stream.EncapsulatedPixelDataImageInputStream;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DecompressSupport
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DecompressSupport.class);
    private final RetrieveContext ctx;
    protected final InstanceLocations inst;
    private ImageReaderFactory.ImageReaderParam decompressorParam;
    private ImageReader decompressor;
    private ImageReadParam decompressParam;
    private BufferedImage bi;
    private DicomInputStream dis;
    protected EncapsulatedPixelDataImageInputStream encapsulatedPixelData;

    DecompressSupport(RetrieveContext ctx, InstanceLocations inst) {
        this.ctx = ctx;
        this.inst = inst;
    }

    protected void initEncapsulatedPixelData() throws IOException {
        RetrieveService service = this.ctx.getRetrieveService();
        this.dis = service.openDicomInputStream(this.ctx, this.inst);
        Attributes attrs = this.dis.readDataset(-1, 2145386512);
        if (this.dis.tag() != 2145386512 || this.dis.length() != -1) {
            throw new IOException("No or incorrect encapsulated compressed pixel data in requested object");
        }
        ImageDescriptor imageDescriptor = new ImageDescriptor(attrs);
        String tsuid = this.dis.getTransferSyntax();
        TransferSyntaxType tsType = TransferSyntaxType.forUID((String)tsuid);
        this.encapsulatedPixelData = new EncapsulatedPixelDataImageInputStream(this.dis, imageDescriptor, tsType);
        this.initDecompressor(tsuid, tsType, imageDescriptor);
        if (tsType == TransferSyntaxType.RLE) {
            this.initBufferedImage(imageDescriptor);
        }
    }

    @Override
    public void close() {
        SafeClose.close((Closeable)this.encapsulatedPixelData);
        this.encapsulatedPixelData = null;
        SafeClose.close((Closeable)this.dis);
        this.dis = null;
        if (this.decompressor != null) {
            this.decompressor.dispose();
            this.decompressor = null;
        }
    }

    private void initDecompressor(String tsuid, TransferSyntaxType tsType, ImageDescriptor imageDescriptor) {
        this.decompressorParam = ImageReaderFactory.getImageReaderParam((String)tsuid);
        if (this.decompressorParam == null) {
            throw new UnsupportedOperationException("Unsupported Transfer Syntax: " + tsuid);
        }
        this.decompressor = ImageReaderFactory.getImageReader((ImageReaderFactory.ImageReaderParam)this.decompressorParam);
        this.decompressParam = this.decompressor.getDefaultReadParam();
    }

    private void initBufferedImage(ImageDescriptor imageDescriptor) {
        int rows = imageDescriptor.getRows();
        int cols = imageDescriptor.getColumns();
        int samples = imageDescriptor.getSamples();
        int bitsAllocated = imageDescriptor.getBitsAllocated();
        int bitsStored = imageDescriptor.getBitsStored();
        boolean signed = imageDescriptor.isSigned();
        int dataType = bitsAllocated > 8 ? (signed ? 2 : 1) : 0;
        ComponentColorModel cm = samples == 1 ? new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{bitsStored}, false, false, 1, dataType) : new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{bitsStored, bitsStored, bitsStored}, false, false, 1, dataType);
        BandedSampleModel sm = new BandedSampleModel(dataType, cols, rows, samples);
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        this.bi = new BufferedImage(cm, raster, false, null);
    }

    protected BufferedImage decompressFrame(int frameIndex) throws IOException {
        if (this.encapsulatedPixelData.isEndOfStream()) {
            throw new IOException("Number of data fragments not sufficient for number of frames in requested object");
        }
        this.decompressor.setInput(this.decompressorParam.patchJPEGLS != null ? new PatchJPEGLSImageInputStream((ImageInputStream)this.encapsulatedPixelData, this.decompressorParam.patchJPEGLS) : this.encapsulatedPixelData);
        this.decompressParam.setDestination(this.bi);
        long start = System.currentTimeMillis();
        this.bi = this.decompressor.read(0, this.decompressParam);
        long end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Decompressed frame #{} 1:{} in {} ms", new Object[]{frameIndex + 1, Float.valueOf((float)DecompressSupport.sizeOf(this.bi) / (float)this.encapsulatedPixelData.getStreamPosition()), end - start});
        }
        this.encapsulatedPixelData.seekNextFrame();
        return this.bi;
    }

    protected void writeFrameTo(OutputStream out) throws IOException {
        WritableRaster raster = this.bi.getRaster();
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        switch (db.getDataType()) {
            case 0: {
                this.writeTo(sm, ((DataBufferByte)db).getBankData(), out);
                break;
            }
            case 1: {
                DecompressSupport.writeTo(sm, ((DataBufferUShort)db).getData(), out);
                break;
            }
            case 2: {
                DecompressSupport.writeTo(sm, ((DataBufferShort)db).getData(), out);
                break;
            }
            case 3: {
                DecompressSupport.writeTo(sm, ((DataBufferInt)db).getData(), out);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported Datatype: " + db.getDataType());
            }
        }
    }

    private static int sizeOf(BufferedImage bi) {
        DataBuffer db = bi.getData().getDataBuffer();
        return db.getSize() * db.getNumBanks() * (DataBuffer.getDataTypeSize(db.getDataType()) / 8);
    }

    private void writeTo(SampleModel sm, byte[][] bankData, OutputStream out) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        ComponentSampleModel csm = (ComponentSampleModel)sm;
        int len = w * csm.getPixelStride();
        int stride = csm.getScanlineStride();
        if (csm.getBandOffsets()[0] != 0) {
            DecompressSupport.bgr2rgb(bankData[0]);
        }
        for (byte[] b : bankData) {
            int y = 0;
            int off = 0;
            while (y < h) {
                out.write(b, off, len);
                ++y;
                off += stride;
            }
        }
    }

    private static void bgr2rgb(byte[] bs) {
        int i = 0;
        for (int j = 2; j < bs.length; j += 3) {
            byte b = bs[i];
            bs[i] = bs[j];
            bs[j] = b;
            i += 3;
        }
    }

    private static void writeTo(SampleModel sm, short[] data, OutputStream out) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((ComponentSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 2];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                short s = data[j++];
                b[i++] = (byte)s;
                b[i++] = (byte)(s >> 8);
            }
            out.write(b);
        }
    }

    private static void writeTo(SampleModel sm, int[] data, OutputStream out) throws IOException {
        int h = sm.getHeight();
        int w = sm.getWidth();
        int stride = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        byte[] b = new byte[w * 3];
        for (int y = 0; y < h; ++y) {
            int i = 0;
            int j = y * stride;
            while (i < b.length) {
                int s = data[j++];
                b[i++] = (byte)(s >> 16);
                b[i++] = (byte)(s >> 8);
                b[i++] = (byte)s;
            }
            out.write(b);
        }
    }
}

