/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedFramesOutput
implements StreamingOutput,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CompressedFramesOutput.class);
    private final RetrieveContext ctx;
    private final InstanceLocations inst;
    private DicomInputStream dis;
    private final int[] frameList;
    private final Path[] spoolFiles;
    private final Path spoolDirectory;
    private int frame = 1;
    private int frameListIndex;

    public CompressedFramesOutput(RetrieveContext ctx, InstanceLocations inst, int[] frameList, Path spoolDirectory) {
        this.ctx = ctx;
        this.inst = inst;
        this.frameList = frameList;
        this.spoolDirectory = spoolDirectory;
        this.spoolFiles = spoolDirectory != null ? new Path[frameList.length] : null;
    }

    public void write(OutputStream out) throws IOException {
        try {
            if (this.frameListIndex == 0) {
                this.initDicomInputStream();
            }
            if (this.dis == null) {
                Files.copy(this.spoolFiles[this.frameListIndex++], out);
                return;
            }
            int nextFrame = this.frameList[this.frameListIndex++];
            while (this.frame < nextFrame) {
                this.skipFrame();
                ++this.frame;
            }
            if (!this.dis.readItemHeader()) {
                throw new IOException("Number of data fragments not sufficient for number of frames in requested object");
            }
            LOG.debug("Start writing compressed frame of {}", (Object)this.inst);
            StreamUtils.copy((InputStream)this.dis, (OutputStream)out, (int)this.dis.length());
            LOG.debug("Finished writing compressed frame of {}", (Object)this.inst);
            ++this.frame;
            if (this.allFramesRead()) {
                this.close();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private void skipFrame() throws IOException {
        if (!this.dis.readItemHeader()) {
            throw new IOException("Number of data fragments not sufficient for number of frames in requested object");
        }
        for (int i = this.frameListIndex; i < this.frameList.length; ++i) {
            if (this.frame != this.frameList[i]) continue;
            this.spoolFiles[i] = Files.createTempFile(this.spoolDirectory, null, null, new FileAttribute[0]);
            try (OutputStream o = Files.newOutputStream(this.spoolFiles[i], new OpenOption[0]);){
                StreamUtils.copy((InputStream)this.dis, (OutputStream)o, (int)this.dis.length());
            }
            return;
        }
        this.dis.skipFully((long)this.dis.length());
    }

    private boolean allFramesRead() {
        for (int i = this.frameListIndex; i < this.frameList.length; ++i) {
            if (this.frame > this.frameList[i]) continue;
            return false;
        }
        return true;
    }

    private void initDicomInputStream() throws IOException {
        RetrieveService service = this.ctx.getRetrieveService();
        this.dis = service.openDicomInputStream(this.ctx, this.inst);
        this.dis.readDataset(-1, 2145386512);
        if (this.dis.tag() != 2145386512 || this.dis.length() != -1 || !this.dis.readItemHeader()) {
            throw new IOException("No or incorrect encapsulated compressed pixel data in requested object");
        }
        this.dis.skipFully((long)this.dis.length());
    }

    @Override
    public void close() {
        SafeClose.close((Closeable)this.dis);
        this.dis = null;
    }
}

