/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.wado;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkdataOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(BulkdataOutput.class);
    private final RetrieveContext ctx;
    private final InstanceLocations inst;
    private final int[] attributePath;

    public BulkdataOutput(RetrieveContext ctx, InstanceLocations inst, int ... attributePath) {
        this.ctx = ctx;
        this.inst = inst;
        this.attributePath = attributePath;
    }

    public void write(OutputStream out) throws IOException {
        RetrieveService service = this.ctx.getRetrieveService();
        try (DicomInputStream dis = service.openDicomInputStream(this.ctx, this.inst);){
            Attributes attrs = null;
            for (int level = 0; level < this.attributePath.length; ++level) {
                int i;
                if ((level & 1) == 0) {
                    int stopTag = this.attributePath[level];
                    if (attrs == null) {
                        attrs = dis.readDataset(-1, stopTag);
                    } else {
                        dis.readAttributes(attrs, -1L, stopTag);
                    }
                    if (dis.tag() == stopTag) continue;
                    throw new IOException(this.missingBulkdata());
                }
                int index = this.attributePath[level];
                for (i = 0; i < index && dis.readItemHeader(); ++i) {
                    boolean undefLen;
                    int len = dis.length();
                    boolean bl = undefLen = len == -1;
                    if (undefLen) {
                        Attributes item = new Attributes(attrs.bigEndian());
                        dis.readAttributes(item, (long)len, -73715);
                        continue;
                    }
                    dis.skipFully((long)len);
                }
                if (i >= index && dis.readItemHeader()) continue;
                throw new IOException(this.missingBulkdata());
            }
            LOG.debug("Start writing {} bytes", (Object)dis.length());
            StreamUtils.copy((InputStream)dis, (OutputStream)out, (int)dis.length());
            LOG.debug("Finished writing {} bytes", (Object)dis.length());
        }
    }

    private String missingBulkdata() {
        StringBuilder sb = new StringBuilder();
        sb.append("No bulkdata ");
        for (int i = 0; i < this.attributePath.length; ++i) {
            if ((i & 1) == 0) {
                sb.append(TagUtils.toString((int)this.attributePath[i]));
                continue;
            }
            sb.append('[').append(this.attributePath[i]).append(']');
        }
        sb.append(" in requested object");
        return sb.toString();
    }
}

