/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.rs;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.UIDUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.UPSUtils;
import org.dcm4chee.arc.ups.rs.InputType;
import org.dcm4chee.arc.ups.rs.UpsCSV;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=UpsMatchingRS.class)
public class UpsMatchingRS {
    private static final Logger LOG = LoggerFactory.getLogger(UpsMatchingRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders headers;
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private UPSService upsService;
    @javax.ws.rs.QueryParam(value="upsLabel")
    private String upsLabel;
    @javax.ws.rs.QueryParam(value="upsScheduledTime")
    private String upsScheduledTime;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="incomplete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String incomplete;
    @javax.ws.rs.QueryParam(value="retrievefailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String retrievefailed;
    @javax.ws.rs.QueryParam(value="storageVerificationFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationFailed;
    @javax.ws.rs.QueryParam(value="metadataUpdateFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String metadataUpdateFailed;
    @javax.ws.rs.QueryParam(value="compressionfailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String compressionfailed;
    @javax.ws.rs.QueryParam(value="StudySizeInKB")
    @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}")
    private @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}") String studySizeInKB;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET")
    private String externalRetrieveAET;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET!")
    private String externalRetrieveAETNot;
    @javax.ws.rs.QueryParam(value="ExpirationDate")
    private String expirationDate;
    @javax.ws.rs.QueryParam(value="ExpirationState")
    @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT")
    private @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT") String expirationState;
    @javax.ws.rs.QueryParam(value="allOfModalitiesInStudy")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String allOfModalitiesInStudy;
    @javax.ws.rs.QueryParam(value="storageID")
    private String storageID;
    @javax.ws.rs.QueryParam(value="storageClustered")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageClustered;
    @javax.ws.rs.QueryParam(value="storageExported")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageExported;

    @POST
    @Path(value="/studies/workitems")
    @Produces(value={"application/json"})
    public Response upsMatchingStudies(InputStream in) {
        return this.createWorkitemsMatching("upsMatchingStudies", QueryRetrieveLevel2.STUDY, null, null, in);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/workitems")
    @Produces(value={"application/json"})
    public Response upsMatchingStudies(@PathParam(value="StudyInstanceUID") String studyInstanceUID, InputStream in) {
        return this.createWorkitemsMatching("upsMatchingSeriesOfStudy", QueryRetrieveLevel2.SERIES, studyInstanceUID, null, in);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/workitems")
    @Produces(value={"application/json"})
    public Response upsMatchingStudies(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID, InputStream in) {
        return this.createWorkitemsMatching("upsMatchingInstancesOfSeries", QueryRetrieveLevel2.IMAGE, studyInstanceUID, seriesInstanceUID, in);
    }

    @POST
    @Path(value="/studies/csv:{field}/workitems/{upsTemplateUID}")
    public Response createWorkitems(@PathParam(value="field") int field, @PathParam(value="upsTemplateUID") String upsTemplateUID, @javax.ws.rs.QueryParam(value="csvPatientID") String csvPatientIDField, InputStream in) {
        return this.createWorkitemsFromCSV(field, upsTemplateUID, csvPatientIDField, in);
    }

    private Response createWorkitemsMatching(String method, QueryRetrieveLevel2 qrlevel, String studyIUID, String seriesIUID, InputStream in) {
        InputType inputType = InputType.valueOf(this.headers.getMediaType());
        if (inputType == null) {
            return this.notAcceptable();
        }
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse(Response.Status.NOT_FOUND, "No such Application Entity: " + this.aet);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
            Attributes upsTemplateAttrs = inputType.parse(in);
            upsTemplateAttrs.setDate(0x404005, VR.DT, new Date[]{this.scheduledTime()});
            if (this.upsLabel != null) {
                upsTemplateAttrs.setString(7606788, VR.LO, this.upsLabel);
            }
            QueryContext ctx = this.queryContext(method, qrlevel, studyIUID, seriesIUID, arcAE.getApplicationEntity());
            String warning = null;
            AtomicInteger count = new AtomicInteger();
            Response.Status status = Response.Status.ACCEPTED;
            Attributes ups = new Attributes(upsTemplateAttrs);
            int matches = 0;
            try (Query query = this.queryService.createQuery(ctx);){
                try {
                    query.executeQuery(arcDev.getQueryFetchSize());
                    while (query.hasMoreMatches()) {
                        Attributes match = query.nextMatch();
                        if (match == null) continue;
                        ups = studyIUID == null ? new Attributes(upsTemplateAttrs) : ups;
                        UPSUtils.updateUPSAttributes((Attributes)ups, (Attributes)match, (String)studyIUID, (String)seriesIUID, (String)this.aet);
                        ++matches;
                        if (studyIUID != null) continue;
                        this.createUPS(arcAE, ups, count);
                    }
                    if (matches > 0 && studyIUID != null) {
                        this.createUPS(arcAE, ups, count);
                    }
                }
                catch (Exception e) {
                    warning = e.getMessage();
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                }
            }
            if (count.get() == 0) {
                warning = "No matching Instances found. No Workitem was created.";
                status = Response.Status.NO_CONTENT;
            }
            Response.ResponseBuilder builder = Response.status((Response.Status)status);
            if (warning != null) {
                LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
                builder.header("Warning", (Object)warning);
            }
            return builder.entity((Object)("{\"count\":" + count + "}")).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Attributes upsTemplateAttrs(String upsTemplateUID, ArchiveAEExtension arcAE) throws DicomServiceException {
        UPSContext ctx = this.upsService.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE);
        ctx.setUPSInstanceUID(upsTemplateUID);
        Attributes upsAttrs = this.upsService.findUPS(ctx).getAttributes();
        upsAttrs.setDate(0x404005, VR.DT, new Date[]{this.scheduledTime()});
        if (this.upsLabel != null) {
            upsAttrs.setString(7606788, VR.LO, this.upsLabel);
        }
        return upsAttrs;
    }

    private void createUPS(ArchiveAEExtension arcAE, Attributes ups, AtomicInteger count) {
        UPSContext ctx = this.upsService.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE);
        ctx.setUPSInstanceUID(UIDUtils.createUID());
        ctx.setAttributes(ups);
        try {
            this.upsService.createUPS(ctx);
            count.getAndIncrement();
        }
        catch (DicomServiceException e) {
            LOG.info("Failed to create UPS record for Study[uid={}]\n", (Object)((Attributes)ups.getSequence(4210721).get(0)).getString(0x20000D), (Object)e);
        }
    }

    private Response createWorkitemsFromCSV(int studyUIDField, String upsTemplateUID, String csvPatientIDField, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse(Response.Status.NOT_FOUND, "No such Application Entity: " + this.aet);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        Response.Status status = Response.Status.BAD_REQUEST;
        if (studyUIDField < 1) {
            return this.errResponse(status, "CSV field for Study Instance UID should be greater than or equal to 1");
        }
        int patientIDField = 0;
        if (csvPatientIDField != null && (patientIDField = this.patientIDField(csvPatientIDField)) < 1) {
            return this.errResponse(status, "CSV field for Patient ID should be greater than or equal to 1");
        }
        try {
            UpsCSV upsCSV = new UpsCSV(this.upsService, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request).setContentType(this.headers), arcAE, this.upsTemplateAttrs(upsTemplateUID, arcAE));
            return upsCSV.createWorkitems(studyUIDField, patientIDField, null, in);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsMatchingRS::createFailed, e);
        }
        catch (IllegalStateException e) {
            return this.errResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        if (ae == null || !ae.isInstalled()) {
            throw new WebApplicationException("No such Archive Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        return (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    private int patientIDField(String csvPatientIDField) {
        try {
            return Integer.parseInt(csvPatientIDField);
        }
        catch (NumberFormatException e) {
            LOG.info("CSV Patient ID Field {} cannot be parsed", (Object)csvPatientIDField);
            return 0;
        }
    }

    private QueryContext queryContext(String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, String seriesInstanceUID, ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), method, this.aet, ae, this.queryParam(ae));
        ctx.setQueryRetrieveLevel(qrlevel);
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        if (studyInstanceUID != null) {
            keys.setString(0x20000D, VR.UI, studyInstanceUID);
        }
        if (seriesInstanceUID != null) {
            keys.setString(0x20000E, VR.UI, seriesInstanceUID);
        }
        ctx.setQueryKeys(keys);
        Attributes returnKeys = new Attributes(3);
        returnKeys.setNull(0x20000D, VR.UI);
        switch (qrlevel) {
            case IMAGE: {
                returnKeys.setNull(524312, VR.UI);
            }
            case SERIES: {
                returnKeys.setNull(0x20000E, VR.UI);
            }
        }
        ctx.setReturnKeys(returnKeys);
        return ctx;
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setIncomplete(Boolean.parseBoolean(this.incomplete));
        queryParam.setRetrieveFailed(Boolean.parseBoolean(this.retrievefailed));
        queryParam.setStorageVerificationFailed(Boolean.parseBoolean(this.storageVerificationFailed));
        queryParam.setMetadataUpdateFailed(Boolean.parseBoolean(this.metadataUpdateFailed));
        queryParam.setCompressionFailed(Boolean.parseBoolean(this.compressionfailed));
        queryParam.setExternalRetrieveAET(this.externalRetrieveAET);
        queryParam.setExternalRetrieveAETNot(this.externalRetrieveAETNot);
        queryParam.setExpirationDate(this.expirationDate);
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        queryParam.setStudySizeRange(this.studySizeInKB);
        if (this.expirationState != null) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.valueOf((String)this.expirationState)});
        }
        return queryParam;
    }

    public void validate() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        new QueryAttributes(this.uriInfo, null);
    }

    private Date scheduledTime() {
        if (this.upsScheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.upsScheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    private static Response.Status createFailed(int status) {
        switch (status) {
            case 49927: {
                return Response.Status.NOT_FOUND;
            }
            case 273: {
                return Response.Status.CONFLICT;
            }
            case 261: 
            case 262: 
            case 288: 
            case 289: 
            case 49929: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private Response notAcceptable() {
        LOG.info("Response Status : Not Acceptable. Content Type in request : \n{}", (Object)this.headers.getMediaType());
        return Response.notAcceptable((List)Variant.mediaTypes((MediaType[])new MediaType[]{MediaTypes.APPLICATION_DICOM_JSON_TYPE, MediaTypes.APPLICATION_DICOM_XML_TYPE}).build()).build();
    }

    private Response errResponse(IntFunction<Response.Status> httpStatusOf, DicomServiceException e) {
        return this.errResponse(httpStatusOf.apply(e.getStatus()), e.getMessage());
    }

    private Response errResponse(Response.Status status, String message) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + message + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse(Response.Status.NOT_FOUND, "No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet)));
    }
}

