/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.rs;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.ups.UPSEvent;
import org.dcm4chee.arc.ups.UPSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@ServerEndpoint(value="/aets/{AETitle}/ws/subscribers/{SubscriberAET}")
public class EventReportSender {
    private static final Logger LOG = LoggerFactory.getLogger(EventReportSender.class);
    private final AtomicInteger messageID = new AtomicInteger(0);
    private final Map<String, Queue<UPSEvent>> queueMap = new HashMap<String, Queue<UPSEvent>>();
    @Inject
    private UPSService service;
    @Inject
    private Device device;

    @OnOpen
    public void open(Session session, @PathParam(value="AETitle") String aet, @PathParam(value="SubscriberAET") String subscriberAET) {
        LOG.info("{} open /aets/{}/ws/subscribers/{} ", new Object[]{session, aet, subscriberAET});
        Queue<UPSEvent> queue = this.queueMap.remove(subscriberAET);
        if (queue != null) {
            List<Session> sessions = Collections.singletonList(session);
            queue.stream().forEach(queuedEvent -> this.send((UPSEvent)queuedEvent, this.toInprocessStateReportJson((UPSEvent)queuedEvent), this.toJson((UPSEvent)queuedEvent), subscriberAET, sessions));
        }
        this.service.registerWebsocketChannel(session, aet, subscriberAET);
    }

    @OnClose
    public void close(Session session, @PathParam(value="AETitle") String aet, @PathParam(value="SubscriberAET") String subscriberAET) {
        LOG.info("{} close /aets/{}/ws/subscribers/{} ", new Object[]{session, aet, subscriberAET});
        this.service.unregisterWebsocketChannel(session);
    }

    @OnError
    public void error(Session session, Throwable thr, @PathParam(value="AETitle") String aet, @PathParam(value="SubscriberAET") String subscriberAET) {
        LOG.warn("{} error /aets/{}/ws/subscribers/{}:\n", new Object[]{session, aet, subscriberAET, thr});
    }

    public void onUPSEvent(@Observes UPSEvent event) {
        Optional<String> inprocessStateReport = this.toInprocessStateReportJson(event);
        String json = this.toJson(event);
        for (String subscriberAET : event.subscriberAETs) {
            List sessions = this.service.getWebsocketChannels(subscriberAET);
            if (sessions.isEmpty()) {
                LOG.info("No Websocket channel to send {} EventReport to {}", (Object)event.type, (Object)subscriberAET);
                this.queueUPSEvent(subscriberAET, event);
                continue;
            }
            this.send(event, inprocessStateReport, json, subscriberAET, sessions);
        }
    }

    private void send(UPSEvent event, Optional<String> inprocessStateReport, String json, String subscriberAET, List<Session> sessions) {
        try {
            LOG.info("Send {} EventReport to {}", (Object)event.type, (Object)subscriberAET);
            if (inprocessStateReport.isPresent()) {
                this.send(inprocessStateReport.get(), sessions);
            }
            this.send(json, sessions);
        }
        catch (IOException e) {
            LOG.warn("Failed to send {} EventReport to {}:\n", new Object[]{event.type, subscriberAET, e});
        }
    }

    private synchronized void queueUPSEvent(String subscriberAET, UPSEvent event) {
        int queueSize = ((ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class)).getUPSEventWebSocketQueueSize(subscriberAET);
        if (queueSize > 0) {
            LOG.info("Queue {} EventReport to {}", (Object)event.type, (Object)subscriberAET);
            Queue queue = this.queueMap.computeIfAbsent(subscriberAET, s -> new ArrayDeque(queueSize));
            queue.offer(event);
            while (queue.size() > queueSize) {
                queue.poll();
            }
        } else {
            this.queueMap.remove(subscriberAET);
        }
    }

    private Optional<String> toInprocessStateReportJson(UPSEvent event) {
        return event.inprocessStateReport().map(attrs -> this.toJson(event, (Attributes)attrs));
    }

    private String toJson(UPSEvent event) {
        return this.toJson(event, new Attributes(event.attrs));
    }

    private String toJson(UPSEvent event, Attributes attrs) {
        StringWriter out = new StringWriter(256);
        try (JsonGenerator gen = Json.createGenerator((Writer)out);){
            event.getArchiveAEExtension().encodeAsJSONNumber(new JSONWriter(gen)).write(event.withCommandAttributes(attrs, this.messageID.incrementAndGet()));
        }
        return out.toString();
    }

    private void send(String json, List<Session> sessions) throws IOException {
        IOException e1 = null;
        for (Session session : sessions) {
            try {
                session.getBasicRemote().sendText(json);
                return;
            }
            catch (IOException e) {
                this.service.unregisterWebsocketChannel(session);
                e1 = e;
                LOG.info("{} error:\n", (Object)session, (Object)e1);
            }
        }
        throw e1;
    }
}

