/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scu.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.enterprise.event.Event;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.CancelRQHandler;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4che3.util.SafeClose;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.scu.impl.TranscoderDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RetrieveTaskImpl
implements RetrieveTask {
    static final Logger LOG = LoggerFactory.getLogger(RetrieveTaskImpl.class);
    private final Event<RetrieveContext> retrieveStart;
    private final Event<RetrieveContext> retrieveEnd;
    private final RetrieveContext ctx;
    private final Association[] storeass;
    private final ArchiveAEExtension aeExt;
    private final BlockingQueue<WrappedInstanceLocations> matches = new LinkedBlockingQueue<WrappedInstanceLocations>();
    private final CountDownLatch doneSignal;
    private Dimse dimserq;
    private Association rqas;
    private PresentationContext pc;
    private Attributes rqCmd;
    private int msgId;
    private boolean pendingRSP;
    private Duration pendingRSPInterval;
    private volatile boolean canceled;

    RetrieveTaskImpl(RetrieveContext ctx, Event<RetrieveContext> retrieveStart, Event<RetrieveContext> retrieveEnd, Association ... storeass) {
        this.retrieveStart = retrieveStart;
        this.retrieveEnd = retrieveEnd;
        this.ctx = ctx;
        this.storeass = storeass;
        this.aeExt = ctx.getArchiveAEExtension();
        this.doneSignal = new CountDownLatch(storeass.length);
    }

    void setRequestAssociation(Dimse dimserq, Association rqas, PresentationContext pc, Attributes rqCmd) {
        this.dimserq = dimserq;
        this.rqas = rqas;
        this.pc = pc;
        this.rqCmd = rqCmd;
        this.msgId = rqCmd.getInt(272, 0);
        this.pendingRSP = dimserq == Dimse.C_GET_RQ && this.aeExt.sendPendingCGet();
        this.pendingRSPInterval = dimserq == Dimse.C_MOVE_RQ ? this.aeExt.sendPendingCMoveInterval() : null;
        rqas.addCancelRQHandler(this.msgId, (CancelRQHandler)this);
    }

    public void onCancelRQ(Association association) {
        this.canceled = true;
    }

    public void run() {
        this.retrieveStart.fire((Object)this.ctx);
        try {
            if (this.ctx.getFallbackAssociation() == null) {
                this.startWritePendingRSP();
            }
            if (this.storeass.length > 1) {
                this.startStoreOperations();
            }
            for (InstanceLocations match : this.ctx.getMatches()) {
                if (this.ctx.copyToRetrieveCache(match)) continue;
                this.matches.offer(new WrappedInstanceLocations(match));
            }
            this.ctx.copyToRetrieveCache(null);
            if (this.storeass.length == 1) {
                this.matches.offer(new WrappedInstanceLocations(null));
                this.runStoreOperations(this.storeass[0]);
            } else {
                InstanceLocations match;
                while ((match = this.ctx.copiedToRetrieveCache()) != null && !this.canceled) {
                    this.matches.offer(new WrappedInstanceLocations(match));
                }
                for (int i = 0; i < this.storeass.length; ++i) {
                    this.matches.offer(new WrappedInstanceLocations(null));
                }
            }
            this.waitForPendingStoreOperations();
        }
        finally {
            this.waitForPendingCMoveForward();
            this.waitForPendingCStoreForward();
            this.updateCompleteness();
            this.ctx.getRetrieveService().updateLocations(this.ctx);
            this.ctx.getRetrieveService().updateInstanceAvailability(this.ctx);
            this.ctx.stopWritePendingRSP();
            if (this.rqas != null) {
                this.writeFinalRSP();
                this.rqas.removeCancelRQHandler(this.msgId);
            }
            SafeClose.close((Closeable)this.ctx);
        }
        this.retrieveEnd.fire((Object)this.ctx);
    }

    private void startStoreOperations() {
        Device device = this.ctx.getArchiveAEExtension().getApplicationEntity().getDevice();
        for (Association storeas : this.storeass) {
            device.execute(() -> this.runStoreOperations(storeas));
        }
    }

    private void waitForPendingStoreOperations() {
        try {
            this.doneSignal.await();
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to wait for outstanding store operations", (Object)this.rqas, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStoreOperations(Association storeas) {
        List<InstanceLocations> outstandingRSPs = Collections.synchronizedList(new ArrayList());
        try {
            InstanceLocations match = null;
            while (!this.canceled && (match = this.matches.take().instanceLocations) != null) {
                this.store(match, storeas, outstandingRSPs);
                this.waitForNonBlockingInvoke(storeas);
            }
            while (!this.canceled && (match = this.ctx.copiedToRetrieveCache()) != null) {
                this.store(match, storeas, outstandingRSPs);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to fetch next match from queue:\n", (Object)this.rqas, (Object)e);
        }
        finally {
            this.waitForOutstandingCStoreRSP(storeas, outstandingRSPs);
            this.releaseStoreAssociation(storeas);
            this.doneSignal.countDown();
        }
    }

    private void waitForNonBlockingInvoke(Association storeas) {
        try {
            storeas.waitForNonBlockingInvoke();
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to wait for outstanding C-STORE RSP(s) on association to {}:\n", new Object[]{this.rqas != null ? this.rqas : storeas, storeas.getRemoteAET(), e});
        }
    }

    private void store(InstanceLocations inst, Association storeas, Collection<InstanceLocations> outstandingRSP) {
        CStoreRSPHandler rspHandler = new CStoreRSPHandler(inst, storeas, outstandingRSP);
        String iuid = inst.getSopInstanceUID();
        String cuid = inst.getSopClassUID();
        int priority = this.ctx.getPriority();
        Set tsuids = storeas.getTransferSyntaxesFor(cuid);
        try {
            RetrieveService service = this.ctx.getRetrieveService();
            try (Transcoder transcoder = service.openTranscoder(this.ctx, inst, (Collection)tsuids, false);){
                AttributesCoercion coerce;
                String tsuid = transcoder.getDestinationTransferSyntax();
                List coercions = service.getArchiveAttributeCoercions(this.ctx, inst);
                if (coercions.isEmpty()) {
                    ArchiveAttributeCoercion rule = service.getArchiveAttributeCoercion(this.ctx, inst);
                    if (rule != null) {
                        transcoder.setNullifyPixelData(rule.isNullifyPixelData());
                    }
                    coerce = service.getAttributesCoercion(this.ctx, inst, rule);
                } else {
                    transcoder.setNullifyPixelData(ArchiveAttributeCoercion2.containsScheme((Collection)coercions, (String)"nullify-pixel-data"));
                    coerce = service.getAttributesCoercion(this.ctx, inst, coercions);
                }
                iuid = coerce.remapUID(iuid);
                TranscoderDataWriter data = new TranscoderDataWriter(transcoder, coerce);
                outstandingRSP.add(inst);
                long startTime = System.nanoTime();
                if (this.ctx.getMoveOriginatorAETitle() != null) {
                    storeas.cstore(cuid, iuid, priority, this.ctx.getMoveOriginatorAETitle(), this.ctx.getMoveOriginatorMessageID(), (DataWriter)data, tsuid, (DimseRSPHandler)rspHandler);
                } else {
                    storeas.cstore(cuid, iuid, priority, (DataWriter)data, tsuid, (DimseRSPHandler)rspHandler);
                }
                service.getMetricsService().acceptDataRate("send-to-" + storeas.getRemoteAET(), data.getCount(), startTime);
            }
        }
        catch (Exception e) {
            outstandingRSP.remove(inst);
            this.ctx.incrementFailed();
            this.ctx.addFailedMatch(inst);
            LOG.warn("{}: failed to send {} to {}:", new Object[]{this.rqas != null ? this.rqas : storeas, inst, this.ctx.getDestinationAETitle(), e});
        }
    }

    private void writeFinalRSP() {
        int remaining = this.ctx.remaining();
        int completed = this.ctx.completed();
        int failed = this.ctx.failed();
        int warning = this.ctx.warning();
        if (!this.canceled) {
            this.ctx.addFailed(remaining);
            remaining = 0;
        }
        int status = remaining > 0 ? 65024 : this.ctx.status();
        Attributes cmd = Commands.mkRSP((Attributes)this.rqCmd, (int)status, (Dimse)this.dimserq);
        if (remaining > 0) {
            cmd.setInt(4128, VR.US, new int[]{remaining});
        }
        if (completed > 0) {
            cmd.setInt(4129, VR.US, new int[]{completed});
        }
        if (failed > 0) {
            cmd.setInt(4130, VR.US, new int[]{failed});
        }
        if (warning > 0) {
            cmd.setInt(4131, VR.US, new int[]{warning});
        }
        try {
            this.rqas.writeDimseRSP(this.pc, cmd, this.finalRSPDataset());
        }
        catch (IOException e) {
            LOG.warn("{}: Unable to send C-GET or C-MOVE RSP on association to {}", new Object[]{this.rqas, this.rqas.getRemoteAET(), e});
        }
    }

    private Attributes finalRSPDataset() {
        String[] failedIUIDs;
        if (this.ctx.failed() == 0 || (failedIUIDs = this.ctx.failedSOPInstanceUIDs()).length == 0) {
            return null;
        }
        Attributes attrs = new Attributes(1);
        attrs.setString(524376, VR.UI, failedIUIDs);
        return attrs;
    }

    private void writePendingRSP() {
        if (this.canceled) {
            return;
        }
        int remaining = this.ctx.remaining();
        if (remaining > 0) {
            Attributes cmd = Commands.mkRSP((Attributes)this.rqCmd, (int)65280, (Dimse)this.dimserq);
            cmd.setInt(4128, VR.US, new int[]{remaining});
            cmd.setInt(4129, VR.US, new int[]{this.ctx.completed()});
            cmd.setInt(4130, VR.US, new int[]{this.ctx.failed()});
            cmd.setInt(4131, VR.US, new int[]{this.ctx.warning()});
            try {
                this.rqas.writeDimseRSP(this.pc, cmd, null);
            }
            catch (IOException e) {
                LOG.warn("{}: Unable to send C-GET or C-MOVE RSP on association to {}", new Object[]{this.rqas, this.rqas.getRemoteAET(), e});
            }
        }
    }

    private void startWritePendingRSP() {
        if (this.pendingRSP) {
            this.writePendingRSP();
        }
        if (this.pendingRSPInterval != null) {
            this.ctx.setWritePendingRSP(this.rqas.getApplicationEntity().getDevice().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    RetrieveTaskImpl.this.writePendingRSP();
                }
            }, 0L, this.pendingRSPInterval.getSeconds(), TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingCStoreRSP(Association storeas, Collection<InstanceLocations> outstandingRSP) {
        if (storeas.isReadyForDataTransfer() && !outstandingRSP.isEmpty()) {
            try {
                LOG.debug("{}: wait for {} outstanding C-STORE RSP(s) on association to {}", new Object[]{this.rqas != null ? this.rqas : storeas, outstandingRSP.size(), storeas.getRemoteAET()});
                Collection<InstanceLocations> collection = outstandingRSP;
                synchronized (collection) {
                    while (storeas.isReadyForDataTransfer() && !outstandingRSP.isEmpty()) {
                        outstandingRSP.wait();
                    }
                }
                LOG.debug("{}: received outstanding C-STORE RSP(s) on association to {}", (Object)(this.rqas != null ? this.rqas : storeas), (Object)storeas.getRemoteAET());
            }
            catch (InterruptedException e) {
                LOG.warn("{}: failed to wait for outstanding C-STORE RSP(s) on association to {}", new Object[]{this.rqas != null ? this.rqas : storeas, storeas.getRemoteAET(), e});
            }
        }
    }

    private void waitForPendingCMoveForward() {
        this.ctx.getRetrieveService().waitForPendingCMoveForward(this.ctx);
    }

    private void waitForPendingCStoreForward() {
        if (this.ctx.getFallbackAssociation() != null) {
            this.ctx.getRetrieveService().waitForPendingCStoreForward(this.ctx);
        }
    }

    private void updateCompleteness() {
        if (this.ctx.getFallbackAssociation() != null) {
            this.ctx.getRetrieveService().updateCompleteness(this.ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOutstandingRSP(InstanceLocations inst, Association storeas, Collection<InstanceLocations> outstandingRSP) {
        outstandingRSP.remove(inst);
        Collection<InstanceLocations> collection = outstandingRSP;
        synchronized (collection) {
            outstandingRSP.notifyAll();
        }
    }

    protected void releaseStoreAssociation(Association storeas) {
        if (this.dimserq != Dimse.C_GET_RQ && storeas.isReadyForDataTransfer()) {
            try {
                storeas.release();
            }
            catch (IOException e) {
                LOG.warn("{}: failed to release association to {}", new Object[]{this.rqas != null ? this.rqas : storeas, storeas.getRemoteAET(), e});
            }
        }
    }

    private static class WrappedInstanceLocations {
        final InstanceLocations instanceLocations;

        private WrappedInstanceLocations(InstanceLocations instanceLocations) {
            this.instanceLocations = instanceLocations;
        }
    }

    private final class CStoreRSPHandler
    extends DimseRSPHandler {
        private final InstanceLocations inst;
        private final Association storeas;
        private final Collection<InstanceLocations> outstandingRSP;

        public CStoreRSPHandler(InstanceLocations inst, Association storeas, Collection<InstanceLocations> outstandingRSP) {
            super(storeas.nextMessageID());
            this.inst = inst;
            this.storeas = storeas;
            this.outstandingRSP = outstandingRSP;
        }

        public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
            super.onDimseRSP(as, cmd, data);
            int storeStatus = cmd.getInt(2304, -1);
            if (storeStatus == 0) {
                RetrieveTaskImpl.this.ctx.incrementCompleted();
            } else if ((storeStatus & 0xB000) == 45056) {
                RetrieveTaskImpl.this.ctx.incrementWarning();
            } else {
                RetrieveTaskImpl.this.ctx.incrementFailed();
                RetrieveTaskImpl.this.ctx.addFailedMatch(this.inst);
            }
            if (RetrieveTaskImpl.this.pendingRSP) {
                RetrieveTaskImpl.this.writePendingRSP();
            }
            RetrieveTaskImpl.this.removeOutstandingRSP(this.inst, this.storeas, this.outstandingRSP);
        }

        public void onClose(Association as) {
            super.onClose(as);
            RetrieveTaskImpl.this.ctx.incrementFailed();
            RetrieveTaskImpl.this.ctx.addFailedMatch(this.inst);
            RetrieveTaskImpl.this.removeOutstandingRSP(this.inst, this.storeas, this.outstandingRSP);
        }
    }
}

