/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.StgCmtResult;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.util.StgCmtResultQueryParam;
import org.dcm4chee.arc.query.util.TaskQueryParam;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveFailures;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.SeriesInfo;
import org.dcm4chee.arc.retrieve.StudyInfo;
import org.dcm4chee.arc.stgcmt.StgCmtContext;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.dcm4chee.arc.stgcmt.StgVerBatch;
import org.dcm4chee.arc.stgcmt.impl.StgCmtEJB;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.UpdateLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class StgCmtManagerImpl
implements StgCmtManager {
    private final Logger LOG = LoggerFactory.getLogger(StgCmtManagerImpl.class);
    @Inject
    private Device device;
    @Inject
    private StgCmtEJB ejb;
    @Inject
    private RetrieveService retrieveService;
    @Inject
    private StoreService storeService;
    @Inject
    private Event<StgCmtContext> stgCmtEvent;

    @Override
    public void addExternalRetrieveAETs(Attributes eventInfo, Device device) {
        this.ejb.addExternalRetrieveAETs(eventInfo, device);
    }

    @Override
    public void persistStgCmtResult(StgCmtResult result) {
        this.ejb.persistStgCmtResult(result);
    }

    @Override
    public List<StgCmtResult> listStgCmts(StgCmtResultQueryParam queryParam, int offset, int limit) {
        return this.ejb.listStgCmts(queryParam, offset, limit);
    }

    @Override
    public boolean deleteStgCmt(String transactionUID) {
        return this.ejb.deleteStgCmt(transactionUID);
    }

    @Override
    public int deleteStgCmts(StgCmtResult.Status status, Date updatedBefore) {
        return this.ejb.deleteStgCmts(status, updatedBefore);
    }

    @Override
    public void calculateResult(StgCmtContext ctx, Sequence refSopSeq) {
        int numRefSOPs = refSopSeq.size();
        try (RetrieveContext retrCtx = this.retrieveService.newRetrieveContext(ctx.getLocalAET(), refSopSeq);){
            this.retrieveService.calculateMatches(retrCtx);
            for (Attributes refSOP : refSopSeq) {
                this.checkRefSop(ctx, retrCtx, refSOP, numRefSOPs);
            }
            if (!retrCtx.getMatches().isEmpty()) {
                this.checkLocations(ctx, retrCtx, null);
            }
        }
        catch (IOException e) {
            this.LOG.warn("Failed to calculate Storage Commitment Result\n", (Throwable)e);
            Sequence failedSOPSeq = ctx.getEventInfo().ensureSequence(528792, numRefSOPs);
            for (Attributes refSOP : refSopSeq) {
                failedSOPSeq.add(StgCmtManagerImpl.failedSOP(refSOP.getString(528720), refSOP.getString(528725), 272));
            }
            ctx.setException(e);
        }
    }

    @Override
    public boolean calculateResult(StgCmtContext ctx, String studyIUID, String seriesIUID, String sopIUID) throws IOException {
        try (RetrieveContext retrCtx = this.retrieveService.newRetrieveContext(ctx.getLocalAET(), studyIUID, seriesIUID, sopIUID);){
            if (!this.retrieveService.calculateMatches(retrCtx)) {
                boolean bl = false;
                return bl;
            }
            HashMap<String, SeriesResult> seriesResultMap = sopIUID == null ? new HashMap<String, SeriesResult>() : null;
            this.checkLocations(ctx, retrCtx, seriesResultMap);
            if (seriesResultMap != null) {
                seriesResultMap.forEach((iuid, seriesResult) -> this.updateSeries(retrCtx, (String)iuid, (SeriesResult)seriesResult));
            }
        }
        return true;
    }

    private void updateSeries(RetrieveContext retrCtx, String seriesIUID, SeriesResult seriesResult) {
        try {
            SeriesInfo seriesInfo = retrCtx.getSeriesInfos().stream().filter(x -> seriesIUID.equals(x.getSeriesInstanceUID())).findFirst().get();
            if (seriesInfo.getSeriesSize() > 0L && seriesInfo.getSeriesSize() != (long)seriesResult.size) {
                this.LOG.warn("Correct size of Series[uid={}] of Study[uid={}] from {} to {}", new Object[]{seriesIUID, retrCtx.getStudyInstanceUID(), seriesInfo.getSeriesSize(), seriesResult.size});
                StudyInfo studyInfo = (StudyInfo)retrCtx.getStudyInfos().get(0);
                if (studyInfo.getStudySize() > 0L) {
                    long studySize = studyInfo.getStudySize() - seriesInfo.getSeriesSize() + (long)seriesResult.size;
                    this.LOG.warn("Correct size of Study[uid={}] from {} to {}", new Object[]{retrCtx.getStudyInstanceUID(), studyInfo.getStudySize(), studySize});
                    try {
                        this.ejb.updateStudySize(studyInfo.getStudyPk(), studySize);
                    }
                    catch (Exception e) {
                        this.LOG.warn("Failed to update size[={}] of Study[uid={}]\n", new Object[]{studySize, retrCtx.getStudyInstanceUID(), e});
                    }
                    studyInfo.setStudySize(studySize);
                }
            }
            this.ejb.updateSeries(seriesInfo.getSeriesPk(), seriesResult.failures, seriesResult.size);
        }
        catch (Exception e) {
            this.LOG.warn("Failed to update size[={}] and failures[={}] of Storage Verification of Series[uid={}] of Study[uid={}]\n", new Object[]{seriesResult.size, seriesResult.failures, seriesIUID, retrCtx.getStudyInstanceUID(), e});
        }
    }

    @Override
    public List<StgVerBatch> listStgVerBatches(TaskQueryParam taskQueryParam, int offset, int limit) {
        return this.ejb.listStgVerBatches(taskQueryParam, offset, limit);
    }

    @Override
    public Outcome executeStgVerTask(Task storageVerificationTask, HttpServletRequestInfo request) throws IOException {
        String[] storageIDs;
        String localAET = storageVerificationTask.getLocalAET();
        StgCmtContext ctx = new StgCmtContext(this.device.getApplicationEntity(localAET, true), localAET).setRequest(request);
        if (storageVerificationTask.getStorageVerificationPolicy() != null) {
            ctx.setStorageVerificationPolicy(storageVerificationTask.getStorageVerificationPolicy());
        }
        if (storageVerificationTask.getUpdateLocationStatus() != null) {
            ctx.setUpdateLocationStatus(storageVerificationTask.getUpdateLocationStatus());
        }
        if ((storageIDs = storageVerificationTask.getStorageIDs()).length > 0) {
            ctx.setStorageIDs(storageIDs);
        }
        try {
            this.calculateResult(ctx, storageVerificationTask.getStudyInstanceUID(), storageVerificationTask.getSeriesInstanceUID(), storageVerificationTask.getSOPInstanceUID());
        }
        catch (IOException e) {
            ctx.setException(e);
            this.stgCmtEvent.fire((Object)ctx);
            throw e;
        }
        this.stgCmtEvent.fire((Object)ctx);
        Attributes eventInfo = ctx.getEventInfo();
        int completed = StgCmtManagerImpl.sizeOf(eventInfo.getSequence(528793));
        int failed = StgCmtManagerImpl.sizeOf(eventInfo.getSequence(528792));
        storageVerificationTask.setCompleted(completed);
        storageVerificationTask.setFailed(failed);
        this.ejb.updateStgVerTask(storageVerificationTask);
        return new Outcome(failed == 0 ? Task.Status.COMPLETED : Task.Status.WARNING, this.toOutcomeMessage(storageVerificationTask, ctx));
    }

    public void onRetrieveFailures(@Observes @RetrieveFailures RetrieveContext ctx) {
        if (ctx.isStorageVerificationOnRetrieve()) {
            Map<String, Map<String, List<UpdateLocation>>> updateLocationsByStudyAndSeriesIUID = ctx.getUpdateLocations().stream().collect(Collectors.groupingBy(x -> x.instanceLocation.getAttributes().getString(0x20000D), Collectors.groupingBy(x -> x.instanceLocation.getAttributes().getString(0x20000E))));
            updateLocationsByStudyAndSeriesIUID.forEach((studyIUID, seriesMap) -> seriesMap.keySet().forEach(seriesIUID -> this.scheduleStgVerTask(ctx, (String)studyIUID, (String)seriesIUID)));
        }
    }

    @Override
    public boolean scheduleStgVerTask(String localAET, QueryRetrieveLevel2 qrlevel, HttpServletRequestInfo httpServletRequestInfo, String studyInstanceUID, String seriesInstanceUID, String sopInstanceUID, String batchID, Date scheduledTime, StorageVerificationPolicy storageVerificationPolicy, Boolean updateLocationStatus, String ... storageIDs) {
        return this.ejb.scheduleStgVerTask(localAET, qrlevel, httpServletRequestInfo, studyInstanceUID, seriesInstanceUID, sopInstanceUID, batchID, scheduledTime, storageVerificationPolicy, updateLocationStatus, storageIDs);
    }

    private void scheduleStgVerTask(RetrieveContext ctx, String studyIUID, String seriesIUID) {
        try {
            this.ejb.scheduleStgVerTask(ctx.getLocalAETitle(), studyIUID, seriesIUID, null);
        }
        catch (Exception e) {
            this.LOG.warn("Failed to schedule Storage Verification of Series{uid={}} of Study{uid={}}:\n", new Object[]{seriesIUID, studyIUID, e});
        }
    }

    private String toOutcomeMessage(Task storageVerificationTask, StgCmtContext ctx) {
        return ctx.getStorageIDs().length == 0 ? (storageVerificationTask.getSeriesInstanceUID() == null ? String.format("Commit Storage of Study[uid=%s] for %s: - completed: %d, failed: %d", storageVerificationTask.getStudyInstanceUID(), ctx.getStorageVerificationPolicy(), storageVerificationTask.getCompleted(), storageVerificationTask.getFailed()) : (storageVerificationTask.getSOPInstanceUID() == null ? String.format("Commit Storage of Series[uid=%s] of Study[uid=%s] for %s: - completed: %d, failed: %d", storageVerificationTask.getSeriesInstanceUID(), storageVerificationTask.getStudyInstanceUID(), ctx.getStorageVerificationPolicy(), storageVerificationTask.getCompleted(), storageVerificationTask.getFailed()) : String.format("Commit Storage of Instance[uid=%s] of Series[uid=%s] of Study[uid=%s] for %s: - completed: %d, failed: %d", storageVerificationTask.getSOPInstanceUID(), storageVerificationTask.getSeriesInstanceUID(), storageVerificationTask.getStudyInstanceUID(), ctx.getStorageVerificationPolicy(), storageVerificationTask.getCompleted(), storageVerificationTask.getFailed()))) : (storageVerificationTask.getSeriesInstanceUID() == null ? String.format("Commit Storage of Study[uid=%s] on Storage%s for %s: - completed: %d, failed: %d", storageVerificationTask.getStudyInstanceUID(), Arrays.toString(ctx.getStorageIDs()), ctx.getStorageVerificationPolicy(), storageVerificationTask.getCompleted(), storageVerificationTask.getFailed()) : (storageVerificationTask.getSOPInstanceUID() == null ? String.format("Commit Storage of Series[uid=%s] of Study[uid=%s] on Storage%s for %s: - completed: %d, failed: %d", storageVerificationTask.getSeriesInstanceUID(), storageVerificationTask.getStudyInstanceUID(), Arrays.toString(ctx.getStorageIDs()), ctx.getStorageVerificationPolicy(), storageVerificationTask.getCompleted(), storageVerificationTask.getFailed()) : String.format("Commit Storage of Instance[uid=%s] of Series[uid=%s] on Storage%s of Study[uid=%s] for %s: - completed: %d, failed: %d", storageVerificationTask.getSOPInstanceUID(), storageVerificationTask.getSeriesInstanceUID(), storageVerificationTask.getStudyInstanceUID(), Arrays.toString(ctx.getStorageIDs()), ctx.getStorageVerificationPolicy(), storageVerificationTask.getCompleted(), storageVerificationTask.getFailed())));
    }

    private static int sizeOf(Sequence seq) {
        return seq != null ? seq.size() : 0;
    }

    private void checkRefSop(StgCmtContext ctx, RetrieveContext retrCtx, Attributes refSop, int numRefSOPs) {
        String cuid = refSop.getString(528720);
        String iuid = refSop.getString(528725);
        int failureReason = 274;
        Iterator matches = retrCtx.getMatches().iterator();
        while (matches.hasNext()) {
            InstanceLocations match = (InstanceLocations)matches.next();
            if (!match.getSopInstanceUID().equals(iuid)) continue;
            if (match.getSopClassUID().equals(cuid)) {
                return;
            }
            failureReason = 281;
            matches.remove();
            break;
        }
        ctx.getEventInfo().ensureSequence(528792, numRefSOPs).add(StgCmtManagerImpl.failedSOP(cuid, iuid, failureReason));
    }

    private void checkLocations(StgCmtContext ctx, RetrieveContext retrCtx, Map<String, SeriesResult> seriesResultMap) {
        List matches = retrCtx.getMatches();
        Attributes eventInfo = ctx.getEventInfo();
        String commonRetrieveAET = this.commonRetrieveAET(matches);
        if (commonRetrieveAET != null) {
            eventInfo.setString(524372, VR.AE, commonRetrieveAET);
        }
        HashSet<String> studyInstanceUIDs = new HashSet<String>();
        for (InstanceLocations inst : matches) {
            SeriesResult seriesResult;
            String cuid = inst.getSopClassUID();
            String iuid = inst.getSopInstanceUID();
            Attributes attr = inst.getAttributes();
            SeriesResult seriesResult2 = seriesResult = seriesResultMap != null ? seriesResultMap.computeIfAbsent(attr.getString(0x20000E), key -> new SeriesResult()) : null;
            if (seriesResult != null) {
                seriesResult.size = (int)((long)seriesResult.size + inst.getLocations().stream().mapToLong(Location::getSize).max().getAsLong());
            }
            if (ctx.getStorageVerificationPolicy() == StorageVerificationPolicy.DB_RECORD_EXISTS || this.checkLocationsOfInstance(ctx, retrCtx, inst)) {
                eventInfo.ensureSequence(528793, retrCtx.getNumberOfMatches()).add(StgCmtManagerImpl.refSOP(cuid, iuid, commonRetrieveAET == null ? inst.getRetrieveAETs() : null));
            } else {
                eventInfo.ensureSequence(528792, retrCtx.getNumberOfMatches()).add(StgCmtManagerImpl.failedSOP(cuid, iuid, 272));
                if (seriesResult != null) {
                    ++seriesResult.failures;
                }
            }
            if (studyInstanceUIDs.isEmpty()) {
                eventInfo.setString(0x100020, VR.LO, attr.getString(0x100020));
                eventInfo.setString(0x100021, VR.LO, attr.getString(0x100021));
                eventInfo.setString(0x100010, VR.PN, attr.getString(0x100010));
            }
            studyInstanceUIDs.add(attr.getString(0x20000D));
        }
        if (!studyInstanceUIDs.isEmpty()) {
            eventInfo.setString(0x20000D, VR.UI, studyInstanceUIDs.toArray(StringUtils.EMPTY_STRING));
        }
        if (!retrCtx.getUpdateLocations().isEmpty()) {
            this.storeService.updateLocations(ctx.getArchiveAEExtension(), retrCtx.getUpdateLocations());
        }
    }

    private String commonRetrieveAET(List<InstanceLocations> matches) {
        if (matches.isEmpty()) {
            return null;
        }
        Iterator<InstanceLocations> iter = matches.iterator();
        String aets = iter.next().getRetrieveAETs();
        while (iter.hasNext()) {
            if (aets.equals(iter.next().getRetrieveAETs())) continue;
            return null;
        }
        return aets;
    }

    private static Attributes refSOP(String cuid, String iuid, String retrieveAET) {
        Attributes attrs = new Attributes(3);
        if (retrieveAET != null) {
            attrs.setString(524372, VR.AE, retrieveAET);
        }
        attrs.setString(528720, VR.UI, cuid);
        attrs.setString(528725, VR.UI, iuid);
        return attrs;
    }

    private static Attributes failedSOP(String cuid, String iuid, int failureReason) {
        Attributes attrs = new Attributes(3);
        attrs.setString(528720, VR.UI, cuid);
        attrs.setString(528725, VR.UI, iuid);
        attrs.setInt(528791, VR.US, new int[]{failureReason});
        return attrs;
    }

    private boolean checkLocationsOfInstance(StgCmtContext ctx, RetrieveContext retrCtx, InstanceLocations inst) {
        List updateLocations = retrCtx.getUpdateLocations();
        int locationsOnStgCmtStorage = 0;
        Attributes attrs = inst.getAttributes();
        String studyInstanceUID = attrs.getString(0x20000D);
        for (Location l : inst.getLocations()) {
            if (!ctx.checkStorageID(l.getStorageID())) continue;
            ++locationsOnStgCmtStorage;
            Storage storage = this.retrieveService.getStorage(l.getStorageID(), retrCtx);
            CheckResult result = this.checkLocation(ctx, inst, l, storage, updateLocations);
            if (ctx.isUpdateLocationStatus() && l.getStatus() != result.status) {
                updateLocations.add(new UpdateLocation(inst, l, result.status, null));
            }
            if (result.ok()) {
                return true;
            }
            if (result.ioException != null) {
                this.LOG.info("{} of {} of Instance[uid={}] of Study[uid={}]:\n", new Object[]{result.status, l, inst.getSopInstanceUID(), studyInstanceUID, result.ioException});
                continue;
            }
            this.LOG.info("{} of {} of Instance[uid={}] of Study[uid={}]", new Object[]{result.status, l, inst.getSopInstanceUID(), studyInstanceUID});
        }
        if (locationsOnStgCmtStorage == 0) {
            this.LOG.info("Instance[uid={}] of Study[uid={}] not stored on Storage{}", new Object[]{inst.getSopInstanceUID(), studyInstanceUID, Arrays.toString(ctx.getStorageIDs())});
        }
        return false;
    }

    private CheckResult checkLocation(StgCmtContext ctx, InstanceLocations inst, Location l, Storage storage, List<UpdateLocation> updateLocations) {
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(l.getStoragePath());
        readContext.setStudyInstanceUID(inst.getAttributes().getString(0x20000D));
        switch (ctx.getStorageVerificationPolicy()) {
            case OBJECT_EXISTS: {
                return this.objectExists(readContext);
            }
            case OBJECT_SIZE: {
                return this.compareObjectSize(readContext, l);
            }
            case OBJECT_FETCH: {
                return this.fetchObject(readContext);
            }
            case OBJECT_CHECKSUM: {
                return this.recalcChecksum(readContext, inst, l, updateLocations);
            }
            case S3_MD5SUM: {
                return this.compareS3md5Sum(readContext, inst, l, updateLocations);
            }
        }
        throw new AssertionError((Object)("StgCmtPolicy: " + ctx.getStorageVerificationPolicy()));
    }

    private CheckResult objectExists(ReadContext readContext) {
        return readContext.getStorage().exists(readContext) ? new CheckResult(Location.Status.OK) : new CheckResult(Location.Status.MISSING_OBJECT);
    }

    private CheckResult compareObjectSize(ReadContext readContext, Location l) {
        try {
            return readContext.getStorage().getContentLength(readContext) == l.getSize() ? new CheckResult(Location.Status.OK) : new CheckResult(Location.Status.DIFFERING_OBJECT_SIZE);
        }
        catch (NoSuchFileException e) {
            return new CheckResult(Location.Status.MISSING_OBJECT, e);
        }
        catch (IOException e) {
            return new CheckResult(Location.Status.FAILED_TO_FETCH_METADATA, e);
        }
    }

    private CheckResult fetchObject(ReadContext readContext) {
        CheckResult checkResult;
        block9: {
            InputStream stream = readContext.getStorage().openInputStream(readContext);
            try {
                StreamUtils.copy((InputStream)stream, null);
                checkResult = new CheckResult(Location.Status.OK);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return new CheckResult(Location.Status.MISSING_OBJECT, e);
                }
                catch (IOException e) {
                    return new CheckResult(Location.Status.FAILED_TO_FETCH_OBJECT, e);
                }
            }
            stream.close();
        }
        return checkResult;
    }

    private CheckResult recalcChecksum(ReadContext readContext, InstanceLocations inst, Location l, List<UpdateLocation> updateLocations) {
        StorageDescriptor storageDescriptor = readContext.getStorage().getStorageDescriptor();
        MessageDigest messageDigest = storageDescriptor.getMessageDigest();
        readContext.setMessageDigest(messageDigest);
        CheckResult checkResult = this.fetchObject(readContext);
        if (!checkResult.ok() || messageDigest == null) {
            return checkResult;
        }
        String calculatedDigest = TagUtils.toHexString((byte[])readContext.getDigest());
        String digest = l.getDigestAsHexString();
        if (digest == null) {
            updateLocations.add(new UpdateLocation(inst, l, null, calculatedDigest));
            return checkResult;
        }
        return calculatedDigest.equals(digest) ? new CheckResult(Location.Status.OK) : new CheckResult(Location.Status.DIFFERING_OBJECT_CHECKSUM);
    }

    private CheckResult compareS3md5Sum(ReadContext readContext, InstanceLocations inst, Location l, List<UpdateLocation> updateLocations) {
        byte[] contentMD5;
        StorageDescriptor storageDescriptor = readContext.getStorage().getStorageDescriptor();
        if (!"MD5".equals(storageDescriptor.getDigestAlgorithm())) {
            this.LOG.info("Digest Algorithm of {} != MD5 -> compare object size instead compare S3 MD5", (Object)storageDescriptor);
            return this.compareObjectSize(readContext, l);
        }
        try {
            contentMD5 = readContext.getStorage().getContentMD5(readContext);
        }
        catch (NoSuchFileException e) {
            return new CheckResult(Location.Status.MISSING_OBJECT, e);
        }
        catch (IOException e) {
            return new CheckResult(Location.Status.FAILED_TO_FETCH_METADATA, e);
        }
        if (contentMD5 == null) {
            this.LOG.info("S3 MD5SUM not supported by {} -> recalculate object checksum instead compare S3 MD5", (Object)storageDescriptor);
            return this.recalcChecksum(readContext, inst, l, updateLocations);
        }
        String digest = l.getDigestAsHexString();
        if (digest == null || contentMD5 == null) {
            CheckResult checkResult = this.recalcChecksum(readContext, inst, l, updateLocations);
            if (!checkResult.ok()) {
                return checkResult;
            }
            digest = TagUtils.toHexString((byte[])readContext.getDigest());
        }
        return TagUtils.toHexString((byte[])contentMD5).equals(digest) ? new CheckResult(Location.Status.OK) : new CheckResult(Location.Status.DIFFERING_S3_MD5SUM);
    }

    private static class SeriesResult {
        public int failures;
        public int size;

        private SeriesResult() {
        }
    }

    private static class CheckResult {
        final Location.Status status;
        final IOException ioException;

        CheckResult(Location.Status status, IOException ioException) {
            this.status = status;
            this.ioException = ioException;
        }

        CheckResult(Location.Status status) {
            this(status, null);
        }

        boolean ok() {
            return this.status == Location.Status.OK;
        }
    }
}

