/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Cache<K, V> {
    private int maxSize;
    private long staleTimeout;
    private final LinkedHashMap<K, Entry<V>> cache = new LinkedHashMap<K, Entry<V>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Entry<V>> eldest) {
            return Cache.this.maxSize > 0 && this.size() > Cache.this.maxSize;
        }
    };

    public Cache() {
    }

    public Cache(int maxSize, long staleTimeout) {
        this.maxSize = maxSize;
        this.staleTimeout = staleTimeout;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        int remove;
        if (maxSize > 0 && (remove = this.cache.size() - maxSize) > 0) {
            Iterator<Map.Entry<K, Entry<V>>> iter = this.cache.entrySet().iterator();
            do {
                iter.next();
                iter.remove();
            } while (--remove > 0);
        }
        this.maxSize = maxSize;
    }

    public long getStaleTimeout() {
        return this.staleTimeout;
    }

    public void setStaleTimeout(long staleTimeout) {
        this.staleTimeout = staleTimeout;
    }

    public Entry<V> getEntry(K key) {
        if (this.staleTimeout <= 0L) {
            return this.cache.get(key);
        }
        long minFetchTime = System.currentTimeMillis() - this.staleTimeout;
        Iterator<Entry<V>> iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            if (iter.next().fetchTime > minFetchTime) {
                return this.cache.get(key);
            }
            iter.remove();
        }
        return null;
    }

    public V get(K key) {
        Entry<V> entry = this.getEntry(key);
        return entry != null ? (V)entry.value : null;
    }

    public V put(K key, V value) {
        Entry<V> entry = this.cache.put(key, new Entry<V>(value, System.currentTimeMillis()));
        return entry != null ? (V)entry.value : null;
    }

    public V remove(K key) {
        Entry entry = (Entry)this.cache.remove(key);
        return entry != null ? (V)entry.value : null;
    }

    public void clear() {
        this.cache.clear();
    }

    public static final class Entry<V> {
        final V value;
        final long fetchTime;

        Entry(V value, long fetchTime) {
            this.value = value;
            this.fetchTime = fetchTime;
        }

        public V value() {
            return this.value;
        }
    }
}

