/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion;
import org.dcm4chee.arc.conf.ArchiveAttributeCoercion2;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.store.InstanceLocations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomObjectOutput
implements StreamingOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DicomObjectOutput.class);
    private final RetrieveContext ctx;
    private final InstanceLocations inst;
    private final Collection<String> tsuids;
    private Attributes fileMetaInformation;

    public DicomObjectOutput(RetrieveContext ctx, InstanceLocations inst, Collection<String> tsuids) {
        this.ctx = ctx;
        this.inst = inst;
        this.tsuids = tsuids.contains("*") ? Collections.EMPTY_LIST : tsuids;
    }

    public Attributes getFileMetaInformation() {
        return this.fileMetaInformation;
    }

    public void write(OutputStream out) throws IOException {
        LOG.debug("Start writing {}", (Object)this.inst);
        RetrieveService service = this.ctx.getRetrieveService();
        try (Transcoder transcoder = service.openTranscoder(this.ctx, this.inst, this.tsuids, true);){
            AttributesCoercion coerce;
            List<ArchiveAttributeCoercion2> coercions = service.getArchiveAttributeCoercions(this.ctx, this.inst);
            if (coercions.isEmpty()) {
                ArchiveAttributeCoercion rule = service.getArchiveAttributeCoercion(this.ctx, this.inst);
                if (rule != null) {
                    transcoder.setNullifyPixelData(rule.isNullifyPixelData());
                }
                coerce = service.getAttributesCoercion(this.ctx, this.inst, rule);
            } else {
                transcoder.setNullifyPixelData(ArchiveAttributeCoercion2.containsScheme(coercions, (String)"nullify-pixel-data"));
                coerce = service.getAttributesCoercion(this.ctx, this.inst, coercions);
            }
            transcoder.transcode((transcoder1, dataset) -> {
                try {
                    coerce.coerce(dataset, null);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                return out;
            });
            this.fileMetaInformation = transcoder.getFileMetaInformation();
        }
        LOG.debug("Finished writing {}", (Object)this.inst);
    }
}

