/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.retrieve.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeSet;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveService;
import org.dcm4chee.arc.retrieve.SeriesInfo;
import org.dcm4chee.arc.retrieve.StudyInfo;
import org.dcm4chee.arc.retrieve.impl.CopyToRetrieveCacheTask;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.UpdateLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetrieveContextImpl
implements RetrieveContext {
    private static final Logger LOG = LoggerFactory.getLogger(RetrieveContextImpl.class);
    private Association requestAssociation;
    private Association storeAssociation;
    private Association forwardAssociation;
    private Association fallbackAssociation;
    private final RetrieveService retrieveService;
    private final ArchiveAEExtension arcAE;
    private final String localAETitle;
    private String callingAET;
    private final QueryRetrieveView qrView;
    private QueryRetrieveLevel2 qrLevel;
    private int priority = 0;
    private int moveOriginatorMessageID;
    private String moveOriginatorAETitle;
    private String destinationAETitle;
    private ApplicationEntity destinationAE;
    private WebApplication destinationWebApp;
    private StorageDescriptor destinationStorage;
    private Throwable exception;
    private IDWithIssuer[] patientIDs = new IDWithIssuer[0];
    private String[] studyInstanceUIDs = new String[0];
    private String[] seriesInstanceUIDs = new String[0];
    private Series.MetadataUpdate metadataUpdate;
    private String[] sopInstanceUIDs = new String[0];
    private Location.ObjectType objectType = Location.ObjectType.DICOM_FILE;
    private int numberOfMatches;
    private final List<InstanceLocations> matches = new ArrayList<InstanceLocations>();
    private final List<StudyInfo> studyInfos = new ArrayList<StudyInfo>();
    private final List<SeriesInfo> seriesInfos = new ArrayList<SeriesInfo>();
    private final AtomicInteger completed = new AtomicInteger();
    private final AtomicInteger warning = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger pendingCStoreForward = new AtomicInteger();
    private final AtomicInteger missing = new AtomicInteger();
    private final Collection<InstanceLocations> cstoreForwards = Collections.synchronizedCollection(new ArrayList());
    private final Collection<String> failedSOPInstanceUIDs = Collections.synchronizedCollection(new ArrayList());
    private final Collection<InstanceLocations> failedMatches = Collections.synchronizedCollection(new ArrayList());
    private final HashMap<String, Storage> storageMap = new HashMap();
    private ScheduledFuture<?> writePendingRSP;
    private volatile Attributes fallbackMoveRSPCommand;
    private volatile Attributes fallbackMoveRSPData;
    private volatile int fallbackMoveRSPNumberOfMatches = -1;
    private Date patientUpdatedTime;
    private boolean retryFailedRetrieve;
    private AttributeSet metadataFilter;
    private boolean withoutPrivateAttributes;
    private HttpServletRequestInfo httpServletRequestInfo;
    private CopyToRetrieveCacheTask copyToRetrieveCacheTask;
    private final List<UpdateLocation> updateLocations = new ArrayList<UpdateLocation>();
    private volatile Availability updateInstanceAvailability;
    private final AtomicInteger failuresOnCopyToRetrieveCache = new AtomicInteger();

    RetrieveContextImpl(RetrieveService retrieveService, ArchiveAEExtension arcAE, String localAETitle, QueryRetrieveView qrView) {
        this.retrieveService = retrieveService;
        this.arcAE = arcAE;
        this.localAETitle = localAETitle;
        this.callingAET = localAETitle;
        this.qrView = qrView;
    }

    @Override
    public Association getRequestAssociation() {
        return this.requestAssociation;
    }

    @Override
    public void setRequestAssociation(Association requestAssociation) {
        this.requestAssociation = requestAssociation;
    }

    @Override
    public QueryRetrieveLevel2 getQueryRetrieveLevel() {
        return this.qrLevel;
    }

    @Override
    public void setQueryRetrieveLevel(QueryRetrieveLevel2 qrLevel) {
        this.qrLevel = qrLevel;
    }

    @Override
    public Association getStoreAssociation() {
        return this.storeAssociation;
    }

    @Override
    public void setStoreAssociation(Association storeAssociation) {
        this.storeAssociation = storeAssociation;
    }

    @Override
    public Association getForwardAssociation() {
        return this.forwardAssociation;
    }

    @Override
    public void setForwardAssociation(Association forwardAssociation) {
        this.forwardAssociation = forwardAssociation;
    }

    @Override
    public Association getFallbackAssociation() {
        return this.fallbackAssociation;
    }

    @Override
    public void setFallbackAssociation(Association fallbackAssociation) {
        this.fallbackAssociation = fallbackAssociation;
    }

    @Override
    public RetrieveService getRetrieveService() {
        return this.retrieveService;
    }

    @Override
    public ApplicationEntity getLocalApplicationEntity() {
        return this.arcAE.getApplicationEntity();
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return this.arcAE;
    }

    @Override
    public String[] getAccessControlIDs() {
        return this.arcAE.getAccessControlIDs();
    }

    @Override
    public QueryRetrieveView getQueryRetrieveView() {
        return this.qrView;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getMoveOriginatorMessageID() {
        return this.moveOriginatorMessageID;
    }

    @Override
    public void setMoveOriginatorMessageID(int moveOriginatorMessageID) {
        this.moveOriginatorMessageID = moveOriginatorMessageID;
    }

    @Override
    public String getMoveOriginatorAETitle() {
        return this.moveOriginatorAETitle;
    }

    @Override
    public void setMoveOriginatorAETitle(String moveOriginatorAETitle) {
        this.moveOriginatorAETitle = moveOriginatorAETitle;
    }

    @Override
    public String getDestinationAETitle() {
        return this.destinationAETitle;
    }

    @Override
    public void setDestinationAETitle(String destinationAETitle) {
        this.destinationAETitle = destinationAETitle;
    }

    @Override
    public ApplicationEntity getDestinationAE() {
        return this.destinationAE;
    }

    @Override
    public void setDestinationAE(ApplicationEntity destinationAE) {
        this.destinationAE = destinationAE;
    }

    @Override
    public WebApplication getDestinationWebApp() {
        return this.destinationWebApp;
    }

    @Override
    public void setDestinationWebApp(WebApplication destinationWebApp) {
        this.destinationWebApp = destinationWebApp;
    }

    @Override
    public StorageDescriptor getDestinationStorage() {
        return this.destinationStorage;
    }

    @Override
    public void setDestinationStorage(StorageDescriptor destinationStorage) {
        this.destinationStorage = destinationStorage;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Override
    public String getLocalAETitle() {
        return this.localAETitle;
    }

    @Override
    public String getCallingAET() {
        return this.callingAET;
    }

    @Override
    public void setCallingAET(String callingAET) {
        this.callingAET = Objects.requireNonNull(callingAET);
    }

    @Override
    public String getRequestorAET() {
        return this.requestAssociation != null ? this.requestAssociation.getRemoteAET() : null;
    }

    @Override
    public String getRequestorHostName() {
        return this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requesterHost : (this.requestAssociation != null ? ReverseDNS.hostNameOf((InetAddress)this.requestAssociation.getSocket().getInetAddress()) : null);
    }

    @Override
    public String getDestinationHostName() {
        return this.destinationAE != null && !this.destinationAE.getConnections().isEmpty() ? ((Connection)this.destinationAE.getConnections().get(0)).getHostname() : (this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requesterHost : (this.storeAssociation != null ? ReverseDNS.hostNameOf((InetAddress)this.storeAssociation.getSocket().getInetAddress()) : null));
    }

    @Override
    public String getLocalHostName() {
        return this.httpServletRequestInfo != null ? this.httpServletRequestInfo.localHost : (this.storeAssociation != null ? ReverseDNS.hostNameOf((InetAddress)this.storeAssociation.getSocket().getLocalAddress()) : null);
    }

    @Override
    public IDWithIssuer[] getPatientIDs() {
        return this.patientIDs;
    }

    @Override
    public void setPatientIDs(IDWithIssuer ... patientIDs) {
        this.patientIDs = patientIDs != null ? patientIDs : IDWithIssuer.EMPTY;
    }

    @Override
    public String getStudyInstanceUID() {
        return this.studyInstanceUIDs.length > 0 ? this.studyInstanceUIDs[0] : null;
    }

    @Override
    public String[] getStudyInstanceUIDs() {
        return this.studyInstanceUIDs;
    }

    @Override
    public void setStudyInstanceUIDs(String ... studyInstanceUIDs) {
        this.studyInstanceUIDs = studyInstanceUIDs != null ? studyInstanceUIDs : StringUtils.EMPTY_STRING;
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.seriesInstanceUIDs.length > 0 ? this.seriesInstanceUIDs[0] : null;
    }

    @Override
    public String[] getSeriesInstanceUIDs() {
        return this.seriesInstanceUIDs;
    }

    @Override
    public void setSeriesInstanceUIDs(String ... seriesInstanceUIDs) {
        this.seriesInstanceUIDs = seriesInstanceUIDs != null ? seriesInstanceUIDs : StringUtils.EMPTY_STRING;
    }

    @Override
    public Series.MetadataUpdate getSeriesMetadataUpdate() {
        return this.metadataUpdate;
    }

    @Override
    public void setSeriesMetadataUpdate(Series.MetadataUpdate metadataUpdate) {
        this.metadataUpdate = metadataUpdate;
    }

    @Override
    public String getSopInstanceUID() {
        return this.sopInstanceUIDs.length > 0 ? this.sopInstanceUIDs[0] : null;
    }

    @Override
    public String[] getSopInstanceUIDs() {
        return this.sopInstanceUIDs;
    }

    @Override
    public void setSopInstanceUIDs(String ... sopInstanceUIDs) {
        this.sopInstanceUIDs = sopInstanceUIDs != null ? sopInstanceUIDs : StringUtils.EMPTY_STRING;
    }

    @Override
    public Location.ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(Location.ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public List<InstanceLocations> getMatches() {
        return this.matches;
    }

    @Override
    public List<StudyInfo> getStudyInfos() {
        return this.studyInfos;
    }

    @Override
    public List<SeriesInfo> getSeriesInfos() {
        return this.seriesInfos;
    }

    @Override
    public int getNumberOfMatches() {
        return this.numberOfMatches;
    }

    @Override
    public void setNumberOfMatches(int numberOfMatches) {
        this.numberOfMatches = numberOfMatches;
    }

    @Override
    public int completed() {
        return this.completed.get();
    }

    @Override
    public void incrementCompleted() {
        this.completed.getAndIncrement();
    }

    @Override
    public void addCompleted(int delta) {
        this.completed.getAndAdd(delta);
    }

    @Override
    public int warning() {
        return this.warning.get();
    }

    @Override
    public void incrementWarning() {
        this.warning.getAndIncrement();
    }

    @Override
    public void addWarning(int delta) {
        this.warning.getAndAdd(delta);
    }

    @Override
    public int failed() {
        return this.failed.get() + (this.fallbackMoveRSPCommand != null ? this.fallbackMoveRSPCommand.getInt(4130, 0) : 0);
    }

    @Override
    public void incrementFailed() {
        this.failed.getAndIncrement();
    }

    @Override
    public void addFailed(int delta) {
        this.failed.getAndAdd(delta);
    }

    @Override
    public void addFailedSOPInstanceUID(String iuid) {
        this.failedSOPInstanceUIDs.add(iuid);
    }

    @Override
    public boolean isFailedSOPInstanceUID(String iuid) {
        return this.failedSOPInstanceUIDs.contains(iuid);
    }

    @Override
    public String[] failedSOPInstanceUIDs() {
        String[] src;
        if (this.fallbackMoveRSPData == null || (src = this.fallbackMoveRSPData.getStrings(524376)) == null || src.length == 0) {
            return this.failedSOPInstanceUIDs.toArray(StringUtils.EMPTY_STRING);
        }
        int destPos = this.failedSOPInstanceUIDs.size();
        String[] dest = this.failedSOPInstanceUIDs.toArray(new String[destPos + src.length]);
        System.arraycopy(src, 0, dest, destPos, src.length);
        return dest;
    }

    @Override
    public void addFailedMatch(InstanceLocations match) {
        this.failedSOPInstanceUIDs.add(match.getSopInstanceUID());
        this.failedMatches.add(match);
    }

    @Override
    public Collection<InstanceLocations> getFailedMatches() {
        return this.failedMatches;
    }

    @Override
    public int remaining() {
        return Math.max(0, Math.max(this.numberOfMatches, this.fallbackMoveRSPNumberOfMatches) - this.completed() - this.warning() - this.failed());
    }

    @Override
    public int status() {
        int status;
        if (this.fallbackMoveRSPCommand != null && (status = this.fallbackMoveRSPCommand.getInt(2304, 0)) != 0) {
            return this.completed() == 0 && this.warning() == 0 ? 42754 : 45056;
        }
        return this.failed() == 0 ? 0 : (this.completed() == 0 && this.warning() == 0 ? 42754 : 45056);
    }

    @Override
    public String getOutcomeDescription() {
        return this.failed() == 0 && this.warning() == 0 ? "Success" : (this.completed() == 0 && this.warning() == 0 ? "Unable to perform sup-operations" : (this.failed() == 0 ? "Warnings on retrieve of " + this.warning() + " objects" : "Retrieve of " + this.failed() + " objects failed"));
    }

    @Override
    public Storage getStorage(String storageID) {
        return this.storageMap.get(storageID);
    }

    @Override
    public void putStorage(String storageID, Storage storage) {
        this.storageMap.put(storageID, storage);
    }

    @Override
    public void incrementPendingCStoreForward() {
        this.pendingCStoreForward.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrementPendingCStoreForward() {
        AtomicInteger atomicInteger = this.pendingCStoreForward;
        synchronized (atomicInteger) {
            this.pendingCStoreForward.getAndDecrement();
            this.pendingCStoreForward.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForPendingCStoreForward() throws InterruptedException {
        AtomicInteger atomicInteger = this.pendingCStoreForward;
        synchronized (atomicInteger) {
            while (this.pendingCStoreForward.get() > 0) {
                this.pendingCStoreForward.wait();
            }
        }
    }

    @Override
    public void incrementMissing() {
        this.missing.getAndIncrement();
    }

    @Override
    public int missing() {
        return this.missing.get();
    }

    @Override
    public void addCStoreForward(InstanceLocations inst) {
        this.cstoreForwards.add(inst);
    }

    @Override
    public Collection<InstanceLocations> getCStoreForwards() {
        return this.cstoreForwards;
    }

    @Override
    public void setWritePendingRSP(ScheduledFuture<?> writePendingRSP) {
        this.writePendingRSP = writePendingRSP;
    }

    @Override
    public void stopWritePendingRSP() {
        if (this.writePendingRSP != null) {
            this.writePendingRSP.cancel(true);
        }
    }

    @Override
    public void setFallbackMoveRSP(Attributes cmd, Attributes data) {
        if (this.fallbackMoveRSPCommand == null) {
            this.fallbackMoveRSPNumberOfMatches = this.fallbackMoveRSPNumberOfMatchesOf(cmd);
        }
        this.fallbackMoveRSPCommand = cmd;
        this.fallbackMoveRSPData = data;
    }

    private int fallbackMoveRSPNumberOfMatchesOf(Attributes cmd) {
        int[] a = IntStream.of(4128, 4129, 4131, 4130).map(tag -> cmd.getInt(tag, -1)).filter(n -> n >= 0).toArray();
        return a.length == 0 ? -1 : Arrays.stream(a).sum();
    }

    @Override
    public Attributes getFallbackMoveRSPCommand() {
        return this.fallbackMoveRSPCommand;
    }

    @Override
    public Attributes getFallbackMoveRSPData() {
        return this.fallbackMoveRSPData;
    }

    @Override
    public int getFallbackMoveRSPNumberOfMatches() {
        return this.fallbackMoveRSPNumberOfMatches;
    }

    @Override
    public int getFallbackMoveRSPFailed() {
        return this.fallbackMoveRSPCommand != null ? this.fallbackMoveRSPCommand.getInt(4130, -1) : -1;
    }

    @Override
    public String[] getFallbackMoveRSPFailedIUIDs() {
        return this.fallbackMoveRSPData != null ? StringUtils.maskNull((String[])this.fallbackMoveRSPData.getStrings(524376)) : StringUtils.EMPTY_STRING;
    }

    @Override
    public int getFallbackMoveRSPStatus() {
        return this.fallbackMoveRSPCommand != null ? this.fallbackMoveRSPCommand.getInt(2304, -1) : -1;
    }

    @Override
    public void close() {
        for (Storage storage : this.storageMap.values()) {
            SafeClose.close((Closeable)storage);
        }
    }

    @Override
    public boolean isRetryFailedRetrieve() {
        return this.retryFailedRetrieve;
    }

    @Override
    public void setRetryFailedRetrieve(boolean retryFailedRetrieve) {
        this.retryFailedRetrieve = retryFailedRetrieve;
    }

    @Override
    public Date getPatientUpdatedTime() {
        return this.patientUpdatedTime;
    }

    @Override
    public void setPatientUpdatedTime(Date patientUpdatedTime) {
        this.patientUpdatedTime = patientUpdatedTime;
    }

    @Override
    public AttributeSet getMetadataFilter() {
        return this.metadataFilter;
    }

    @Override
    public void setMetadataFilter(AttributeSet metadataFilter) {
        this.metadataFilter = metadataFilter;
    }

    @Override
    public boolean isWithoutPrivateAttributes() {
        return this.withoutPrivateAttributes;
    }

    @Override
    public void setWithoutPrivateAttributes(boolean withoutPrivateAttributes) {
        this.withoutPrivateAttributes = withoutPrivateAttributes;
    }

    @Override
    public boolean isUpdateSeriesMetadata() {
        return this.metadataUpdate != null;
    }

    @Override
    public boolean isConsiderPurgedInstances() {
        return this.arcAE != null && this.arcAE.getArchiveDeviceExtension().isPurgeInstanceRecords() && (this.qrLevel != QueryRetrieveLevel2.IMAGE || this.seriesInstanceUIDs.length != 0);
    }

    @Override
    public boolean isRetrieveMetadata() {
        return this.objectType == null;
    }

    @Override
    public HttpServletRequestInfo getHttpServletRequestInfo() {
        return this.httpServletRequestInfo;
    }

    @Override
    public void setHttpServletRequestInfo(HttpServletRequestInfo httpServletRequestInfo) {
        this.httpServletRequestInfo = httpServletRequestInfo;
    }

    @Override
    public boolean copyToRetrieveCache(InstanceLocations match) {
        if (match == null) {
            if (this.copyToRetrieveCacheTask != null) {
                if (this.copyToRetrieveCacheTask.isTarArchiver()) {
                    this.retrieveService.getDevice().execute((Runnable)this.copyToRetrieveCacheTask);
                } else {
                    this.copyToRetrieveCacheTask.schedule(null);
                }
            }
            return false;
        }
        StorageDescriptor storageDescriptor = null;
        ArchiveDeviceExtension arcdev = this.retrieveService.getArchiveDeviceExtension();
        for (Location location : match.getLocations()) {
            storageDescriptor = arcdev.getStorageDescriptorNotNull(location.getStorageID());
            if (storageDescriptor.getRetrieveCacheStorageID() != null) continue;
            return false;
        }
        if (match != null && match.getInstancePk() == null) {
            try {
                this.restoreInstances(match.getAttributes(), storageDescriptor.getRetrieveCacheStorageID());
            }
            catch (IOException e) {
                LOG.error("Failed to restore purged Instance Records:\n", (Throwable)e);
                return false;
            }
        }
        return this.copyToRetrieveCacheTask(storageDescriptor).schedule(match);
    }

    private void restoreInstances(Attributes attrs, String storageID) throws IOException {
        StoreService storeService = this.retrieveService.getStoreService();
        storeService.restoreInstances(storeService.newStoreSession(this.getLocalApplicationEntity()).withObjectStorageID(storageID), attrs.getString(0x20000D), attrs.getString(0x20000E), this.arcAE.purgeInstanceRecordsDelay()).stream().forEach(inst -> this.matches.stream().filter(match1 -> match1.getSopInstanceUID().equals(inst.getSopInstanceUID())).findFirst().ifPresent(match1 -> match1.setInstancePk(Long.valueOf(inst.getPk()))));
    }

    private CopyToRetrieveCacheTask copyToRetrieveCacheTask(StorageDescriptor storageDescriptor) {
        CopyToRetrieveCacheTask task = this.copyToRetrieveCacheTask;
        if (task == null) {
            this.copyToRetrieveCacheTask = task = new CopyToRetrieveCacheTask(this, storageDescriptor);
            if (!storageDescriptor.isTarArchiver()) {
                this.retrieveService.getDevice().execute((Runnable)task);
            }
        }
        return task;
    }

    @Override
    public InstanceLocations copiedToRetrieveCache() {
        return this.copyToRetrieveCacheTask != null ? this.copyToRetrieveCacheTask.copiedToRetrieveCache() : null;
    }

    @Override
    public List<UpdateLocation> getUpdateLocations() {
        return this.updateLocations;
    }

    @Override
    public boolean isUpdateLocationStatusOnRetrieve() {
        return this.arcAE.updateLocationStatusOnRetrieve();
    }

    @Override
    public boolean isStorageVerificationOnRetrieve() {
        return this.arcAE.storageVerificationOnRetrieve();
    }

    @Override
    public void decrementNumberOfMatches() {
        --this.numberOfMatches;
    }

    @Override
    public Availability getUpdateInstanceAvailability() {
        return this.updateInstanceAvailability;
    }

    @Override
    public void setUpdateInstanceAvailability(Availability updateInstanceAvailability) {
        this.updateInstanceAvailability = updateInstanceAvailability;
    }

    @Override
    public int failuresOnCopyToRetrieveCache() {
        return this.failuresOnCopyToRetrieveCache.get();
    }

    @Override
    public void incrementFailuresOnCopyToRetrieveCache() {
        this.failuresOnCopyToRetrieveCache.getAndIncrement();
    }

    void addFailuresOnCopyToRetrieveCache(int delta) {
        this.failuresOnCopyToRetrieveCache.getAndAdd(delta);
    }
}

