/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.entity.Instance;
import org.dcm4chee.arc.entity.Instance_;
import org.dcm4chee.arc.entity.Metadata_;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.SeriesQueryAttributes_;
import org.dcm4chee.arc.entity.Series_;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.entity.StudyQueryAttributes;
import org.dcm4chee.arc.entity.Study_;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QueryBuilder;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
public class QueryAttributesEJB {
    @Inject
    private CodeCache codeCache;
    @Inject
    private Device device;
    @Inject
    private QueryService service;
    @PersistenceContext(unitName="dcm4chee-arc")
    EntityManager em;

    public StudyQueryAttributes findOrCalculateStudyQueryAttributes(Long studyPk, QueryRetrieveView qrView) {
        try {
            return (StudyQueryAttributes)this.em.createNamedQuery("StudyQueryAttributes.findByViewIDAndStudyPk", StudyQueryAttributes.class).setParameter(1, (Object)qrView.getViewID()).setParameter(2, (Object)studyPk).getSingleResult();
        }
        catch (NoResultException noResultException) {
            CriteriaBuilder cb = this.em.getCriteriaBuilder();
            CriteriaQuery q = cb.createTupleQuery();
            Root series = q.from(Series.class);
            Join metadata = series.join(Series_.metadata, JoinType.LEFT);
            String viewID = qrView.getViewID();
            CollectionJoin seriesQueryAttributes = QueryBuilder.joinSeriesQueryAttributes((CriteriaBuilder)cb, (From)series, (String)viewID);
            TypedQuery query = this.em.createQuery(q.multiselect(new Selection[]{series.get(Series_.pk), series.get(Series_.modality), series.get(Series_.instancePurgeState), metadata.get(Metadata_.storageID), metadata.get(Metadata_.storagePath), seriesQueryAttributes.get(SeriesQueryAttributes_.numberOfInstances), seriesQueryAttributes.get(SeriesQueryAttributes_.sopClassesInSeries), seriesQueryAttributes.get(SeriesQueryAttributes_.retrieveAETs), seriesQueryAttributes.get(SeriesQueryAttributes_.availability)}).where((Expression)cb.equal((Expression)series.get(Series_.study).get(Study_.pk), (Object)studyPk)));
            StudyQueryAttributesBuilder builder = new StudyQueryAttributesBuilder((Path<Series>)series, (Path<SeriesQueryAttributes>)seriesQueryAttributes);
            try (Stream resultStream = query.getResultStream();){
                resultStream.forEach(tuple -> {
                    Integer numberOfInstancesI = (Integer)tuple.get((TupleElement)seriesQueryAttributes.get(SeriesQueryAttributes_.numberOfInstances));
                    if (numberOfInstancesI == null) {
                        builder.add((Tuple)tuple, this.service.calculateSeriesQueryAttributes((Long)tuple.get((TupleElement)series.get(Series_.pk)), (Series.InstancePurgeState)tuple.get((TupleElement)series.get(Series_.instancePurgeState)), (String)tuple.get((TupleElement)metadata.get(Metadata_.storageID)), (String)tuple.get((TupleElement)metadata.get(Metadata_.storagePath)), qrView));
                    } else {
                        builder.add((Tuple)tuple);
                    }
                });
            }
            StudyQueryAttributes queryAttrs = builder.build();
            queryAttrs.setViewID(qrView.getViewID());
            queryAttrs.setStudy((Study)this.em.getReference(Study.class, (Object)studyPk));
            this.em.persist((Object)queryAttrs);
            return queryAttrs;
        }
    }

    public SeriesQueryAttributes findOrCalculateSeriesQueryAttributes(Long seriesPk, QueryRetrieveView qrView) {
        try {
            return (SeriesQueryAttributes)this.em.createNamedQuery("SeriesQueryAttributes.findByViewIDAndSeriesPk", SeriesQueryAttributes.class).setParameter(1, (Object)qrView.getViewID()).setParameter(2, (Object)seriesPk).getSingleResult();
        }
        catch (NoResultException noResultException) {
            CriteriaBuilder cb = this.em.getCriteriaBuilder();
            CriteriaQuery q = cb.createTupleQuery();
            Root instance = q.from(Instance.class);
            Join series = instance.join(Instance_.series);
            Join study = series.join(Series_.study);
            QueryBuilder queryBuilder = new QueryBuilder(cb);
            ArrayList<Predicate> x = new ArrayList<Predicate>();
            x.add(cb.equal((Expression)series.get(Series_.pk), (Object)seriesPk));
            queryBuilder.hideRejectedInstance(x, q, (Path)study, (Path)series, (Path)instance, this.codeCache.findOrCreateEntities(qrView.getShowInstancesRejectedByCodes()), qrView.isHideNotRejectedInstances());
            queryBuilder.hideRejectionNote(x, (Path)instance, this.codeCache.findOrCreateEntities(qrView.getHideRejectionNotesWithCodes()));
            TypedQuery query = this.em.createQuery(q.multiselect(new Selection[]{instance.get(Instance_.sopClassUID), instance.get(Instance_.retrieveAETs), instance.get(Instance_.availability)}).where(x.toArray(new Predicate[0])));
            SeriesQueryAttributesBuilder builder = new SeriesQueryAttributesBuilder((Path<Instance>)instance);
            try (Stream resultStream = query.getResultStream();){
                resultStream.forEach(builder::addInstance);
            }
            SeriesQueryAttributes queryAttrs = builder.build();
            queryAttrs.setViewID(qrView.getViewID());
            queryAttrs.setSeries((Series)this.em.getReference(Series.class, (Object)seriesPk));
            this.em.persist((Object)queryAttrs);
            return queryAttrs;
        }
    }

    public boolean calculateStudyQueryAttributes(Long studyPk) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        HashSet viewIDs = new HashSet(arcDev.getQueryRetrieveViewIDs());
        viewIDs.removeAll(this.em.createNamedQuery("StudyQueryAttributes.viewIDsForStudyPk", String.class).setParameter(1, (Object)studyPk).getResultList());
        for (String viewID : viewIDs) {
            this.service.calculateStudyQueryAttributes(studyPk, arcDev.getQueryRetrieveView(viewID));
        }
        return true;
    }

    public void persist(SeriesQueryAttributes queryAttrs) {
        this.em.persist((Object)queryAttrs);
    }

    static String[] intersection(String[] ss1, String[] ss2) {
        int l = 0;
        for (int i = 0; i < ss1.length; ++i) {
            if (!QueryAttributesEJB.contains(ss2, ss1[i])) continue;
            ss1[l++] = ss1[i];
        }
        if (l == ss1.length) {
            return ss1;
        }
        String[] ss = new String[l];
        System.arraycopy(ss1, 0, ss, 0, l);
        return ss;
    }

    private static boolean contains(String[] ss, String s0) {
        for (String s : ss) {
            if (!s0.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static class StudyQueryAttributesBuilder {
        private final Path<Series> series;
        private final Path<SeriesQueryAttributes> seriesQueryAttributesPath;
        private int numberOfSeries;
        private int numberOfInstances;
        private String[] retrieveAETs;
        private Availability availability;
        private Set<String> mods = new HashSet<String>();
        private Set<String> cuids = new HashSet<String>();

        public StudyQueryAttributesBuilder(Path<Series> series, Path<SeriesQueryAttributes> seriesQueryAttributesPath) {
            this.series = series;
            this.seriesQueryAttributesPath = seriesQueryAttributesPath;
        }

        public void add(Tuple tuple) {
            this.add((Integer)tuple.get((TupleElement)this.seriesQueryAttributesPath.get(SeriesQueryAttributes_.numberOfInstances)), (String)tuple.get((TupleElement)this.series.get(Series_.modality)), (String)tuple.get((TupleElement)this.seriesQueryAttributesPath.get(SeriesQueryAttributes_.sopClassesInSeries)), (String)tuple.get((TupleElement)this.seriesQueryAttributesPath.get(SeriesQueryAttributes_.retrieveAETs)), (Availability)tuple.get((TupleElement)this.seriesQueryAttributesPath.get(SeriesQueryAttributes_.availability)));
        }

        public void add(Tuple tuple, SeriesQueryAttributes seriesQueryAttributes) {
            this.add(seriesQueryAttributes.getNumberOfInstances(), (String)tuple.get((TupleElement)this.series.get(Series_.modality)), seriesQueryAttributes.getSOPClassesInSeries(), seriesQueryAttributes.getRetrieveAETs(), seriesQueryAttributes.getAvailability());
        }

        private void add(int numInstances, String modality, String sopClassesInSeries, String retrieveAETs, Availability availability) {
            if (numInstances == 0) {
                return;
            }
            String[] retrieveAETs1 = StringUtils.split((String)retrieveAETs, (char)'\\');
            this.numberOfInstances += numInstances;
            if (this.numberOfSeries++ == 0) {
                this.retrieveAETs = retrieveAETs1;
                this.availability = availability;
            } else {
                this.retrieveAETs = QueryAttributesEJB.intersection(this.retrieveAETs, retrieveAETs1);
                if (this.availability.compareTo((Enum)availability) < 0) {
                    this.availability = availability;
                }
            }
            if (!modality.equals("*")) {
                this.mods.add(modality);
            }
            for (String cuid : StringUtils.split((String)sopClassesInSeries, (char)'\\')) {
                this.cuids.add(cuid);
            }
        }

        public StudyQueryAttributes build() {
            StudyQueryAttributes queryAttrs = new StudyQueryAttributes();
            queryAttrs.setNumberOfInstances(this.numberOfInstances);
            if (this.numberOfInstances > 0) {
                queryAttrs.setNumberOfSeries(this.numberOfSeries);
                queryAttrs.setModalitiesInStudy(StringUtils.concat(this.mods, (char)'\\'));
                queryAttrs.setSOPClassesInStudy(StringUtils.concat(this.cuids, (char)'\\'));
                queryAttrs.setRetrieveAETs(StringUtils.concat((String[])this.retrieveAETs, (char)'\\'));
                queryAttrs.setAvailability(this.availability);
            }
            return queryAttrs;
        }
    }

    private static class SeriesQueryAttributesBuilder {
        private final Path<Instance> instance;
        private int numberOfInstances;
        private String[] retrieveAETs;
        private Availability availability;
        private Set<String> cuids = new HashSet<String>();

        public SeriesQueryAttributesBuilder(Path<Instance> instance) {
            this.instance = instance;
        }

        public void addInstance(Tuple result) {
            String[] retrieveAETs1 = StringUtils.split((String)((String)result.get((TupleElement)this.instance.get(Instance_.retrieveAETs))), (char)'\\');
            Availability availability1 = (Availability)result.get((TupleElement)this.instance.get(Instance_.availability));
            if (this.numberOfInstances++ == 0) {
                this.retrieveAETs = retrieveAETs1;
                this.availability = availability1;
            } else {
                this.retrieveAETs = QueryAttributesEJB.intersection(this.retrieveAETs, retrieveAETs1);
                if (this.availability.compareTo((Enum)availability1) < 0) {
                    this.availability = availability1;
                }
            }
            this.cuids.add((String)result.get((TupleElement)this.instance.get(Instance_.sopClassUID)));
        }

        public SeriesQueryAttributes build() {
            SeriesQueryAttributes queryAttrs = new SeriesQueryAttributes();
            queryAttrs.setNumberOfInstances(this.numberOfInstances);
            if (this.numberOfInstances > 0) {
                queryAttrs.setSOPClassesInSeries(StringUtils.concat(this.cuids, (char)'\\'));
                queryAttrs.setRetrieveAETs(StringUtils.concat((String[])this.retrieveAETs, (char)'\\'));
                queryAttrs.setAvailability(this.availability);
            }
            return queryAttrs;
        }
    }
}

