/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.impl;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.AttributesBlob_;
import org.dcm4chee.arc.entity.MPPS;
import org.dcm4chee.arc.entity.MPPS_;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.Patient_;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.impl.AbstractQuery;
import org.dcm4chee.arc.query.impl.PatientQuery;
import org.dcm4chee.arc.query.util.QueryBuilder;
import org.dcm4chee.arc.query.util.QueryParam;

public class MPPSQuery
extends AbstractQuery {
    private Join<MPPS, Patient> patient;
    private Root<MPPS> mpps;
    private Path<byte[]> patientAttrBlob;
    private Path<byte[]> mppsAttrBlob;

    public MPPSQuery(QueryContext context, EntityManager em) {
        super(context, em);
    }

    @Override
    protected CriteriaQuery<Tuple> multiselect() {
        CriteriaQuery q = this.cb.createTupleQuery();
        this.mpps = q.from(MPPS.class);
        this.patient = this.mpps.join(MPPS_.patient);
        Selection[] selectionArray = new Selection[14];
        selectionArray[0] = this.mpps.get(MPPS_.pk);
        selectionArray[1] = this.patient.get(Patient_.numberOfStudies);
        selectionArray[2] = this.patient.get(Patient_.createdTime);
        selectionArray[3] = this.patient.get(Patient_.updatedTime);
        selectionArray[4] = this.patient.get(Patient_.verificationTime);
        selectionArray[5] = this.patient.get(Patient_.verificationStatus);
        selectionArray[6] = this.patient.get(Patient_.failedVerifications);
        selectionArray[7] = this.mpps.get(MPPS_.createdTime);
        selectionArray[8] = this.mpps.get(MPPS_.updatedTime);
        selectionArray[9] = this.mpps.get(MPPS_.performedProcedureStepStartDate);
        selectionArray[10] = this.mpps.get(MPPS_.performedProcedureStepStartTime);
        selectionArray[11] = this.mpps.get(MPPS_.status);
        this.patientAttrBlob = this.patient.join(Patient_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[12] = this.patientAttrBlob;
        this.mppsAttrBlob = this.mpps.join(MPPS_.attributesBlob).get(AttributesBlob_.encodedAttributes);
        selectionArray[13] = this.mppsAttrBlob;
        return this.order(this.restrict(q, this.patient, this.mpps, new Predicate[0])).multiselect(selectionArray);
    }

    @Override
    protected CriteriaQuery<Long> count() {
        CriteriaQuery q = this.cb.createQuery(Long.class);
        Root mpps = q.from(MPPS.class);
        return this.createQuery((CriteriaQuery<Long>)q, (Root<MPPS>)mpps, (Expression<Long>)this.cb.count((Expression)mpps), new Predicate[0]);
    }

    @Override
    protected Attributes toAttributes(Tuple results) {
        Attributes mppsAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.mppsAttrBlob)), null);
        Attributes patAttrs = AttributesBlob.decodeAttributes((byte[])((byte[])results.get(this.patientAttrBlob)), null);
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{patAttrs, mppsAttrs});
        Attributes attrs = new Attributes(patAttrs.size() + mppsAttrs.size() + 20);
        attrs.addAll(patAttrs);
        attrs.addAll(mppsAttrs, true);
        PatientQuery.addPatientQRAttrs(this.patient, this.context, results, attrs);
        this.addMPPSQRAttrs((Path<MPPS>)this.mpps, this.context, results, attrs);
        return attrs;
    }

    @Override
    public boolean isOptionalKeysNotSupported() {
        return false;
    }

    private CriteriaQuery<Long> createQuery(CriteriaQuery<Long> q, Root<MPPS> mpps, Expression<Long> longExpression, Predicate ... extra) {
        boolean hasPatientLevelPredicates = QueryBuilder.hasPatientLevelPredicates((IDWithIssuer[])this.context.getPatientIDs(), (Issuer)this.context.getIssuerOfPatientID(), (Attributes)this.context.getQueryKeys(), (QueryParam)this.context.getQueryParam());
        Join patient = null;
        if (hasPatientLevelPredicates) {
            patient = mpps.join(MPPS_.patient);
        }
        return this.restrict(q, (Join<MPPS, Patient>)patient, mpps, extra).select(longExpression);
    }

    private CriteriaQuery<Tuple> order(CriteriaQuery<Tuple> q) {
        if (this.context.getOrderByTags() != null) {
            q.orderBy(this.builder.orderMPPS(this.patient, this.mpps, this.context.getOrderByTags()));
        }
        return q;
    }

    private <T> CriteriaQuery<T> restrict(CriteriaQuery<T> q, Join<MPPS, Patient> patient, Root<MPPS> mpps, Predicate ... extra) {
        List predicates = this.builder.mppsPredicates(q, patient, mpps, this.context.getPatientIDs(), this.context.getIssuerOfPatientID(), this.context.getQueryKeys(), this.context.getQueryParam());
        for (Predicate predicate : extra) {
            predicates.add(predicate);
        }
        if (!predicates.isEmpty()) {
            q.where(predicates.toArray(new Predicate[0]));
        }
        return q;
    }

    private void addMPPSQRAttrs(Path<MPPS> mpps, QueryContext context, Tuple results, Attributes attrs) {
        if (!context.isReturnPrivate()) {
            return;
        }
        MPPSQuery.setDTwTZ(attrs, 0x77770070, (Date)results.get((TupleElement)mpps.get(MPPS_.createdTime)));
        MPPSQuery.setDTwTZ(attrs, 0x77770071, (Date)results.get((TupleElement)mpps.get(MPPS_.updatedTime)));
    }
}

