/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.patient.impl;

import java.net.InetAddress;
import java.net.Socket;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;

public class PatientMgtContextImpl
implements PatientMgtContext {
    private final AttributeFilter attributeFilter;
    private final AttributeFilter studyAttributeFilter;
    private final FuzzyStr fuzzyStr;
    private HL7Application hl7app;
    private Association as;
    private Socket socket;
    private UnparsedHL7Message msg;
    private IDWithIssuer patientID;
    private Attributes attributes;
    private IDWithIssuer previousPatientID;
    private Attributes previousAttributes;
    private Attributes.UpdatePolicy attributeUpdatePolicy = Attributes.UpdatePolicy.OVERWRITE;
    private String eventActionCode = "R";
    private Exception exception;
    private Patient patient;
    private HttpServletRequestInfo httpServletRequestInfo;
    private Patient.VerificationStatus patientVerificationStatus = Patient.VerificationStatus.UNVERIFIED;
    private String pdqServiceURI;
    private ArchiveAEExtension arcAE;
    private String localAET;
    private String sourceMwlScp;

    PatientMgtContextImpl(Device device) {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)device.getDeviceExtension(ArchiveDeviceExtension.class);
        this.attributeFilter = arcDev.getAttributeFilter(Entity.Patient);
        this.studyAttributeFilter = arcDev.getAttributeFilter(Entity.Study);
        this.fuzzyStr = arcDev.getFuzzyStr();
    }

    void setHL7Application(HL7Application hl7app) {
        this.hl7app = hl7app;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    void setAssociation(Association as) {
        this.as = as;
        this.socket = as.getSocket();
        this.arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    public String toString() {
        return this.as != null ? this.as.toString() : (this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requesterHost : (this.socket != null ? this.socket.toString() : (this.localAET != null ? this.localAET : "PatientMgtContext")));
    }

    @Override
    public AttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    @Override
    public AttributeFilter getStudyAttributeFilter() {
        return this.studyAttributeFilter;
    }

    @Override
    public FuzzyStr getFuzzyStr() {
        return this.fuzzyStr;
    }

    @Override
    public Association getAssociation() {
        return this.as;
    }

    @Override
    public UnparsedHL7Message getUnparsedHL7Message() {
        return this.msg;
    }

    @Override
    public void setUnparsedHL7Message(UnparsedHL7Message msg) {
        this.msg = msg;
    }

    @Override
    public String getRemoteHostName() {
        return this.httpServletRequestInfo != null ? this.httpServletRequestInfo.requesterHost : (this.socket != null ? ReverseDNS.hostNameOf((InetAddress)this.socket.getInetAddress()) : null);
    }

    @Override
    public boolean isNoPatientCreate() {
        if (this.hl7app == null) {
            return false;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)this.hl7app.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        return arcHL7App != null && arcHL7App.isHL7NoPatientCreateMessageType(this.msg.msh().getMessageType());
    }

    @Override
    public IDWithIssuer getPatientID() {
        return this.patientID;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Attributes attrs) {
        this.attributes = attrs;
        this.patientID = IDWithIssuer.pidOf((Attributes)attrs);
    }

    @Override
    public IDWithIssuer getPreviousPatientID() {
        return this.previousPatientID;
    }

    @Override
    public Attributes getPreviousAttributes() {
        return this.previousAttributes;
    }

    @Override
    public void setPreviousAttributes(Attributes attrs) {
        this.previousAttributes = attrs;
        this.previousPatientID = attrs != null ? IDWithIssuer.pidOf((Attributes)attrs) : null;
    }

    @Override
    public Attributes.UpdatePolicy getAttributeUpdatePolicy() {
        return this.attributeUpdatePolicy;
    }

    @Override
    public void setAttributeUpdatePolicy(Attributes.UpdatePolicy updatePolicy) {
        this.attributeUpdatePolicy = updatePolicy;
    }

    @Override
    public String getEventActionCode() {
        return this.eventActionCode;
    }

    @Override
    public void setEventActionCode(String eventActionCode) {
        this.eventActionCode = eventActionCode;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void setPatientID(IDWithIssuer patientID) {
        this.patientID = patientID;
    }

    @Override
    public Patient getPatient() {
        return this.patient;
    }

    @Override
    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    @Override
    public HttpServletRequestInfo getHttpServletRequestInfo() {
        return this.httpServletRequestInfo;
    }

    @Override
    public void setHttpServletRequestInfo(HttpServletRequestInfo httpServletRequestInfo) {
        this.httpServletRequestInfo = httpServletRequestInfo;
    }

    @Override
    public Patient.VerificationStatus getPatientVerificationStatus() {
        return this.patientVerificationStatus;
    }

    @Override
    public void setPatientVerificationStatus(Patient.VerificationStatus patientVerificationStatus) {
        this.patientVerificationStatus = patientVerificationStatus;
    }

    @Override
    public String getPDQServiceURI() {
        return this.pdqServiceURI;
    }

    @Override
    public void setPDQServiceURI(String pdqServiceURI) {
        this.pdqServiceURI = pdqServiceURI;
    }

    @Override
    public ArchiveAEExtension getArchiveAEExtension() {
        return this.arcAE;
    }

    @Override
    public void setArchiveAEExtension(ArchiveAEExtension arcAE) {
        this.arcAE = arcAE;
    }

    @Override
    public HL7Application getHL7Application() {
        return this.hl7app;
    }

    @Override
    public String getLocalAET() {
        return this.localAET;
    }

    @Override
    public void setLocalAET(String localAET) {
        this.localAET = localAET;
    }

    @Override
    public String getSourceMwlScp() {
        return this.sourceMwlScp;
    }

    @Override
    public void setSourceMwlScp(String sourceMwlScp) {
        this.sourceMwlScp = sourceMwlScp;
    }
}

