/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.scp;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.AttributesCoercion;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicQueryTask;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.RunInTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MWLQueryTask
extends BasicQueryTask {
    private static final Logger LOG = LoggerFactory.getLogger(MWLQueryTask.class);
    private final Query query;
    private final AttributesCoercion coercion;
    private final RunInTransaction runInTx;

    public MWLQueryTask(Association as, PresentationContext pc, Attributes rq, Attributes keys, Query query, AttributesCoercion coercion, RunInTransaction runInTx) {
        super(as, pc, rq, keys);
        this.query = query;
        this.coercion = coercion;
        this.runInTx = runInTx;
        this.setOptionalKeysNotSupported(query.isOptionalKeysNotSupported());
    }

    public void run() {
        this.runInTx.execute(this::run0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run0() {
        try {
            QueryContext ctx = this.query.getQueryContext();
            ArchiveAEExtension arcAE = ctx.getArchiveAEExtension();
            ArchiveDeviceExtension arcdev = arcAE.getArchiveDeviceExtension();
            this.query.executeQuery(arcdev.getQueryFetchSize());
            super.run();
        }
        catch (Exception e) {
            this.writeDimseRSP(new DicomServiceException(49152, (Throwable)e));
        }
        finally {
            this.query.close();
        }
    }

    private void writeDimseRSP(DicomServiceException e) {
        int msgId = this.rq.getInt(272, -1);
        Attributes rsp = e.mkRSP(Dimse.C_FIND_RSP.commandField(), msgId);
        try {
            this.as.writeDimseRSP(this.pc, rsp, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean hasMoreMatches() throws DicomServiceException {
        try {
            return this.query.hasMoreMatches();
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected Attributes nextMatch() throws DicomServiceException {
        try {
            return this.query.nextMatch();
        }
        catch (Exception e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected Attributes adjust(Attributes match) throws DicomServiceException {
        if (match == null) {
            return null;
        }
        if (this.coercion != null) {
            try {
                this.coercion.coerce(match, null);
            }
            catch (DicomServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DicomServiceException(49152, (Throwable)e);
            }
        }
        return this.query.adjust(match);
    }
}

