/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.mpps.scp;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.service.BasicMPPSSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceApplicationException;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.mpps.MPPSContext;
import org.dcm4chee.arc.mpps.MPPSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={DicomService.class})
class MPPSSCP
extends BasicMPPSSCP {
    private static final Logger LOG = LoggerFactory.getLogger(MPPSSCP.class);
    @Inject
    private MPPSService mppsService;
    @Inject
    Event<MPPSContext> mppsEvent;

    MPPSSCP() {
    }

    protected Attributes create(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
        MPPSContext ctx = this.mppsService.newMPPSContext(as);
        ctx.setDimse(Dimse.N_CREATE_RQ);
        ctx.setSopInstanceUID(rsp.getString(4096));
        ctx.setAttributes(rqAttrs);
        try {
            ctx.setMPPS(this.mppsService.createMPPS(ctx));
        }
        catch (DicomServiceException e) {
            ctx.setException((Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            DicomServiceException dse;
            try {
                this.mppsService.findMPPS(ctx);
                dse = new DicomServiceApplicationException(273, "duplicate SOP Instance", false);
            }
            catch (Exception e1) {
                dse = new DicomServiceException(272, (Throwable)e);
            }
            dse.setUID(2, "1.2.840.10008.3.1.2.3.3");
            dse.setUID(4096, rsp.getString(4096));
            throw dse;
        }
        this.fire(ctx);
        return null;
    }

    protected Attributes set(Association as, Attributes rq, Attributes rqAttrs, Attributes rsp) throws DicomServiceException {
        MPPSContext ctx = this.mppsService.newMPPSContext(as);
        ctx.setDimse(Dimse.N_SET_RQ);
        ctx.setSopInstanceUID(rq.getString(4097));
        ctx.setAttributes(rqAttrs);
        try {
            ctx.setMPPS(this.mppsService.updateMPPS(ctx));
        }
        catch (DicomServiceException e) {
            ctx.setException((Exception)((Object)e));
            throw e;
        }
        catch (PersistenceException e) {
            DicomServiceException dse = new DicomServiceException(272, (Throwable)e);
            ctx.setException((Exception)((Object)dse));
            throw dse;
        }
        this.fire(ctx);
        return null;
    }

    private void fire(MPPSContext ctx) {
        try {
            this.mppsEvent.fire((Object)ctx);
        }
        catch (Exception e) {
            LOG.warn("Failed on firing MPPS context :\n", (Throwable)e);
        }
    }
}

