/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.mgt.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ejb.EJBException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.ExportRule;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.QueueDescriptor;
import org.dcm4chee.arc.conf.ScheduleExpression;
import org.dcm4chee.arc.export.mgt.ExportManager;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExportScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(ExportScheduler.class);
    @Inject
    private Device device;
    @Inject
    private ExportManager ejb;
    @Inject
    private IDeviceCache deviceCache;

    public void onStore(@Observes StoreContext ctx) {
        if (ctx.getException() != null) {
            return;
        }
        StoreSession session = ctx.getStoreSession();
        Calendar now = Calendar.getInstance();
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        arcAE.exportRules().filter(rule -> rule.match(arg_0 -> ((StoreContext)ctx).match(arg_0), now, session.getRemoteHostName(), session.getCallingAET(), session.getLocalHostName(), session.getCalledAET(), ctx.getAttributes())).flatMap(rule -> Stream.of(rule.getExporterIDs()).map(exporterID1 -> new Object[]{exporterID1, rule})).collect(Collectors.toMap(a -> (String)a[0], a -> (ExportRule)a[1], (r1, r2) -> r1.getEntity().compareTo((Enum)r2.getEntity()) < 0 ? r1 : r2)).forEach((exporterID, rule) -> this.updateOrCreateExportTask(ctx, now, (String)exporterID, (ExportRule)rule));
    }

    private void updateOrCreateExportTask(StoreContext ctx, Calendar now, String exporterID, ExportRule rule) {
        ArchiveDeviceExtension arcDev;
        StoreSession session = ctx.getStoreSession();
        String exporterDeviceName = rule.getExporterDeviceName();
        Device exporterDevice = this.device;
        if (exporterDeviceName != null && !exporterDeviceName.equals(this.device.getDeviceName())) {
            try {
                exporterDevice = this.deviceCache.findDevice(exporterDeviceName);
            }
            catch (ConfigurationException e) {
                LOG.warn("{}: Failed to process {} - ", new Object[]{session, rule, e});
                return;
            }
        }
        if ((arcDev = (ArchiveDeviceExtension)exporterDevice.getDeviceExtension(ArchiveDeviceExtension.class)) == null) {
            LOG.warn("{}: Failed to process {} - {} is not an Archive Device", new Object[]{session, rule, exporterDevice.getDeviceName()});
            return;
        }
        ExporterDescriptor exporterDesc = arcDev.getExporterDescriptor(exporterID);
        if (exporterDesc == null) {
            LOG.warn("{}: Failed to process {} - no Exporter {} configured on Archive Device {}", new Object[]{session, rule, exporterID, exporterDevice.getDeviceName()});
            return;
        }
        String queueName = exporterDesc.getQueueName();
        QueueDescriptor queueDesc = arcDev.getQueueDescriptor(queueName);
        if (queueDesc == null) {
            LOG.warn("{}: Failed to process {} - no Queue {} configured on Archive Device {}", new Object[]{session, rule, queueName, exporterDevice.getDeviceName()});
            return;
        }
        Date scheduledTime = this.scheduledTime(now, rule.getExportDelay(), exporterDesc.getSchedules());
        switch (rule.getEntity()) {
            case Study: {
                this.createOrUpdateStudyExportTask(session, exporterDevice.getDeviceName(), exporterDesc, ctx.getStudyInstanceUID(), scheduledTime);
                if (!rule.isExportPreviousEntity() || !ctx.isPreviousDifferentStudy()) break;
                this.createOrUpdateStudyExportTask(session, exporterDevice.getDeviceName(), exporterDesc, ctx.getPreviousInstance().getSeries().getStudy().getStudyInstanceUID(), scheduledTime);
                break;
            }
            case Series: {
                this.createOrUpdateSeriesExportTask(session, exporterDevice.getDeviceName(), exporterDesc, ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), scheduledTime);
                if (!rule.isExportPreviousEntity() || !ctx.isPreviousDifferentSeries()) break;
                this.createOrUpdateSeriesExportTask(session, exporterDevice.getDeviceName(), exporterDesc, ctx.getPreviousInstance().getSeries().getStudy().getStudyInstanceUID(), ctx.getPreviousInstance().getSeries().getSeriesInstanceUID(), scheduledTime);
                break;
            }
            case Instance: {
                this.createOrUpdateInstanceExportTask(session, exporterDevice.getDeviceName(), exporterDesc, ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), scheduledTime);
            }
        }
    }

    private Date scheduledTime(Calendar cal, Duration exportDelay, ScheduleExpression[] schedules) {
        if (exportDelay != null) {
            cal = (Calendar)cal.clone();
            cal.add(13, (int)exportDelay.getSeconds());
        }
        cal = ScheduleExpression.ceil((Calendar)cal, (ScheduleExpression[])schedules);
        return cal.getTime();
    }

    private boolean createOrUpdateStudyExportTask(StoreSession session, String deviceName, ExporterDescriptor exporterDesc, String studyIUID, Date scheduledTime) {
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                this.ejb.createOrUpdateStudyExportTask(deviceName, exporterDesc, studyIUID, scheduledTime);
                return true;
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    LOG.warn("{}: Failed to update Study Export Task:\n", (Object)session, (Object)e);
                    return false;
                }
                LOG.info("{}: Failed to update Study Export Task caused by {} - retry", (Object)session, (Object)DicomServiceException.initialCauseOf((Throwable)e));
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("{}: Failed to delay retry to update Study Export Task:\n", (Object)session, (Object)e2);
                    continue;
                }
            }
            break;
        }
    }

    private boolean createOrUpdateSeriesExportTask(StoreSession session, String deviceName, ExporterDescriptor exporterDesc, String studyIUID, String seriesIUID, Date scheduledTime) {
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                this.ejb.createOrUpdateSeriesExportTask(deviceName, exporterDesc, studyIUID, seriesIUID, scheduledTime);
                return true;
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    LOG.warn("{}: Failed to update Series Export Task:\n", (Object)session, (Object)e);
                    return false;
                }
                LOG.info("{}: Failed to update Series Export Task caused by {} - retry", (Object)session, (Object)DicomServiceException.initialCauseOf((Throwable)e));
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("{}: Failed to delay retry to update Series Export Task:\n", (Object)session, (Object)e2);
                    continue;
                }
            }
            break;
        }
    }

    private boolean createOrUpdateInstanceExportTask(StoreSession session, String deviceName, ExporterDescriptor exporterDesc, String studyIUID, String seriesIUID, String sopIUID, Date scheduledTime) {
        ArchiveAEExtension arcAE = session.getArchiveAEExtension();
        ArchiveDeviceExtension arcDev = arcAE.getArchiveDeviceExtension();
        int retries = arcDev.getStoreUpdateDBMaxRetries();
        while (true) {
            try {
                this.ejb.createOrUpdateInstanceExportTask(deviceName, exporterDesc, studyIUID, seriesIUID, sopIUID, scheduledTime);
                return true;
            }
            catch (EJBException e) {
                if (retries-- <= 0) {
                    LOG.warn("{}: Failed to update Instance Export Task:\n", (Object)session, (Object)e);
                    return false;
                }
                LOG.info("{}: Failed to update Instance Export Task caused by {} - retry", (Object)session, (Object)DicomServiceException.initialCauseOf((Throwable)e));
                try {
                    Thread.sleep(arcDev.storeUpdateDBRetryDelay());
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.info("{}: Failed to delay retry to update Instance Export Task:\n", (Object)session, (Object)e2);
                    continue;
                }
            }
            break;
        }
    }
}

