/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.export.dcm2ups;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ExporterDescriptor;
import org.dcm4chee.arc.conf.InputReadinessState;
import org.dcm4chee.arc.conf.UPSPriority;
import org.dcm4chee.arc.conf.UPSState;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.export.dcm2ups.EntityType;
import org.dcm4chee.arc.exporter.AbstractExporter;
import org.dcm4chee.arc.exporter.ExportContext;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.query.QueryService;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcm2UpsExporter
extends AbstractExporter {
    private static final Logger LOG = LoggerFactory.getLogger(Dcm2UpsExporter.class);
    private static final ElementDictionary DICT = ElementDictionary.getStandardElementDictionary();
    private static final String DEFAULT_INPUT_READINESS_STATE = "READY";
    private static final String DEFAULT_SCHEDULED_PROCEDURE_STEP_PRIORITY = "MEDIUM";
    private static final String DEFAULT_PROCEDURE_STEP_LABEL = "DEFAULT";
    private static final MediaType DEFAULT_CONTENT_TYPE = MediaTypes.APPLICATION_DICOM_JSON_TYPE;
    private final String destWebAppName;
    private final Device device;
    private final QueryService queryService;
    private final IWebApplicationCache webAppCache;
    private final AccessTokenRequestor accessTokenRequestor;
    private final AttributesFormat procedureStepLabel;
    private final boolean copyPatient;
    private final boolean copyVisit;
    private final boolean copyRequest;
    private String inputReadinessState;
    private String upsPriority;
    private static final int[] REQUEST_ATTR = new int[]{0x20000D, 524368, 524369, 524432};
    private static final int[] PATIENT_ATTR = new int[]{0x100010, 0x100020, 0x100021, 1048612, 0x100030, 0x100040, 0x101002};
    private static final int[] VISIT_ATTR = new int[]{3670032, 3670036};
    private static final int[] TYPE2_ATTR = new int[]{7606786, 7606800, 4210725, 4210726, 4210727, 0x404034, 4210712, 0x400400, 528512, 528516, 4194342, 4194343, 0x401001, 3280992, 3280996, 7606274, 7606806};

    public Dcm2UpsExporter(ExporterDescriptor descriptor, Device device, QueryService queryService, IWebApplicationCache webAppCache, AccessTokenRequestor accessTokenRequestor) {
        super(descriptor);
        this.destWebAppName = descriptor.getExportURI().getSchemeSpecificPart();
        this.device = device;
        this.queryService = queryService;
        this.webAppCache = webAppCache;
        this.accessTokenRequestor = accessTokenRequestor;
        this.procedureStepLabel = AttributesFormat.valueOf((String)descriptor.getProperty("ProcedureStepLabel", DEFAULT_PROCEDURE_STEP_LABEL));
        this.copyPatient = Boolean.parseBoolean(descriptor.getProperty("patient", "false"));
        this.copyVisit = Boolean.parseBoolean(descriptor.getProperty("visit", "false"));
        this.copyRequest = Boolean.parseBoolean(descriptor.getProperty("request", "false"));
    }

    public Outcome export(ExportContext ctx) throws Exception {
        WebApplication destWebApp = this.webAppCache.findWebApplication(this.destWebAppName);
        if (!destWebApp.containsServiceClass(WebApplication.ServiceClass.UPS_RS)) {
            return new Outcome(Task.Status.WARNING, "Destination webapp " + this.destWebAppName + " is not configured for UPS_RS web service");
        }
        try {
            this.setInputReadinessState(this.descriptor.getProperty("InputReadinessState", DEFAULT_INPUT_READINESS_STATE));
            this.setUPSPriority(this.descriptor.getProperty("ScheduledProcedureStepPriority", DEFAULT_SCHEDULED_PROCEDURE_STEP_PRIORITY));
        }
        catch (IllegalArgumentException e) {
            return new Outcome(Task.Status.WARNING, e.getMessage());
        }
        String url = destWebApp.getServiceURL().append("/workitems").toString();
        Map properties = destWebApp.getProperties();
        ResteasyClient client = this.accessTokenRequestor.resteasyClientBuilder(url, Boolean.parseBoolean((String)properties.get("allow-any-hostname")), Boolean.parseBoolean((String)properties.get("disable-trust-manager"))).build();
        ResteasyWebTarget target = client.target(url);
        Invocation.Builder request = target.request();
        String token = this.authorization(destWebApp);
        if (token != null) {
            request.header("Authorization", (Object)token);
        }
        ApplicationEntity ae = this.device.getApplicationEntity(this.descriptor.getAETitle(), true);
        Attributes upsInfo = this.queryService.createUPSInfo(ae, ctx.getStudyInstanceUID(), ctx.getSeriesInstanceUID(), ctx.getSopInstanceUID(), this.descriptor);
        return this.outcome(request.post(EntityType.valueOf(this.mediaType((String)properties.get("content-type"))).entity(this.upsAttrs(upsInfo))));
    }

    public String getInputReadinessState() {
        return this.inputReadinessState;
    }

    public void setInputReadinessState(String inputReadinessState) {
        this.inputReadinessState = InputReadinessState.valueOf((String)inputReadinessState).name();
    }

    public String getUPSPriority() {
        return this.upsPriority;
    }

    public void setUPSPriority(String upsPriority) {
        this.upsPriority = UPSPriority.valueOf((String)upsPriority).name();
    }

    private Attributes upsAttrs(Attributes attrs) {
        Attributes upsAttrs = new Attributes();
        upsAttrs.setString(524293, VR.CS, attrs.getString(524293));
        this.copyFromEntity(upsAttrs, attrs, this.copyPatient, PATIENT_ATTR);
        this.copyFromEntity(upsAttrs, attrs, this.copyVisit, VISIT_ATTR);
        if (this.copyRequest) {
            Attributes refReq = new Attributes();
            this.copyFromEntity(refReq, attrs, true, REQUEST_ATTR);
            upsAttrs.newSequence(4236144, 1).add(refReq);
        }
        upsAttrs.setString(0x404041, VR.CS, this.getInputReadinessState());
        upsAttrs.setString(7606784, VR.CS, this.getUPSPriority());
        upsAttrs.setString(7606788, VR.LO, Dcm2UpsExporter.format(this.procedureStepLabel, attrs));
        this.includeInputInformation(upsAttrs, attrs);
        upsAttrs.setDate(0x404005, VR.DT, new Date[]{new Date()});
        upsAttrs.setString(7606272, VR.CS, UPSState.SCHEDULED.name());
        this.addType2Attrs(upsAttrs, TYPE2_ATTR, attrs);
        return upsAttrs;
    }

    private static String format(AttributesFormat format, Attributes attrs) {
        return format != null ? (String)StringUtils.nullify((Object)format.format((Object)attrs), (Object)"null") : null;
    }

    private void includeInputInformation(Attributes upsAttrs, Attributes attrs) {
        Sequence refSeriesSeq = attrs.getSequence(528661);
        String studyIUID = attrs.getString(0x20000D);
        Sequence inputInfoSeq = upsAttrs.newSequence(4210721, refSeriesSeq.size());
        refSeriesSeq.forEach(refSeries -> inputInfoSeq.add(this.addInputInfo((Attributes)refSeries, studyIUID)));
    }

    private Attributes addInputInfo(Attributes refSeries, String studyIUID) {
        Attributes inputInfo = new Attributes();
        inputInfo.setString(4251680, VR.CS, "DICOM");
        inputInfo.setString(0x20000D, VR.UI, studyIUID);
        inputInfo.setString(0x20000E, VR.UI, refSeries.getString(0x20000E));
        inputInfo.newSequence(4251681, 1).add(this.retrieveAETItem(refSeries.getNestedDataset(528793)));
        Sequence srcRefSOPSeq = refSeries.getSequence(528793);
        Sequence refSOPSeq = inputInfo.newSequence(528793, srcRefSOPSeq.size());
        srcRefSOPSeq.forEach(srcRefSOP -> refSOPSeq.add(this.addRefSOP((Attributes)srcRefSOP)));
        return inputInfo;
    }

    private Attributes addRefSOP(Attributes srcRefSOP) {
        Attributes refSOP = new Attributes(2);
        refSOP.setString(528720, VR.UI, srcRefSOP.getString(528720));
        refSOP.setString(528725, VR.UI, srcRefSOP.getString(528725));
        return refSOP;
    }

    private Attributes retrieveAETItem(Attributes refSop) {
        Attributes item = new Attributes(1);
        item.setString(524372, VR.AE, refSop.getString(524372));
        return item;
    }

    private void copyFromEntity(Attributes upsAttrs, Attributes attrs, boolean copyEntity, int[] tags) {
        if (!copyEntity) {
            this.addType2Attrs(upsAttrs, tags, attrs);
            return;
        }
        for (int tag : tags) {
            this.copyFromEntity(upsAttrs, attrs, tag);
        }
    }

    private void addType2Attrs(Attributes upsAttrs, int[] tags, Attributes attrs) {
        for (int tag : tags) {
            VR vr = DICT.vrOf(tag);
            if (vr == VR.SQ) {
                upsAttrs.setNull(tag, vr);
                continue;
            }
            upsAttrs.setString(tag, vr, this.formatFromPropsOrNull(tag, attrs));
        }
    }

    private void copyFromEntity(Attributes upsAttrs, Attributes attrs, int tag) {
        VR vr = DICT.vrOf(tag);
        if (vr == VR.SQ) {
            this.setNullOrNestedVal(upsAttrs, attrs, tag);
        } else {
            String val = attrs.getString(tag);
            upsAttrs.setString(tag, vr, val == null ? this.formatFromPropsOrNull(tag, attrs) : val);
        }
    }

    private String formatFromPropsOrNull(int tag, Attributes attrs) {
        String keyword = DICT.keywordOf(tag);
        Map properties = this.descriptor.getProperties();
        return properties.containsKey(keyword) ? Dcm2UpsExporter.format(new AttributesFormat((String)properties.get(keyword)), attrs) : null;
    }

    private void setNullOrNestedVal(Attributes upsAttrs, Attributes attrs, int tag) {
        Attributes sqItem = attrs.getNestedDataset(tag);
        if (sqItem == null) {
            upsAttrs.setNull(tag, VR.SQ);
        } else {
            upsAttrs.newSequence(tag, 1).add(new Attributes(sqItem));
        }
    }

    private MediaType mediaType(String contentType) {
        MediaType mediaType = DEFAULT_CONTENT_TYPE;
        if (contentType == null) {
            return mediaType;
        }
        if (contentType.equals("xml")) {
            mediaType = MediaTypes.APPLICATION_DICOM_XML_TYPE;
        } else {
            LOG.info("Invalid Content type configured on web application [name={}, content-type={}]. Fallback to application/dicom+json", (Object)this.destWebAppName, (Object)contentType);
        }
        return mediaType;
    }

    private Outcome outcome(Response rsp) {
        int status = rsp.getStatus();
        if (status == Response.Status.CREATED.getStatusCode()) {
            return new Outcome(Task.Status.COMPLETED, "UPS created at : " + rsp.getHeaderString("Location"));
        }
        return new Outcome(Task.Status.WARNING, "UPS creation unsuccessful : " + rsp.getHeaderString("Warning"));
    }

    private String authorization(WebApplication destWebApp) throws Exception {
        Map properties = destWebApp.getProperties();
        return destWebApp.getKeycloakClientID() != null ? "Bearer " + this.accessTokenRequestor.getAccessToken2(destWebApp).getToken() : (properties.containsKey("bearer-token") ? "Bearer " + (String)properties.get("bearer-token") : (properties.containsKey("basic-auth") ? "Basic " + this.encodeBase64(((String)properties.get("basic-auth")).getBytes(StandardCharsets.UTF_8)) : null));
    }

    private String encodeBase64(byte[] b) {
        int len = b.length * 4 / 3 + 3 & 0xFFFFFFFC;
        char[] ch = new char[len];
        Base64.encode((byte[])b, (int)0, (int)b.length, (char[])ch, (int)0);
        return new String(ch);
    }
}

