/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ValueSelector;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.BlobCorruptedException;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.ContentItem;
import org.dcm4chee.arc.entity.InstanceRequestAttributes;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.VerifyingObserver;

@NamedQueries(value={@NamedQuery(name="Instance.findBySopIUIDEager", query="select i from Instance i join fetch i.series se join fetch se.study st join fetch st.patient p left join fetch p.patientID left join fetch p.patientName left join fetch st.referringPhysicianName left join fetch se.performingPhysicianName left join fetch i.conceptNameCode join fetch i.attributesBlob join fetch se.attributesBlob join fetch st.attributesBlob join fetch p.attributesBlob where i.sopInstanceUID = ?1"), @NamedQuery(name="Instance.findLastModifiedStudyLevel", query="SELECT p.updatedTime, st.modifiedTime, MAX(se.modifiedTime), MAX(i.updatedTime) from Instance i JOIN i.series se JOIN se.study st JOIN st.patient p where st.studyInstanceUID = ?1 GROUP BY p, st"), @NamedQuery(name="Instance.findLastModifiedSeriesLevel", query="SELECT p.updatedTime, st.modifiedTime, se.modifiedTime, MAX(i.updatedTime) from Instance i JOIN i.series se JOIN se.study st JOIN st.patient p where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 GROUP BY p, st, se"), @NamedQuery(name="Instance.findLastModifiedInstanceLevel", query="SELECT p.updatedTime, st.modifiedTime, se.modifiedTime, i.updatedTime from Instance i JOIN i.series se JOIN se.study st JOIN st.patient p where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 and i.sopInstanceUID = ?3"), @NamedQuery(name="Instance.maxUpdateTimeOfSeries", query="SELECT MAX(i.updatedTime) from Instance i where i.series = ?1"), @NamedQuery(name="Instance.findByStudySeriesSopIUIDEager", query="select i from Instance i join fetch i.series se join fetch se.study st join fetch st.patient p left join fetch p.patientID left join fetch p.patientName left join fetch st.referringPhysicianName left join fetch se.performingPhysicianName left join fetch i.conceptNameCode join fetch i.attributesBlob join fetch se.attributesBlob join fetch st.attributesBlob join fetch p.attributesBlob where st.studyInstanceUID = ?1 and se.seriesInstanceUID = ?2 and i.sopInstanceUID = ?3"), @NamedQuery(name="Instance.countRejectedInstancesOfSeries", query="select count(i) from Instance i where i.series = ?1 and i.sopInstanceUID in (select ri.sopInstanceUID from RejectedInstance ri where ri.studyInstanceUID = i.series.study.studyInstanceUID and ri.seriesInstanceUID = i.series.seriesInstanceUID)"), @NamedQuery(name="Instance.countNotRejectedInstancesOfSeries", query="select count(i) from Instance i where i.series = ?1 and i.sopInstanceUID not in (select ri.sopInstanceUID from RejectedInstance ri where ri.studyInstanceUID = i.series.study.studyInstanceUID and ri.seriesInstanceUID = i.series.seriesInstanceUID)"), @NamedQuery(name="Instance.countInstancesOfSeries", query="select count(i) from Instance i where i.series = ?1"), @NamedQuery(name="Instance.findByStudyIUID", query="select instance from Instance instance where instance.series.study.studyInstanceUID = ?1"), @NamedQuery(name="Instance.iuidsOfStudy", query="select instance.series.study.studyInstanceUID, instance.series.seriesInstanceUID, instance.sopInstanceUID, instance.numberOfFrames from Instance instance where instance.series.study.studyInstanceUID = ?1 "), @NamedQuery(name="Instance.iuidsOfSeries", query="select instance.series.study.studyInstanceUID, instance.series.seriesInstanceUID, instance.sopInstanceUID, instance.numberOfFrames from Instance instance where instance.series.study.studyInstanceUID = ?1 and instance.series.seriesInstanceUID = ?2"), @NamedQuery(name="Instance.iuidsOfSeries2", query="select i.sopInstanceUID from Instance i where i.series = ?1"), @NamedQuery(name="Instance.numberOfFrames", query="select instance.numberOfFrames from Instance instance where instance.series.study.studyInstanceUID = ?1 and instance.series.seriesInstanceUID = ?2 and instance.sopInstanceUID = ?3"), @NamedQuery(name="Instance.updateAvailabilityOfStudy", query="update Instance i set i.availability = ?2 where i.series in (select ser from Series ser where ser.study = ?1)"), @NamedQuery(name="Instance.updateAvailabilityByStudyIUID", query="update Instance i set i.availability = ?2 where i.series in (select ser from Series ser where ser.study.studyInstanceUID = ?1)"), @NamedQuery(name="Instance.updateAvailabilityBySeriesIUID", query="update Instance i set i.availability = ?2 where i.series in (select ser from Series ser where ser.seriesInstanceUID = ?1)"), @NamedQuery(name="Instance.updateAvailabilityBySopIUID", query="update Instance i set i.availability = ?2 where i.sopInstanceUID = ?1")})
@Entity
@Table(name="instance", uniqueConstraints={@UniqueConstraint(columnNames={"series_fk", "sop_iuid"})}, indexes={@Index(columnList="sop_iuid"), @Index(columnList="sop_cuid"), @Index(columnList="inst_no"), @Index(columnList="content_date"), @Index(columnList="content_time"), @Index(columnList="sr_verified"), @Index(columnList="sr_complete"), @Index(columnList="inst_custom1"), @Index(columnList="inst_custom2"), @Index(columnList="inst_custom3")})
public class Instance {
    public static final String FIND_BY_SOP_IUID_EAGER = "Instance.findBySopIUIDEager";
    public static final String FIND_BY_STUDY_SERIES_SOP_IUID_EAGER = "Instance.findByStudySeriesSopIUIDEager";
    public static final String COUNT_INSTANCES_OF_SERIES = "Instance.countInstancesOfSeries";
    public static final String COUNT_REJECTED_INSTANCES_OF_SERIES = "Instance.countRejectedInstancesOfSeries";
    public static final String COUNT_NOT_REJECTED_INSTANCES_OF_SERIES = "Instance.countNotRejectedInstancesOfSeries";
    public static final String FIND_BY_STUDY_IUID = "Instance.findByStudyIUID";
    public static final String IUIDS_OF_STUDY = "Instance.iuidsOfStudy";
    public static final String IUIDS_OF_SERIES = "Instance.iuidsOfSeries";
    public static final String IUIDS_OF_SERIES2 = "Instance.iuidsOfSeries2";
    public static final String NUMBER_OF_FRAMES = "Instance.numberOfFrames";
    public static final String FIND_LAST_MODIFIED_STUDY_LEVEL = "Instance.findLastModifiedStudyLevel";
    public static final String FIND_LAST_MODIFIED_SERIES_LEVEL = "Instance.findLastModifiedSeriesLevel";
    public static final String FIND_LAST_MODIFIED_INSTANCE_LEVEL = "Instance.findLastModifiedInstanceLevel";
    public static final String MAX_UPDATED_TIME_OF_SERIES = "Instance.maxUpdateTimeOfSeries";
    public static final String UPDATE_AVAILABILITY_OF_STUDY = "Instance.updateAvailabilityOfStudy";
    public static final String UPDATE_AVAILABILITY_BY_STUDY_IUID = "Instance.updateAvailabilityByStudyIUID";
    public static final String UPDATE_AVAILABILITY_BY_SERIES_IUID = "Instance.updateAvailabilityBySeriesIUID";
    public static final String UPDATE_AVAILABILITY_BY_SOP_IUID = "Instance.updateAvailabilityBySopIUID";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pk")
    private long pk;
    @Version
    @Column(name="version")
    private long version;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time", updatable=false)
    private Date createdTime;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_time")
    private Date updatedTime;
    @Basic(optional=false)
    @Column(name="sop_iuid", updatable=false)
    private String sopInstanceUID;
    @Basic(optional=false)
    @Column(name="sop_cuid", updatable=false)
    private String sopClassUID;
    @Column(name="inst_no")
    private Integer instanceNumber;
    @Basic(optional=false)
    @Column(name="content_date")
    private String contentDate;
    @Basic(optional=false)
    @Column(name="content_time")
    private String contentTime;
    @Basic(optional=false)
    @Column(name="sr_complete")
    private String completionFlag;
    @Basic(optional=false)
    @Column(name="sr_verified")
    private String verificationFlag;
    @Basic(optional=false)
    @Column(name="inst_custom1")
    private String instanceCustomAttribute1;
    @Basic(optional=false)
    @Column(name="inst_custom2")
    private String instanceCustomAttribute2;
    @Basic(optional=false)
    @Column(name="inst_custom3")
    private String instanceCustomAttribute3;
    @Column(name="num_frames")
    private Integer numberOfFrames;
    @Column(name="retrieve_aets")
    private String retrieveAETs;
    @Column(name="ext_retrieve_aet")
    private String externalRetrieveAET;
    @Basic(optional=false)
    @Column(name="availability")
    private Availability availability;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true, optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="dicomattrs_fk")
    private AttributesBlob attributesBlob;
    @ManyToOne
    @JoinColumn(name="srcode_fk")
    private CodeEntity conceptNameCode;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="instance_fk")
    private Collection<InstanceRequestAttributes> requestAttributes;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="instance_fk")
    private Collection<VerifyingObserver> verifyingObservers;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="instance_fk")
    private Collection<ContentItem> contentItems;
    @OneToMany(mappedBy="instance")
    private Collection<Location> locations;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="series_fk")
    private Series series;

    public String toString() {
        return "Instance[pk=" + this.pk + ", uid=" + this.sopInstanceUID + ", class=" + this.sopClassUID + ", no=" + this.instanceNumber + "]";
    }

    @PrePersist
    public void onPrePersist() {
        Date now;
        this.createdTime = now = new Date();
        this.updatedTime = now;
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public long getPk() {
        return this.pk;
    }

    public void setPk(long pk) {
        this.pk = pk;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSopClassUID() {
        return this.sopClassUID;
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getContentDate() {
        return this.contentDate;
    }

    public String getContentTime() {
        return this.contentTime;
    }

    public String getCompletionFlag() {
        return this.completionFlag;
    }

    public String getVerificationFlag() {
        return this.verificationFlag;
    }

    public String getInstanceCustomAttribute1() {
        return this.instanceCustomAttribute1;
    }

    public String getInstanceCustomAttribute2() {
        return this.instanceCustomAttribute2;
    }

    public String getInstanceCustomAttribute3() {
        return this.instanceCustomAttribute3;
    }

    public String[] getRetrieveAETs() {
        return StringUtils.split((String)this.retrieveAETs, (char)'\\');
    }

    public String getRawRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setRetrieveAETs(String ... retrieveAETs) {
        this.retrieveAETs = StringUtils.concat((String[])retrieveAETs, (char)'\\');
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public String getEncodedRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setEncodedRetrieveAETs(String retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public CodeEntity getConceptNameCode() {
        return this.conceptNameCode;
    }

    public void setConceptNameCode(CodeEntity conceptNameCode) {
        this.conceptNameCode = conceptNameCode;
    }

    public Collection<InstanceRequestAttributes> getRequestAttributes() {
        if (this.requestAttributes == null) {
            this.requestAttributes = new ArrayList<InstanceRequestAttributes>();
        }
        return this.requestAttributes;
    }

    public Collection<VerifyingObserver> getVerifyingObservers() {
        if (this.verifyingObservers == null) {
            this.verifyingObservers = new ArrayList<VerifyingObserver>();
        }
        return this.verifyingObservers;
    }

    public Collection<ContentItem> getContentItems() {
        if (this.contentItems == null) {
            this.contentItems = new ArrayList<ContentItem>();
        }
        return this.contentItems;
    }

    public Collection<Location> getLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList<Location>();
        }
        return this.locations;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.series = series;
    }

    public Attributes getAttributes() throws BlobCorruptedException {
        return this.attributesBlob.getAttributes();
    }

    public void setAttributes(Attributes attrs, AttributeFilter filter, boolean withOriginalAttributesSequence, FuzzyStr fuzzyStr) {
        this.sopInstanceUID = attrs.getString(524312);
        this.sopClassUID = attrs.getString(524310);
        this.instanceNumber = this.getInt(attrs, 2097171, null);
        this.numberOfFrames = attrs.contains(2621456) ? this.getInt(attrs, 0x280008, "1") : Integer.valueOf(0);
        Date dt = attrs.getDate(2251950138064947L);
        if (dt != null) {
            this.contentDate = DateUtils.formatDA(null, (Date)dt);
            this.contentTime = attrs.containsValue(524339) ? DateUtils.formatTM(null, (Date)dt) : "*";
        } else {
            this.contentDate = "*";
            this.contentTime = "*";
        }
        this.completionFlag = attrs.getString(4236433, "*").toUpperCase();
        this.verificationFlag = attrs.getString(4236435, "*").toUpperCase();
        this.instanceCustomAttribute1 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute1(), (String)"*");
        this.instanceCustomAttribute2 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute2(), (String)"*");
        this.instanceCustomAttribute3 = AttributeFilter.selectStringValue((Attributes)attrs, (ValueSelector)filter.getCustomAttribute3(), (String)"*");
        Attributes blobAttrs = new Attributes(attrs, filter.getSelection(withOriginalAttributesSequence));
        if (this.attributesBlob == null) {
            this.attributesBlob = new AttributesBlob(blobAttrs);
        } else {
            this.attributesBlob.setAttributes(blobAttrs);
        }
        this.updatedTime = new Date();
    }

    private Integer getInt(Attributes attrs, int tag, String defVal) {
        String val = attrs.getString(tag, defVal);
        if (val != null) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

