/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.dimse.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.QIDO;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{ExternalAET}")
@InvokeValidate(type=QueryRS.class)
public class QueryRS {
    private static final Logger LOG = LoggerFactory.getLogger(QueryRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="ExternalAET")
    private String externalAET;
    @QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;
    @QueryParam(value="priority")
    @Pattern(regexp="0|1|2")
    private @Pattern(regexp="0|1|2") String priority;
    @QueryParam(value="SplitStudyDateRange")
    @ValidValueOf(type=Duration.class)
    private String splitStudyDateRange;
    @Inject
    private CFindSCU findSCU;
    private Association as;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @GET
    @NoCache
    @Path(value="/patients")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForPatientsJSON(@Suspended AsyncResponse ar) {
        this.search(ar, Level.PATIENT, false, null, null, QIDO.PATIENT, false);
    }

    @GET
    @NoCache
    @Path(value="/studies")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForStudiesJSON(@Suspended AsyncResponse ar) {
        this.search(ar, Level.STUDY, false, null, null, QIDO.STUDY, false);
    }

    @GET
    @NoCache
    @Path(value="/series")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForSeries(@Suspended AsyncResponse ar) {
        this.search(ar, Level.SERIES, true, null, null, QIDO.STUDY_SERIES, false);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/series")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForSeriesOfStudyJSON(@Suspended AsyncResponse ar, @PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        this.search(ar, Level.SERIES, false, studyInstanceUID, null, QIDO.SERIES, false);
    }

    @GET
    @NoCache
    @Path(value="/instances")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForInstancesJSON(@Suspended AsyncResponse ar) {
        this.search(ar, Level.IMAGE, true, null, null, QIDO.STUDY_SERIES_INSTANCE, false);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/instances")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForInstancesOfStudyJSON(@Suspended AsyncResponse ar, @PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        this.search(ar, Level.IMAGE, true, studyInstanceUID, null, QIDO.SERIES_INSTANCE, false);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForInstancesOfSeriesJSON(@Suspended AsyncResponse ar, @PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID) {
        this.search(ar, Level.IMAGE, false, studyInstanceUID, seriesInstanceUID, QIDO.INSTANCE, false);
    }

    @GET
    @NoCache
    @Path(value="/mwlitems")
    @Produces(value={"application/dicom+json,application/json"})
    public void searchForSPSJSON(@Suspended AsyncResponse ar) {
        this.search(ar, Level.MWL, false, null, null, QIDO.MWL, false);
    }

    @GET
    @NoCache
    @Path(value="/mwlitems/count")
    @Produces(value={"application/json"})
    public void countSPS(@Suspended AsyncResponse ar) {
        this.search(ar, Level.MWL, false, null, null, QIDO.MWL, true);
    }

    @GET
    @NoCache
    @Path(value="/patients/count")
    @Produces(value={"application/json"})
    public void countPatients(@Suspended AsyncResponse ar) {
        this.search(ar, Level.PATIENT, false, null, null, QIDO.PATIENT, true);
    }

    @GET
    @NoCache
    @Path(value="/studies/count")
    @Produces(value={"application/json"})
    public void countStudies(@Suspended AsyncResponse ar) {
        this.search(ar, Level.STUDY, false, null, null, QIDO.STUDY, true);
    }

    @GET
    @NoCache
    @Path(value="/series/count")
    @Produces(value={"application/json"})
    public void countSeries(@Suspended AsyncResponse ar) {
        this.search(ar, Level.SERIES, true, null, null, QIDO.STUDY_SERIES, true);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/series/count")
    @Produces(value={"application/json"})
    public void countSeriesOfStudy(@Suspended AsyncResponse ar, @PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        this.search(ar, Level.SERIES, false, studyInstanceUID, null, QIDO.SERIES, true);
    }

    @GET
    @NoCache
    @Path(value="/instances/count")
    @Produces(value={"application/json"})
    public void countInstances(@Suspended AsyncResponse ar) {
        this.search(ar, Level.IMAGE, true, null, null, QIDO.STUDY_SERIES_INSTANCE, true);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/instances/count")
    @Produces(value={"application/json"})
    public void countInstancesOfStudy(@Suspended AsyncResponse ar, @PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        this.search(ar, Level.IMAGE, true, studyInstanceUID, null, QIDO.SERIES_INSTANCE, true);
    }

    @GET
    @NoCache
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/count")
    @Produces(value={"application/json"})
    public void countInstancesOfSeries(@Suspended AsyncResponse ar, @PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID) {
        this.search(ar, Level.IMAGE, false, studyInstanceUID, seriesInstanceUID, QIDO.INSTANCE, true);
    }

    private int offset() {
        return QueryRS.parseInt(this.offset, 0);
    }

    private int limit() {
        return QueryRS.parseInt(this.limit, 0);
    }

    private int priority() {
        return QueryRS.parseInt(this.priority, 0);
    }

    private static int parseInt(String s, int defval) {
        return s != null ? Integer.parseInt(s) : defval;
    }

    private Duration splitStudyDateRange() {
        return this.splitStudyDateRange != null ? Duration.valueOf((String)this.splitStudyDateRange) : null;
    }

    private void search(AsyncResponse ar, Level level, boolean relational, String studyInstanceUID, String seriesInstanceUID, QIDO qido, boolean count) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity localAE = arcAE.getApplicationEntity();
        try {
            this.aeCache.findApplicationEntity(this.externalAET);
            QueryAttributes queryAttributes = new QueryAttributes(this.uriInfo, null);
            Attributes keys = queryAttributes.getQueryKeys();
            if (!count) {
                qido.addReturnTags(queryAttributes);
                if (queryAttributes.isIncludeAll()) {
                    ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
                    switch (level) {
                        case MWL: {
                            queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.MWL).getSelection(false));
                            queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.Patient).getSelection(false));
                            break;
                        }
                        case IMAGE: {
                            queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.Instance).getSelection(false));
                            break;
                        }
                        case SERIES: {
                            queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.Series).getSelection(false));
                            break;
                        }
                        case STUDY: {
                            queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.Study).getSelection(false));
                        }
                        case PATIENT: {
                            queryAttributes.addReturnTags(arcdev.getAttributeFilter(Entity.Patient).getSelection(false));
                        }
                    }
                    keys.remove(524801);
                }
            }
            if (level != Level.MWL) {
                keys.setString(524370, VR.CS, level.name());
            }
            if (studyInstanceUID != null) {
                keys.setString(0x20000D, VR.UI, studyInstanceUID);
            }
            if (seriesInstanceUID != null) {
                keys.setString(0x20000E, VR.UI, seriesInstanceUID);
            }
            EnumSet<QueryOption> queryOptions = EnumSet.of(QueryOption.DATETIME);
            if (Boolean.parseBoolean(this.fuzzymatching)) {
                queryOptions.add(QueryOption.FUZZY);
            }
            if (relational) {
                queryOptions.add(QueryOption.RELATIONAL);
            }
            ar.register(throwable -> {
                if (this.as != null) {
                    try {
                        this.as.release();
                    }
                    catch (IOException e) {
                        LOG.info("{}: Failed to release association:\\n", (Object)this.as, (Object)e);
                    }
                }
            });
            this.as = this.findSCU.openAssociation(localAE, this.externalAET, level.cuid, queryOptions);
            DimseRSP dimseRSP = this.findSCU.query(this.as, this.priority(), this.findSCU.coerceCFindRQ(this.as, keys), !count && this.limit != null ? this.offset() + this.limit() : 0, 1, level != Level.MWL ? this.splitStudyDateRange() : null);
            dimseRSP.next();
            ar.resume((Object)(count ? this.countResponse(dimseRSP) : this.responseBuilder(dimseRSP, localAE)).build());
        }
        catch (IllegalStateException | ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (IOException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.BAD_GATEWAY));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response.ResponseBuilder responseBuilder(DimseRSP dimseRSP, ApplicationEntity localAE) {
        int status = dimseRSP.getCommand().getInt(2304, -1);
        switch (status) {
            case 0: {
                return Response.noContent();
            }
            case 65280: 
            case 65281: {
                return Response.ok((Object)this.writeJSON(dimseRSP, localAE));
            }
        }
        return this.warning(this.warning(status));
    }

    private Response.ResponseBuilder countResponse(DimseRSP dimseRSP) {
        int count = 0;
        try {
            while (dimseRSP.next()) {
                ++count;
            }
        }
        catch (Exception e) {
            return this.warning(e.getMessage());
        }
        int status = dimseRSP.getCommand().getInt(2304, -1);
        return status == 0 ? Response.ok((Object)("{\"count\":" + count + "}")) : this.warning(this.warning(status));
    }

    private Response.ResponseBuilder warning(String warning) {
        LOG.warn("Response Bad Gateway caused by {}", (Object)warning);
        return Response.status((Response.Status)Response.Status.BAD_GATEWAY).header("Warning", (Object)warning);
    }

    private String warning(int status) {
        switch (status) {
            case 42752: {
                return "A700: Refused: Out of Resources";
            }
            case 43264: {
                return "A900: Identifier does not match SOP Class";
            }
        }
        return TagUtils.shortToHexString((int)status) + ((status & 0xF000) == 49152 ? ": Unable to Process" : ": Unexpected status code");
    }

    private Object writeJSON(DimseRSP dimseRSP, ApplicationEntity localAE) {
        return out -> {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JSONWriter writer = ((ArchiveAEExtension)localAE.getAEExtensionNotNull(ArchiveAEExtension.class)).encodeAsJSONNumber(new JSONWriter(gen));
            gen.writeStartArray();
            int skip = this.offset();
            int remaining = this.limit();
            try {
                Attributes dataset = dimseRSP.getDataset();
                dimseRSP.next();
                do {
                    if (skip > 0) {
                        --skip;
                    } else {
                        writer.write(this.findSCU.coerceCFindRSP(this.as, dataset));
                        if (this.limit != null && --remaining == 0) break;
                    }
                    dataset = dimseRSP.getDataset();
                } while (dimseRSP.next());
            }
            catch (Exception e) {
                LOG.warn("Failed to read next C-FIND RSP from {}:\\n", (Object)this.externalAET, (Object)e);
            }
            gen.writeEnd();
            gen.flush();
        };
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private static enum Level {
        PATIENT("1.2.840.10008.5.1.4.1.2.1.1"),
        STUDY("1.2.840.10008.5.1.4.1.2.2.1"),
        SERIES("1.2.840.10008.5.1.4.1.2.2.1"),
        IMAGE("1.2.840.10008.5.1.4.1.2.2.1"),
        MWL("1.2.840.10008.5.1.4.31");

        final String cuid;

        private Level(String cuid) {
            this.cuid = cuid;
        }
    }
}

