/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Properties;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ApplicationEntityCache;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.DeviceCache;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.conf.api.WebApplicationCache;
import org.dcm4che3.conf.api.hl7.HL7ApplicationCache;
import org.dcm4che3.conf.api.hl7.HL7Configuration;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.conf.ldap.LdapDicomConfiguration;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.audit.LdapAuditLoggerConfiguration;
import org.dcm4che3.conf.ldap.audit.LdapAuditRecordRepositoryConfiguration;
import org.dcm4che3.conf.ldap.hl7.LdapHL7Configuration;
import org.dcm4che3.conf.ldap.hl7.LdapHL7ConfigurationExtension;
import org.dcm4che3.conf.ldap.imageio.LdapImageReaderConfiguration;
import org.dcm4che3.conf.ldap.imageio.LdapImageWriterConfiguration;
import org.dcm4chee.arc.conf.ldap.LdapArchiveConfiguration;
import org.dcm4chee.arc.conf.ldap.LdapArchiveHL7Configuration;
import org.dcm4chee.arc.conf.ui.ldap.LdapArchiveUIConfiguration;

@ApplicationScoped
public class LdapArchiveConfigurationFactory {
    private static final String LDAP_PROPERTIES = "ldap.properties";
    private static final String JBOSS_SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String APP_NAME_PROPERTY = "org.dcm4chee.arc.AppName";
    private static final String DEF_APP_NAME = "dcm4chee-arc";
    @Inject
    private Instance<LdapDicomConfigurationExtension> configExts;
    @Produces
    @ApplicationScoped
    private static LdapAuditLoggerConfiguration ldapAuditLoggerConfiguration = new LdapAuditLoggerConfiguration();
    @Produces
    @ApplicationScoped
    private static LdapAuditRecordRepositoryConfiguration ldapAuditRecordRepositoryConfiguration = new LdapAuditRecordRepositoryConfiguration();
    @Produces
    @ApplicationScoped
    private static LdapImageReaderConfiguration ldapImageReaderConfiguration = new LdapImageReaderConfiguration();
    @Produces
    @ApplicationScoped
    private static LdapImageWriterConfiguration ldapImageWriterConfiguration = new LdapImageWriterConfiguration();

    @Produces
    @ApplicationScoped
    private static LdapHL7Configuration newLdapHL7Configuration() {
        LdapHL7Configuration hl7Config = new LdapHL7Configuration();
        hl7Config.addHL7ConfigurationExtension((LdapHL7ConfigurationExtension)new LdapArchiveHL7Configuration());
        return hl7Config;
    }

    public static DicomConfiguration newLdapDicomConfiguration(URL envURL) throws ConfigurationException {
        return LdapArchiveConfigurationFactory.newLdapDicomConfiguration(envURL, Stream.of(new LdapDicomConfigurationExtension[]{ldapAuditLoggerConfiguration, ldapAuditRecordRepositoryConfiguration, ldapImageReaderConfiguration, ldapImageWriterConfiguration, new LdapArchiveConfiguration(), new LdapArchiveUIConfiguration(), LdapArchiveConfigurationFactory.newLdapHL7Configuration()}));
    }

    private static DicomConfiguration newLdapDicomConfiguration(URL envURL, Stream<LdapDicomConfigurationExtension> configExts) throws ConfigurationException {
        try {
            return LdapArchiveConfigurationFactory.newLdapDicomConfiguration(LdapArchiveConfigurationFactory.loadProperties(envURL), configExts);
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load LDAP properties from " + envURL, (Throwable)e);
        }
    }

    private static LdapDicomConfiguration newLdapDicomConfiguration(Hashtable<?, ?> env, Stream<LdapDicomConfigurationExtension> configExts) throws ConfigurationException {
        LdapDicomConfiguration config = new LdapDicomConfiguration(env);
        configExts.forEach(arg_0 -> ((LdapDicomConfiguration)config).addDicomConfigurationExtension(arg_0));
        return config;
    }

    @Produces
    @ApplicationScoped
    public DicomConfiguration newLdapDicomConfiguration() throws ConfigurationException {
        return LdapArchiveConfigurationFactory.newLdapDicomConfiguration(LdapArchiveConfigurationFactory.envURL(), (Stream<LdapDicomConfigurationExtension>)this.configExts.stream());
    }

    @Produces
    @ApplicationScoped
    public IApplicationEntityCache newApplicationEntityCache(DicomConfiguration conf) {
        return new ApplicationEntityCache(conf);
    }

    @Produces
    @ApplicationScoped
    public IWebApplicationCache newWebApplicationCache(DicomConfiguration conf) {
        return new WebApplicationCache(conf);
    }

    @Produces
    @ApplicationScoped
    public IDeviceCache newDeviceCache(DicomConfiguration conf) {
        return new DeviceCache(conf);
    }

    @Produces
    @ApplicationScoped
    public IHL7ApplicationCache newHL7ApplicationCache(DicomConfiguration conf) {
        return new HL7ApplicationCache((HL7Configuration)conf.getDicomConfigurationExtension(HL7Configuration.class));
    }

    private static Properties loadProperties(URL url) throws IOException {
        Properties p = new Properties();
        try (InputStream stream = url.openStream();){
            p.load(stream);
        }
        return p;
    }

    private static URL envURL() {
        String appName = System.getProperty(APP_NAME_PROPERTY, DEF_APP_NAME);
        String configDir = System.getProperty(JBOSS_SERVER_CONFIG_DIR);
        Path path = Paths.get(configDir, appName, LDAP_PROPERTIES);
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }
}

