/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Arrays;
import java.util.Calendar;
import java.util.function.Predicate;
import org.dcm4che3.data.Attributes;
import org.dcm4chee.arc.conf.Conditions;
import org.dcm4chee.arc.conf.Duration;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.ExportReoccurredInstances;
import org.dcm4chee.arc.conf.ScheduleExpression;

public class ExportRule {
    public static final ExportRule[] EMPTY = new ExportRule[0];
    private String commonName;
    private ScheduleExpression[] schedules = new ScheduleExpression[0];
    private Conditions conditions = new Conditions(new String[0]);
    private String exporterDeviceName;
    private String[] exporterIDs = new String[0];
    private Entity entity;
    private Duration exportDelay;
    private boolean exportPreviousEntity;
    private ExportReoccurredInstances exportReoccurredInstances = ExportReoccurredInstances.REPLACE;

    public ExportRule() {
    }

    public ExportRule(String commonName) {
        this.setCommonName(commonName);
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public ScheduleExpression[] getSchedules() {
        return this.schedules;
    }

    public void setSchedules(ScheduleExpression ... schedules) {
        this.schedules = schedules;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public String getExporterDeviceName() {
        return this.exporterDeviceName;
    }

    public void setExporterDeviceName(String exporterDeviceName) {
        this.exporterDeviceName = exporterDeviceName;
    }

    public String[] getExporterIDs() {
        return this.exporterIDs;
    }

    public void setExporterIDs(String ... exporterIDs) {
        this.exporterIDs = exporterIDs;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        switch (entity) {
            case Study: 
            case Series: 
            case Instance: {
                this.entity = entity;
                break;
            }
            default: {
                throw new IllegalArgumentException("entity: " + entity);
            }
        }
    }

    public Duration getExportDelay() {
        return this.exportDelay;
    }

    public void setExportDelay(Duration exportDelay) {
        this.exportDelay = exportDelay;
    }

    public boolean isExportPreviousEntity() {
        return this.exportPreviousEntity;
    }

    public void setExportPreviousEntity(boolean exportPreviousEntity) {
        this.exportPreviousEntity = exportPreviousEntity;
    }

    public ExportReoccurredInstances getExportReoccurredInstances() {
        return this.exportReoccurredInstances;
    }

    public void setExportReoccurredInstances(ExportReoccurredInstances exportReoccurredInstances) {
        this.exportReoccurredInstances = exportReoccurredInstances;
    }

    public boolean match(Predicate<ExportReoccurredInstances> predicate, Calendar now, String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        return predicate.test(this.exportReoccurredInstances) && ScheduleExpression.emptyOrAnyContains(now, this.schedules) && this.conditions.match(sendingHost, sendingAET, receivingHost, receivingAET, attrs);
    }

    public String toString() {
        return "ExportRule{cn=" + this.commonName + ", conditions=" + this.conditions + ", schedules=" + Arrays.toString(this.schedules) + ", exporterDeviceName=" + this.exporterDeviceName + ", exporterIDs=" + Arrays.toString(this.exporterIDs) + ", entity=" + this.entity + ", exporterDelay=" + this.exportDelay + ", exportPreviousEntity=" + this.exportPreviousEntity + ", exportReoccurredInstances=" + this.exportReoccurredInstances + "}";
    }
}

