/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;

public class Conditions {
    public static final String RECEIVING_APPLICATION_ENTITY_TITLE = "ReceivingApplicationEntityTitle";
    public static final String RECEIVING_HOSTNAME = "ReceivingHostname";
    public static final String SENDING_APPLICATION_ENTITY_TITLE = "SendingApplicationEntityTitle";
    public static final String SENDING_HOSTNAME = "SendingHostname";
    private final Map<String, Object> map = new TreeMap<String, Object>();

    public Conditions(String ... props) {
        for (String s : props) {
            int index = s.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("Condition in incorrect format : " + s);
            }
            String tagPath = s.substring(0, index);
            if ((tagPath.endsWith("]") || tagPath.endsWith("]!")) && Integer.parseInt(tagPath.substring(tagPath.indexOf("[") + 1, tagPath.indexOf("]"))) <= 0) {
                throw new IllegalArgumentException("Incorrect attribute value position in Conditions : " + s);
            }
            this.setCondition(tagPath, s.substring(index + 1));
        }
    }

    public void setReceivingAETitle(String value) {
        this.setCondition(RECEIVING_APPLICATION_ENTITY_TITLE, value);
    }

    public void setNotReceivingAETitle(String value) {
        this.setCondition("ReceivingApplicationEntityTitle!", value);
    }

    public void setReceivingHostname(String value) {
        this.setCondition(RECEIVING_HOSTNAME, value);
    }

    public void setNotReceivingHostname(String value) {
        this.setCondition("ReceivingHostname!", value);
    }

    public void setSendingAETitle(String value) {
        this.setCondition(SENDING_APPLICATION_ENTITY_TITLE, value);
    }

    public void setNotSendingAETitle(String value) {
        this.setCondition("SendingApplicationEntityTitle!", value);
    }

    public void setSendingHostname(String value) {
        this.setCondition(SENDING_HOSTNAME, value);
    }

    public void setNotSendingHostname(String value) {
        this.setCondition("SendingHostname!", value);
    }

    public void setCondition(String tagPath, String value) {
        this.map.put(tagPath, Conditions.toCodeMatcherOrPattern(value));
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean match(String sendingHost, String sendingAET, String receivingHost, String receivingAET, Attributes attrs) {
        block12: for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            String tagPath = entry.getKey();
            Object codeMatcherOrPattern = entry.getValue();
            boolean ne = tagPath.endsWith("!");
            if (ne) {
                tagPath = tagPath.substring(0, tagPath.length() - 1);
            }
            int valPos = 0;
            if (tagPath.endsWith("]")) {
                String[] tagPathWithValPos = StringUtils.split((String)tagPath, (char)'[');
                tagPath = tagPathWithValPos[0];
                valPos = Integer.parseInt(tagPathWithValPos[1].substring(0, tagPathWithValPos[1].length() - 1));
            }
            switch (tagPath) {
                case "ReceivingApplicationEntityTitle": {
                    if (!(ne ? receivingAET != null && Conditions.test(codeMatcherOrPattern, receivingAET) : receivingAET == null || !Conditions.test(codeMatcherOrPattern, receivingAET))) continue block12;
                    return false;
                }
                case "ReceivingHostname": {
                    if (!(ne ? receivingHost != null && Conditions.test(codeMatcherOrPattern, receivingHost) : receivingHost == null || !Conditions.test(codeMatcherOrPattern, receivingHost))) continue block12;
                    return false;
                }
                case "SendingApplicationEntityTitle": {
                    if (!(ne ? sendingAET != null && Conditions.test(codeMatcherOrPattern, sendingAET) : sendingAET == null || !Conditions.test(codeMatcherOrPattern, sendingAET))) continue block12;
                    return false;
                }
                case "SendingHostname": {
                    if (!(ne ? sendingHost != null && Conditions.test(codeMatcherOrPattern, sendingHost) : sendingHost == null || !Conditions.test(codeMatcherOrPattern, sendingHost))) continue block12;
                    return false;
                }
            }
            if (this.match(attrs, TagUtils.parseTagPath((String)tagPath), valPos, 0, codeMatcherOrPattern, ne)) continue;
            return false;
        }
        return true;
    }

    private boolean match(Attributes attrs, int[] tagPath, int valPos, int level, Object codeMatcherOrPattern, boolean ne) {
        block10: {
            block9: {
                if (level >= tagPath.length - 1) break block9;
                Sequence seq = attrs.getSequence(tagPath[level]);
                if (seq == null) break block10;
                for (Attributes item : seq) {
                    if (!this.match(item, tagPath, valPos, level + 1, codeMatcherOrPattern, false)) continue;
                    return !ne;
                }
                break block10;
            }
            if (codeMatcherOrPattern instanceof CodeMatcher) {
                if (((CodeMatcher)codeMatcherOrPattern).match(attrs.getNestedDataset(tagPath[level]))) {
                    return !ne;
                }
            } else {
                String[] ss = attrs.getStrings(tagPath[level]);
                if (ss != null && ss.length >= 1) {
                    if (valPos > 0) {
                        if (valPos > ss.length || ss[valPos - 1] != null && Conditions.test(codeMatcherOrPattern, ss[valPos - 1])) {
                            return !ne;
                        }
                    } else {
                        for (String s : ss) {
                            if (s == null || !Conditions.test(codeMatcherOrPattern, s)) continue;
                            return !ne;
                        }
                    }
                }
            }
        }
        return ne;
    }

    private static boolean test(Object predicateOrPattern, String s) {
        return predicateOrPattern instanceof Pattern ? ((Pattern)predicateOrPattern).matcher(s).matches() : ((Predicate)predicateOrPattern).test(s);
    }

    private static Object toCodeMatcherOrPattern(String value) {
        if (!value.isEmpty()) {
            try {
                switch (value.charAt(0)) {
                    case '(': {
                        return new CodeMatcher(value);
                    }
                    case '\u00a7': {
                        return ValuePredicate.valueOf(value.substring(1));
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Pattern.compile(value);
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Conditions)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    private static enum ValuePredicate implements Predicate<String>
    {
        PATIENT_ID_EST{
            final Pattern PATTERN = Pattern.compile("[1-6]\\d\\d(0[1-9]|1[0-2])(0[1-9]|[12]\\d|3[01])\\d\\d\\d\\d");

            @Override
            public boolean test(String s) {
                return this.PATTERN.matcher(s).matches() && this.verifyChecksum(s.toCharArray());
            }

            private boolean verifyChecksum(char[] chars) {
                int checksum = this.checksum(chars, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1);
                if (checksum == 10 && (checksum = this.checksum(chars, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3)) == 10) {
                    checksum = 0;
                }
                return chars[10] - 48 == checksum;
            }

            private int checksum(char[] chars, int ... weights) {
                int sum = 0;
                for (int i = 0; i < 10; ++i) {
                    sum += (chars[i] - 48) * weights[i];
                }
                return sum % 11;
            }
        };


        public String toString() {
            return "\u00a7" + this.name();
        }
    }

    private static class CodeMatcher {
        private final String value;
        private final Code[] codes;

        public CodeMatcher(String value) {
            String[] ss = StringUtils.split((String)value, (char)'|');
            this.codes = new Code[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                this.codes[i] = new Code(ss[i]);
            }
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public boolean match(Attributes item) {
            try {
                return item != null && this.match(new Code(item));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public boolean match(Code test) {
            for (Code code : this.codes) {
                if (!code.equalsIgnoreMeaning(test)) continue;
                return true;
            }
            return false;
        }
    }
}

