/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ups.rs;

import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.UIDUtils;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.rs.util.MediaTypeUtils;
import org.dcm4chee.arc.ups.UPSContext;
import org.dcm4chee.arc.ups.UPSService;
import org.dcm4chee.arc.ups.rs.DicomJSONOutput;
import org.dcm4chee.arc.ups.rs.DicomXMLOutput;
import org.dcm4chee.arc.ups.rs.InputType;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=UpsRS.class)
public class UpsRS {
    private static final Logger LOG = LoggerFactory.getLogger(UpsRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    private static final int[] EXCLUDE_FROM_REPLACEMENT = new int[]{524310, 524312, 0x404010, 7606274, 7606806};
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="accept")
    private List<String> accept;
    @QueryParam(value="charset")
    private String charset;
    @QueryParam(value="deletionlock")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String deletionlock;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpHeaders headers;
    @Inject
    private Device device;
    @Inject
    private UPSService service;
    private Attributes matchKeys;

    @POST
    @Path(value="/workitems")
    public Response createUPS(@QueryParam(value="workitem") String iuid, @QueryParam(value="template") @Pattern(regexp="true|false") @Pattern(regexp="true|false") String template, InputStream in) {
        InputType inputType;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((inputType = InputType.valueOf(this.headers.getMediaType())) == null) {
            return this.notAcceptable();
        }
        return this.createUPS(iuid, Boolean.parseBoolean(template), inputType.parse(in));
    }

    @POST
    @Path(value="/workitems/{workitem}")
    public Response updateUPS(@PathParam(value="workitem") String iuid, InputStream in) {
        InputType inputType;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((inputType = InputType.valueOf(this.headers.getMediaType())) == null) {
            return this.notAcceptable();
        }
        return this.updateUPS(iuid, inputType.parse(in));
    }

    @PUT
    @Path(value="/workitems/{workitem}/state/{requester}")
    public Response changeUPSState(@PathParam(value="workitem") String iuid, @PathParam(value="requester") String requester, InputStream in) {
        InputType inputType;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        if ((inputType = InputType.valueOf(this.headers.getMediaType())) == null) {
            return this.notAcceptable();
        }
        return this.changeUPSState(iuid, requester, inputType.parse(in));
    }

    @GET
    @NoCache
    @Path(value="/workitems/{workitem}")
    public Response retrieveUPS(@PathParam(value="workitem") String iuid) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        ResponseMediaType responseMediaType = this.getResponseMediaType();
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE);
        ctx.setUPSInstanceUID(iuid);
        try {
            this.service.findUPS(ctx);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::retrieveFailed, e);
        }
        return Response.ok((Object)responseMediaType.entity(ctx), (MediaType)responseMediaType.type).build();
    }

    @POST
    @Path(value="/workitems/{workitem}/cancelrequest/{requester}")
    public Response requestUPSCancel(@PathParam(value="workitem") String iuid, @PathParam(value="requester") String requester) {
        return this.requestUPSCancel(iuid, requester, new Attributes());
    }

    @POST
    @Path(value="/workitems/{workitem}/cancelrequest/{requester}")
    @Consumes(value={"application/dicom+json", "application/dicom+xml"})
    public Response requestUPSCancel(@PathParam(value="workitem") String iuid, @PathParam(value="requester") String requester, InputStream in) {
        InputType inputType = InputType.valueOf(this.headers.getMediaType());
        if (inputType == null) {
            return this.notAcceptable();
        }
        return this.requestUPSCancel(iuid, requester, inputType.parse(in));
    }

    @POST
    @Path(value="/workitems/{workitem}/subscribers/{SubscriberAET}")
    public Response subscribe(@PathParam(value="workitem") String iuid, @PathParam(value="SubscriberAET") String subscriber) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        ctx.setSubscriberAET(subscriber);
        ctx.setDeletionLock(Boolean.parseBoolean(this.deletionlock));
        ctx.setAttributes(this.matchKeys);
        try {
            this.service.createSubscription(ctx);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::subscriptionFailed, e);
        }
        return Response.created((URI)this.websocketOf(ctx)).build();
    }

    @DELETE
    @Path(value="/workitems/{workitem}/subscribers/{SubscriberAET}")
    public Response unsubscribe(@PathParam(value="workitem") String iuid, @PathParam(value="SubscriberAET") String subscriber) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        ctx.setSubscriberAET(subscriber);
        try {
            return this.service.deleteSubscription(ctx) > 0 ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).header("Warning", (Object)"The target Subscription was not found.").build();
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::internalServerError, e);
        }
    }

    @POST
    @Path(value="/workitems/{workitem}/subscribers/{SubscriberAET}/suspend")
    public Response suspendSubscription(@PathParam(value="workitem") String iuid, @PathParam(value="SubscriberAET") String subscriber) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        ctx.setSubscriberAET(subscriber);
        try {
            return this.service.suspendSubscription(ctx) > 0 ? Response.ok().build() : Response.status((Response.Status)Response.Status.NOT_FOUND).header("Warning", (Object)"The target Subscription was not found.").build();
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::internalServerError, e);
        }
    }

    @POST
    @Path(value="/workitems/{workitem}/reschedule")
    public Response rescheduleWorkitem(@PathParam(value="workitem") String iuid, @QueryParam(value="newWorkitem") String newIUID, @QueryParam(value="upsScheduledTime") String upsScheduledTime) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        try {
            this.service.findUPS(ctx);
            return this.createUPS(newIUID, false, this.replacement(ctx.getAttributes(), upsScheduledTime));
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::retrieveFailed, e);
        }
    }

    private Attributes replacement(Attributes upsAttrs, String upsScheduledTime) {
        Attributes replacement = new Attributes(upsAttrs.size());
        replacement.addNotSelected(upsAttrs, EXCLUDE_FROM_REPLACEMENT);
        replacement.setDate(0x404005, VR.DT, new Date[]{this.scheduledTime(upsScheduledTime)});
        replacement.setString(7606272, VR.CS, "SCHEDULED");
        replacement.ensureSequence(7606820, 1).add(UpsRS.refSOP(upsAttrs.getString(524310), upsAttrs.getString(524312)));
        return replacement;
    }

    private Date scheduledTime(String upsScheduledTime) {
        if (upsScheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(upsScheduledTime);
            }
            catch (Exception e) {
                LOG.info("Can not parse upsScheduledTime[={}]: {}", (Object)upsScheduledTime, (Object)e.getMessage());
            }
        }
        return new Date();
    }

    private static Attributes refSOP(String cuid, String iuid) {
        Attributes item = new Attributes(2);
        item.setString(528720, VR.UI, cuid);
        item.setString(528725, VR.UI, iuid);
        return item;
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
        if (this.uriInfo.getPath().contains("1.2.840.10008.5.1.4.34.5.1") && "POST".equals(this.request.getMethod()) && !this.uriInfo.getPath().endsWith("/suspend")) {
            this.matchKeys = new QueryAttributes(this.uriInfo, null).getQueryKeys();
        }
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.UPS_RS)).findFirst().orElseThrow(() -> new WebApplicationException("No Web Application with UPS_RS service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND));
    }

    private Response createUPS(String iuid, boolean template, Attributes attrs) {
        if (template && attrs.containsValue(0x404005)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Warning", (Object)this.toWarning("UPS Template workitem creation shall not contain Scheduled Procedure Step Start DateTime")).build();
        }
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid == null ? UIDUtils.createUID() : iuid);
        ctx.setAttributes(attrs);
        ctx.setTemplate(template);
        try {
            this.service.createUPS(ctx);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::createFailed, e);
        }
        return Response.created((URI)this.locationOf(ctx)).build();
    }

    private Response updateUPS(String iuid, Attributes attrs) {
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        ctx.setAttributes(attrs);
        try {
            this.service.updateUPS(ctx);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::updateFailed, e);
        }
        return Response.ok().build();
    }

    private Response changeUPSState(String iuid, String requester, Attributes attrs) {
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        ctx.setRequesterAET(requester);
        ctx.setAttributes(attrs);
        try {
            this.service.changeUPSState(ctx);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::changeStateFailed, e);
        }
        Response.ResponseBuilder ok = Response.ok();
        switch (ctx.getStatus()) {
            case 45828: {
                ok.header("Warning", (Object)this.toWarning("The UPS is already in the requested state of CANCELED."));
                break;
            }
            case 45830: {
                ok.header("Warning", (Object)this.toWarning("The UPS is already in the requested state of COMPLETED."));
            }
        }
        return ok.build();
    }

    private Response requestUPSCancel(String iuid, String requester, Attributes attrs) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        UPSContext ctx = this.service.newUPSContext(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), this.getArchiveAE());
        ctx.setUPSInstanceUID(iuid);
        ctx.setRequesterAET(requester);
        ctx.setAttributes(attrs);
        try {
            this.service.requestUPSCancel(ctx);
        }
        catch (DicomServiceException e) {
            return this.errResponse(UpsRS::requestCancelFailed, e);
        }
        Response.ResponseBuilder accepted = Response.accepted();
        switch (ctx.getStatus()) {
            case 45828: {
                accepted.header("Warning", (Object)this.toWarning("The UPS is already in the requested state of CANCELED."));
            }
        }
        return accepted.build();
    }

    private Response notAcceptable() {
        LOG.info("Response Status : Not Acceptable. Content Type in request : {}", (Object)this.headers.getMediaType());
        return Response.notAcceptable((List)Variant.mediaTypes((MediaType[])new MediaType[]{MediaTypes.APPLICATION_DICOM_JSON_TYPE, MediaTypes.APPLICATION_DICOM_XML_TYPE}).build()).build();
    }

    private Response errResponse(IntFunction<Response.Status> httpStatusOf, DicomServiceException e) {
        return Response.status((Response.Status)httpStatusOf.apply(e.getStatus())).header("Warning", (Object)this.toWarning(e.getMessage())).build();
    }

    private String toWarning(String message) {
        return "299 " + this.baseURL() + ": " + message;
    }

    private String baseURL() {
        StringBuffer sb = this.request.getRequestURL();
        sb.setLength(sb.lastIndexOf("/workitems") + 10);
        return sb.toString();
    }

    private static Response.Status createFailed(int status) {
        switch (status) {
            case 273: {
                return Response.Status.CONFLICT;
            }
            case 261: 
            case 262: 
            case 288: 
            case 289: 
            case 49929: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static Response.Status updateFailed(int status) {
        switch (status) {
            case 49927: {
                return Response.Status.NOT_FOUND;
            }
            case 49920: 
            case 49921: 
            case 49936: {
                return Response.Status.CONFLICT;
            }
            case 261: 
            case 262: 
            case 288: 
            case 289: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static Response.Status changeStateFailed(int status) {
        switch (status) {
            case 49927: {
                return Response.Status.NOT_FOUND;
            }
            case 49920: 
            case 49921: 
            case 49922: 
            case 49923: 
            case 49924: 
            case 49936: {
                return Response.Status.CONFLICT;
            }
            case 277: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static Response.Status requestCancelFailed(int status) {
        switch (status) {
            case 49927: {
                return Response.Status.NOT_FOUND;
            }
            case 49937: 
            case 49938: 
            case 49939: {
                return Response.Status.CONFLICT;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static Response.Status subscriptionFailed(int status) {
        switch (status) {
            case 49927: 
            case 49928: {
                return Response.Status.NOT_FOUND;
            }
            case 49941: {
                return Response.Status.FORBIDDEN;
            }
            case 277: {
                return Response.Status.BAD_REQUEST;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static Response.Status internalServerError(int status) {
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static Response.Status retrieveFailed(int status) {
        switch (status) {
            case 49927: {
                return Response.Status.NOT_FOUND;
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private URI locationOf(UPSContext ctx) {
        return URI.create(this.request.getRequestURL().append('/').append(ctx.getUPSInstanceUID()).toString());
    }

    private URI websocketOf(UPSContext ctx) {
        StringBuffer sb = this.request.getRequestURL();
        sb.setLength(sb.indexOf("/rs/"));
        return URI.create("ws" + sb.append("/ws/subscribers/").append(ctx.getSubscriberAET()).substring(4));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        if (ae == null || !ae.isInstalled()) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return (ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class);
    }

    private ResponseMediaType getResponseMediaType() {
        return MediaTypeUtils.acceptableMediaTypesOf((HttpHeaders)this.headers, this.accept).stream().map(UpsRS::selectResponseMediaType).filter(Objects::nonNull).findFirst().orElseThrow(() -> new WebApplicationException(Response.Status.NOT_ACCEPTABLE));
    }

    private static ResponseMediaType selectResponseMediaType(MediaType acceptableMediaType) {
        return MediaTypes.APPLICATION_DICOM_JSON_TYPE.isCompatible(acceptableMediaType) ? ResponseMediaType.DICOM_JSON : (MediaTypes.APPLICATION_DICOM_XML_TYPE.isCompatible(acceptableMediaType) ? ResponseMediaType.DICOM_XML : null);
    }

    private static enum ResponseMediaType {
        DICOM_XML(MediaTypes.APPLICATION_DICOM_XML_TYPE, DicomXMLOutput::new){

            @Override
            Object entity(UPSContext ctx) {
                return new DicomXMLOutput(ctx);
            }
        }
        ,
        DICOM_JSON(MediaTypes.APPLICATION_DICOM_JSON_TYPE, DicomJSONOutput::new){

            @Override
            Object entity(UPSContext ctx) {
                return new DicomJSONOutput(ctx);
            }
        };

        final MediaType type;
        private final Function<UPSContext, Object> toEntity;

        private ResponseMediaType(MediaType type, Function<UPSContext, Object> toEntity) {
            this.type = type;
            this.toEntity = toEntity;
        }

        Object entity(UPSContext ctx) {
            return this.toEntity.apply(ctx);
        }
    }
}

