/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stow;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.delete.DeletionService;
import org.dcm4chee.arc.delete.StudyNotEmptyException;
import org.dcm4chee.arc.delete.StudyNotFoundException;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.rs.client.RSForward;
import org.dcm4chee.arc.storage.ReadContext;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.dcm4chee.arc.store.StoreContext;
import org.dcm4chee.arc.store.StoreService;
import org.dcm4chee.arc.store.StoreSession;
import org.dcm4chee.arc.stow.OutputType;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=ImportStorageRS.class)
public class ImportStorageRS {
    private static final Logger LOG = LoggerFactory.getLogger(ImportStorageRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private StorageFactory storageFactory;
    @Inject
    private StoreService service;
    @Inject
    private DeletionService deletionService;
    @Inject
    private RSForward rsForward;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @PathParam(value="AETitle")
    private String aet;
    @QueryParam(value="readPixelData")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String readPixelData;
    @QueryParam(value="updatePolicy")
    @Pattern(regexp="SUPPLEMENT|MERGE|OVERWRITE")
    @DefaultValue(value="OVERWRITE")
    private @Pattern(regexp="SUPPLEMENT|MERGE|OVERWRITE") String updatePolicy;
    @QueryParam(value="reasonForModification")
    @Pattern(regexp="COERCE|CORRECT")
    private @Pattern(regexp="COERCE|CORRECT") String reasonForModification;
    @QueryParam(value="sourceOfPreviousValues")
    private String sourceOfPreviousValues;
    @Context
    private HttpHeaders httpHeaders;
    private final Attributes response = new Attributes();
    private final Set<String> studyInstanceUIDs = new HashSet<String>();
    private Sequence sopSequence;
    private Sequence failedSOPSequence;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @POST
    @Path(value="/instances/storage/{StorageID}")
    @Consumes(value={"text/*"})
    public void importInstances(@PathParam(value="StorageID") String storageID, @Suspended AsyncResponse ar, InputStream in) {
        Output output = this.selectMediaType();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        Storage storage = this.storageFactory.getStorage(this.getStorageDesc(storageID));
        StoreSession session = this.service.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), ae, this.aet, null).withObjectStorageID(storageID);
        Attributes coerce = new QueryAttributes(this.uriInfo, null).getQueryKeys();
        Date now = this.reasonForModification != null && !coerce.isEmpty() ? new Date() : null;
        Attributes.UpdatePolicy updatePolicy = Attributes.UpdatePolicy.valueOf((String)this.updatePolicy);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            reader.lines().forEach(storagePath -> this.importInstanceOnStorage(storage, this.service.newStoreContext(session), coerce, updatePolicy, now, (String)storagePath));
        }
        catch (Exception e) {
            throw new WebApplicationException(ImportStorageRS.errResponseAsTextPlain(ImportStorageRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
        this.response.setString(528784, VR.UR, this.retrieveURL());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)this.status());
        ar.resume((Object)responseBuilder.entity(output.entity(this.response, ae)).header("Warning", (Object)this.response.getString(2306)).build());
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    @POST
    @Path(value="/studies/{study}/reimport")
    public void reimportStudy(@Suspended AsyncResponse ar, @PathParam(value="study") String studyUID) {
        Output output = this.selectMediaType();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            List locations = this.deletionService.reimportStudy(studyUID, HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), arcAE);
            Attributes coerce = new QueryAttributes(this.uriInfo, null).getQueryKeys();
            Date now = this.reasonForModification != null && !coerce.isEmpty() ? new Date() : null;
            Attributes.UpdatePolicy updatePolicy = Attributes.UpdatePolicy.valueOf((String)this.updatePolicy);
            for (Location location : locations) {
                if (location.getObjectType() == Location.ObjectType.METADATA) continue;
                Storage storage = this.storageFactory.getStorage(this.getStorageDesc(location.getStorageID()));
                StoreSession session = this.service.newStoreSession(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), ae, this.aet, null).withObjectStorageID(location.getStorageID());
                StoreContext ctx = this.service.newStoreContext(session);
                ctx.getLocations().add(location);
                this.importInstanceOnStorage(storage, ctx, coerce, updatePolicy, now, location.getStoragePath());
            }
            this.rsForward.forward(RSOperation.ReimportStudy, arcAE, null, this.request);
        }
        catch (StudyNotFoundException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
        catch (StudyNotEmptyException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.FORBIDDEN));
        }
        catch (Exception e) {
            throw new WebApplicationException(ImportStorageRS.errResponseAsTextPlain(ImportStorageRS.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
        this.response.setString(528784, VR.UR, this.retrieveURL());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)this.status());
        ar.resume((Object)responseBuilder.entity(output.entity(this.response, ae)).header("Warning", (Object)this.response.getString(2306)).build());
    }

    private void importInstanceOnStorage(Storage storage, StoreContext ctx, Attributes coerce, Attributes.UpdatePolicy updatePolicy, Date now, String storagePath) {
        ReadContext readContext = this.createReadContext(storage, storagePath);
        StoreSession session = ctx.getStoreSession();
        try {
            Attributes attrs = this.getAttributes(storage, session, readContext, ctx);
            if (!coerce.isEmpty()) {
                Attributes modified = new Attributes();
                attrs.update(updatePolicy, false, coerce, modified);
                if (!modified.isEmpty() && this.reasonForModification != null) {
                    attrs.addOriginalAttributes(this.sourceOfPreviousValues, now, this.reasonForModification, this.device.getDeviceName(), modified);
                }
            }
            this.service.importInstanceOnStorage(ctx, attrs, readContext);
            this.studyInstanceUIDs.add(ctx.getStudyInstanceUID());
            this.sopSequence().add(this.mkSOPRefWithRetrieveURL(ctx));
        }
        catch (DicomServiceException e) {
            LOG.info("{}: Failed to import instance on storage SopClassUID={}, StoragePath={}", new Object[]{session, UID.nameOf((String)ctx.getSopClassUID()), storagePath, e});
            this.response.setString(2306, VR.LO, e.getMessage());
            this.failedSOPSequence().add(this.mkSOPRefWithFailureReason(ctx, e));
        }
        catch (IOException e) {
            LOG.info("{}: Failed to import instance on storage SopClassUID={}, StoragePath={}", new Object[]{session, UID.nameOf((String)ctx.getSopClassUID()), storagePath, e});
            this.response.setString(2306, VR.LO, e.getMessage());
        }
    }

    private Attributes getAttributes(Storage storage, StoreSession session, ReadContext readContext, StoreContext ctx) throws IOException {
        try (DicomInputStream dis = new DicomInputStream(storage.openInputStream(readContext));){
            dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            dis.setBulkDataDescriptor(session.getArchiveAEExtension().getBulkDataDescriptor());
            dis.setURI("java:iis");
            dis.readFileMetaInformation();
            ctx.setReceiveTransferSyntax(dis.getTransferSyntax());
            Attributes attributes = Boolean.parseBoolean(this.readPixelData) || storage.getStorageDescriptor().getDigestAlgorithm() != null ? dis.readDataset() : dis.readDatasetUntilPixelData();
            return attributes;
        }
    }

    private Output selectMediaType() {
        return this.httpHeaders.getAcceptableMediaTypes().stream().map(Output::valueOf).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            LOG.warn("Response Status : Not Acceptable. Accept Media Type(s) in request : \n{}", (Object)this.httpHeaders.getAcceptableMediaTypes().stream().map(MediaType::toString).collect(Collectors.joining("\n")));
            return new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])new MediaType[]{MediaTypes.APPLICATION_DICOM_JSON_TYPE, MediaTypes.APPLICATION_DICOM_XML_TYPE}).build()).build());
        });
    }

    private ReadContext createReadContext(Storage storage, String storagePath) {
        ReadContext readContext = storage.createReadContext();
        readContext.setStoragePath(storagePath);
        readContext.setMessageDigest(storage.getStorageDescriptor().getMessageDigest());
        return readContext;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private StorageDescriptor getStorageDesc(String storageID) {
        StorageDescriptor storageDescriptor = ((ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getStorageDescriptor(storageID);
        if (storageDescriptor == null) {
            throw new WebApplicationException(this.errResponse("No such Storage: " + storageID, Response.Status.NOT_FOUND));
        }
        return storageDescriptor;
    }

    private Sequence sopSequence() {
        if (this.sopSequence == null) {
            this.sopSequence = this.response.newSequence(528793, 10);
        }
        return this.sopSequence;
    }

    private Sequence failedSOPSequence() {
        if (this.failedSOPSequence == null) {
            this.failedSOPSequence = this.response.newSequence(528792, 10);
        }
        return this.failedSOPSequence;
    }

    private Response.Status status() {
        return this.sopSequence == null ? Response.Status.CONFLICT : (this.failedSOPSequence == null ? Response.Status.OK : Response.Status.ACCEPTED);
    }

    private Attributes mkSOPRefWithRetrieveURL(StoreContext ctx) {
        Attributes attrs = this.mkSOPRef(ctx, 3);
        attrs.setString(528784, VR.UR, this.retrieveURL(ctx));
        return attrs;
    }

    private Attributes mkSOPRefWithFailureReason(StoreContext ctx, DicomServiceException e) {
        Attributes attrs = this.mkSOPRef(ctx, 3);
        attrs.setInt(528791, VR.US, new int[]{e.getStatus()});
        return attrs;
    }

    private String retrieveURL(StoreContext ctx) {
        StringBuffer requestURL = this.request.getRequestURL();
        return requestURL.substring(0, requestURL.indexOf("/rs") + 3) + "/studies/" + ctx.getStudyInstanceUID() + "/series/" + ctx.getSeriesInstanceUID() + "/instances/" + ctx.getSopInstanceUID();
    }

    private Attributes mkSOPRef(StoreContext ctx, int size) {
        Attributes attrs = new Attributes(size);
        attrs.setString(528720, VR.UI, ctx.getSopClassUID());
        attrs.setString(528725, VR.UI, ctx.getSopInstanceUID());
        return attrs;
    }

    private String retrieveURL() {
        if (this.studyInstanceUIDs.size() != 1) {
            return null;
        }
        StringBuffer requestURL = this.request.getRequestURL();
        return requestURL.substring(0, requestURL.indexOf("/rs") + 3) + "/studies/" + this.studyInstanceUIDs.iterator().next();
    }

    private Response errResponse(String errorMessage, Response.Status status) {
        return ImportStorageRS.errResponseAsTextPlain("{\"errorMessage\":\"" + errorMessage + "\"}", status);
    }

    private static Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private static String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private static enum Output {
        JSON(MediaTypes.APPLICATION_DICOM_JSON_TYPE){

            @Override
            Object entity(Attributes response, ApplicationEntity ae) {
                return OutputType.JSON.entity(response, ae);
            }
        }
        ,
        XML(MediaTypes.APPLICATION_DICOM_XML_TYPE){

            @Override
            Object entity(Attributes response, ApplicationEntity ae) {
                return OutputType.DICOM_XML.entity(response, ae);
            }
        };

        final MediaType type;

        private Output(MediaType type) {
            this.type = type;
        }

        static Output valueOf(MediaType type) {
            return MediaTypes.APPLICATION_DICOM_JSON_TYPE.isCompatible(type) ? JSON : (MediaTypes.APPLICATION_DICOM_XML_TYPE.isCompatible(type) ? XML : null);
        }

        abstract Object entity(Attributes var1, ApplicationEntity var2);
    }
}

