/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.DeleterThreshold;
import org.dcm4chee.arc.conf.RetentionPeriod;
import org.dcm4chee.arc.conf.StorageDescriptor;
import org.dcm4chee.arc.conf.StorageDuration;
import org.dcm4chee.arc.storage.Storage;
import org.dcm4chee.arc.storage.StorageFactory;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="storage")
@RequestScoped
public class StorageRS {
    private static final Logger LOG = LoggerFactory.getLogger(StorageRS.class);
    @Inject
    private Device device;
    @Inject
    private StorageFactory storageFactory;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="uriScheme")
    @Pattern(regexp="file|jclouds|emc-ecs-s3|hcp|documentum")
    private @Pattern(regexp="file|jclouds|emc-ecs-s3|hcp|documentum") String uriScheme;
    @QueryParam(value="dicomAETitle")
    private String dicomAETitle;
    @QueryParam(value="usage")
    @Pattern(regexp="dcmObjectStorageID|dcmMetadataStorageID|dcmSeriesMetadataStorageID")
    private @Pattern(regexp="dcmObjectStorageID|dcmMetadataStorageID|dcmSeriesMetadataStorageID") String usage;
    @QueryParam(value="usableSpaceBelow")
    private Long usableSpaceBelow;
    @QueryParam(value="dcmStorageClusterID")
    private String storageClusterID;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response search() {
        this.logRequest();
        try {
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                this.getStorageSystems().forEach(ss -> {
                    StorageDescriptor desc = ss.desc;
                    JsonWriter writer = new JsonWriter(gen);
                    gen.writeStartObject();
                    gen.write("dcmStorageID", desc.getStorageID());
                    gen.write("dcmURI", desc.getStorageURIStr());
                    writer.writeNotNullOrDef("dcmDigestAlgorithm", (Object)desc.getDigestAlgorithm(), null);
                    writer.writeNotNullOrDef("dcmInstanceAvailability", (Object)desc.getInstanceAvailability(), (Object)Availability.ONLINE);
                    writer.writeNotNullOrDef("dcmStorageDuration", (Object)desc.getStorageDuration(), (Object)StorageDuration.PERMANENT);
                    writer.writeNotDef("dcmReadOnly", desc.isReadOnly(), false);
                    writer.writeNotDef("dcmNoDeletionConstraint", desc.isNoDeletionConstraint(), false);
                    writer.writeNotDef("dcmStorageThresholdExceedsPermanently", desc.isStorageThresholdExceedsPermanently(), true);
                    writer.writeNotNull("dcmStorageThresholdExceeded", desc.getStorageThresholdExceeded());
                    writer.writeNotDef("dcmDeleterThreads", desc.getDeleterThreads(), 1);
                    if (desc.getStorageThreshold() != null) {
                        gen.write("storageThreshold", desc.getStorageThreshold().getMinUsableDiskSpace());
                    }
                    this.writeDeleterThresholds(writer, gen, desc.getDeleterThresholds());
                    writer.writeNotEmpty("dcmExternalRetrieveAET", (Object[])desc.getExternalRetrieveAETitles(), (Object[])new String[0]);
                    writer.writeNotEmpty("dcmExportStorageID", (Object[])desc.getExportStorageID(), (Object[])new String[0]);
                    if (desc.getRetrieveCacheStorageID() != null) {
                        gen.write("dcmRetrieveCacheStorageID", desc.getRetrieveCacheStorageID());
                        gen.write("dcmRetrieveCacheMaxParallel", desc.getRetrieveCacheMaxParallel());
                    }
                    writer.writeNotEmpty("dcmProperty", (Object[])this.descriptorProperties(desc.getProperties()), (Object[])new String[0]);
                    writer.writeNotEmpty("dicomAETitle", (Object[])ss.aets, (Object[])new String[0]);
                    writer.writeNotNullOrDef("dcmStorageClusterID", (Object)desc.getStorageClusterID(), null);
                    writer.writeNotEmpty("dcmDeleteStudiesOlderThan", (Object[])desc.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.OlderThan), (Object[])new String[0]);
                    writer.writeNotEmpty("dcmDeleteStudiesReceivedBefore", (Object[])desc.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.ReceivedBefore), (Object[])new String[0]);
                    writer.writeNotEmpty("dcmDeleteStudiesNotUsedSince", (Object[])desc.getRetentionPeriodsAsStrings(RetentionPeriod.DeleteStudies.NotUsedSince), (Object[])new String[0]);
                    writer.writeNotEmpty("usages", (Object[])ss.usages, (Object[])new String[0]);
                    gen.write("usableSpace", ss.usableSpace);
                    gen.write("totalSpace", ss.totalSpace);
                    gen.writeEnd();
                });
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private String[] descriptorProperties(Map<String, ?> props) {
        String[] ss = new String[props.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : props.entrySet()) {
            ss[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return ss;
    }

    private void writeDeleterThresholds(JsonWriter writer, JsonGenerator gen, List<DeleterThreshold> deleterThresholds) {
        if (deleterThresholds.isEmpty()) {
            return;
        }
        writer.writeStartArray("deleterThreshold");
        deleterThresholds.forEach(deleterThreshold -> {
            writer.writeStartObject();
            gen.write(deleterThreshold.getPrefix(), deleterThreshold.getMinUsableDiskSpace());
            writer.writeEnd();
        });
        writer.writeEnd();
    }

    private List<StorageSystem> getStorageSystems() {
        ApplicationEntity ae;
        if (!(this.dicomAETitle == null || (ae = this.device.getApplicationEntity(this.dicomAETitle, true)) != null && ae.isInstalled())) {
            LOG.info("Archive AE {} not provided by Device {}", (Object)this.dicomAETitle, (Object)this.device.getDeviceName());
            return Collections.EMPTY_LIST;
        }
        ArrayList<StorageSystem> storageSystems = new ArrayList<StorageSystem>();
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        arcdev.getStorageDescriptors().forEach(desc -> {
            String storageID = desc.getStorageID();
            HashSet<String> usages = new HashSet<String>();
            HashSet<String> aets = new HashSet<String>();
            if (StringUtils.contains((Object[])arcdev.getSeriesMetadataStorageIDs(), (Object)storageID)) {
                usages.add("dcmSeriesMetadataStorageID");
            }
            for (ApplicationEntity ae : this.device.getApplicationEntities()) {
                ArchiveAEExtension arcAE = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
                if (arcAE == null) {
                    LOG.info("Archive AE Extension not configured for AE : {}", (Object)ae.getAETitle());
                    continue;
                }
                if (StringUtils.contains((Object[])arcAE.getObjectStorageIDs(), (Object)desc.getStorageID())) {
                    usages.add("dcmObjectStorageID");
                    aets.add(ae.getAETitle());
                }
                if (!StringUtils.contains((Object[])arcAE.getMetadataStorageIDs(), (Object)desc.getStorageID())) continue;
                usages.add("dcmMetadataStorageID");
                aets.add(ae.getAETitle());
            }
            if (!(this.dicomAETitle != null && !aets.contains(this.dicomAETitle) || this.usage != null && !usages.contains(this.usage) || this.storageClusterID != null && !this.storageClusterID.equals(desc.getStorageClusterID()) || this.uriScheme != null && !desc.getStorageURI().getScheme().equals(this.uriScheme))) {
                try (Storage storage = this.storageFactory.getStorage(desc);){
                    long usableSpace = storage.getUsableSpace();
                    if (this.usableSpaceBelow == null || usableSpace < this.usableSpaceBelow) {
                        long totalSpace = storage.getTotalSpace();
                        storageSystems.add(new StorageSystem((StorageDescriptor)desc, usableSpace, totalSpace, (Collection<String>)usages, (Collection<String>)aets));
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to access {}", desc, (Object)e);
                }
            }
        });
        storageSystems.sort(Comparator.comparing(storageSystem -> storageSystem.desc.getStorageID()));
        return storageSystems;
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static class StorageSystem {
        final StorageDescriptor desc;
        final long usableSpace;
        final long totalSpace;
        final String[] usages;
        final String[] aets;

        StorageSystem(StorageDescriptor desc, long usableSpace, long totalSpace, Collection<String> usages, Collection<String> aets) {
            this.desc = desc;
            this.usableSpace = usableSpace;
            this.totalSpace = totalSpace;
            this.usages = usages.toArray(StringUtils.EMPTY_STRING);
            this.aets = aets.toArray(StringUtils.EMPTY_STRING);
            Arrays.sort(this.usages);
            Arrays.sort(this.aets);
        }
    }
}

