/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4chee.arc.entity.StgCmtResult;
import org.dcm4chee.arc.query.util.StgCmtResultQueryParam;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="stgcmt")
public class StgCmtRS {
    private static final Logger LOG = LoggerFactory.getLogger(StgCmtRS.class);
    @Inject
    private StgCmtManager mgr;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="status")
    @Pattern(regexp="PENDING|COMPLETED|WARNING|FAILED")
    private @Pattern(regexp="PENDING|COMPLETED|WARNING|FAILED") String status;
    @QueryParam(value="studyUID")
    private String studyUID;
    @QueryParam(value="ExporterID")
    private String exporterID;
    @QueryParam(value="batchID")
    private String batchID;
    @QueryParam(value="taskID")
    private Long taskID;
    @QueryParam(value="updatedBefore")
    @Pattern(regexp="(19|20)\\d{2}\\-\\d{2}\\-\\d{2}")
    private @Pattern(regexp="(19|20)\\d{2}\\-\\d{2}\\-\\d{2}") String updatedBefore;
    @QueryParam(value="offset")
    @Pattern(regexp="0|([1-9]\\d{0,4})")
    private @Pattern(regexp="0|([1-9]\\d{0,4})") String offset;
    @QueryParam(value="limit")
    @Pattern(regexp="[1-9]\\d{0,4}")
    private @Pattern(regexp="[1-9]\\d{0,4}") String limit;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response listStgCmts() {
        this.logRequest();
        try {
            List stgCmtResults = this.mgr.listStgCmts(new StgCmtResultQueryParam(StgCmtRS.statusOf(this.status), null, this.exporterID, this.studyUID, this.batchID, this.taskID), StgCmtRS.parseInt(this.offset), StgCmtRS.parseInt(this.limit));
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                stgCmtResults.forEach(stgCmtResult -> {
                    JsonWriter writer = new JsonWriter(gen);
                    gen.writeStartObject();
                    writer.writeNotNullOrDef("dicomDeviceName", (Object)stgCmtResult.getDeviceName(), null);
                    writer.writeNotNullOrDef("transactionUID", (Object)stgCmtResult.getTransactionUID(), null);
                    writer.writeNotNullOrDef("status", (Object)stgCmtResult.getStatus().name(), null);
                    writer.writeNotNullOrDef("studyUID", (Object)stgCmtResult.getStudyInstanceUID(), null);
                    writer.writeNotNullOrDef("seriesUID", (Object)stgCmtResult.getSeriesInstanceUID(), null);
                    writer.writeNotNullOrDef("objectUID", (Object)stgCmtResult.getSopInstanceUID(), null);
                    writer.writeNotNullOrDef("exporterID", (Object)stgCmtResult.getExporterID(), null);
                    writer.writeNotNullOrDef("taskID", (Object)stgCmtResult.getTaskPK(), null);
                    writer.writeNotNullOrDef("batchID", (Object)stgCmtResult.getBatchID(), null);
                    writer.writeNotNullOrDef("requested", (Object)stgCmtResult.getNumberOfInstances(), (Object)0);
                    writer.writeNotNullOrDef("failures", (Object)stgCmtResult.getNumberOfFailures(), (Object)0);
                    writer.writeNotNullOrDef("createdTime", (Object)stgCmtResult.getCreatedTime().toString(), null);
                    writer.writeNotNullOrDef("updatedTime", (Object)stgCmtResult.getUpdatedTime().toString(), null);
                    gen.writeEnd();
                });
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="{transactionUID}")
    public void deleteStgCmt(@PathParam(value="transactionUID") String transactionUID) {
        this.logRequest();
        try {
            if (!this.mgr.deleteStgCmt(transactionUID)) {
                throw new WebApplicationException(this.errResponse("No such Storage Commitment Result " + transactionUID, Response.Status.NOT_FOUND));
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response deleteStgCmts() {
        this.logRequest();
        try {
            return Response.ok((Object)("{\"deleted\":" + this.mgr.deleteStgCmts(StgCmtRS.statusOf(this.status), StgCmtRS.parseDate(this.updatedBefore)) + "}")).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static StgCmtResult.Status statusOf(String status) {
        return status != null ? StgCmtResult.Status.valueOf((String)status) : null;
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private static Date parseDate(String s) throws Exception {
        return s != null ? new SimpleDateFormat("yyyy-MM-dd").parse(s) : null;
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

