/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.pdq.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.PDQServiceDescriptor;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.pdq.PDQServiceContext;
import org.dcm4chee.arc.pdq.PDQServiceException;
import org.dcm4chee.arc.pdq.PDQServiceFactory;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="/pdq/{PDQServiceID}")
public class QueryPatientDemographicRS {
    private static final Logger LOG = LoggerFactory.getLogger(QueryPatientDemographicRS.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private Device device;
    @Inject
    private PDQServiceFactory serviceFactory;
    @PathParam(value="PDQServiceID")
    private String pdqServiceID;

    @GET
    @NoCache
    @Path(value="/patients/{PatientID}")
    @Produces(value={"application/dicom+json,application/json"})
    public Response query(@PathParam(value="PatientID") IDWithIssuer patientID) {
        Attributes attrs;
        this.logRequest();
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        try {
            PDQServiceDescriptor descriptor = arcdev.getPDQServiceDescriptor(this.pdqServiceID);
            if (descriptor == null) {
                return this.errResponse("No such PDQ Service: " + this.pdqServiceID, Response.Status.NOT_FOUND);
            }
            PDQServiceContext ctx = new PDQServiceContext(patientID);
            ctx.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setSearchMethod(PDQServiceContext.SearchMethod.QueryPatientDemographics);
            attrs = this.serviceFactory.getPDQService(descriptor).query(ctx);
        }
        catch (IllegalStateException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (PDQServiceException e) {
            return this.errResponseAsTextPlain(this.exceptionAsString((Exception)((Object)e)), Response.Status.BAD_GATEWAY);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return attrs != null ? Response.ok((Object)this.toJSON(attrs, arcdev)).build() : this.errResponse("Querying the PDQ Service returned null attributes", Response.Status.NOT_FOUND);
    }

    private void logRequest() {
        LOG.info("Process GET {} from {}@{}", new Object[]{this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {} ", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private StreamingOutput toJSON(Attributes attrs, ArchiveDeviceExtension arcDev) {
        return out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                arcDev.encodeAsJSONNumber(new JSONWriter(gen)).write(attrs);
            }
        };
    }
}

