/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import javax.persistence.criteria.CriteriaQuery;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.AllowDeletePatient;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.RSOperation;
import org.dcm4chee.arc.delete.DeletionService;
import org.dcm4chee.arc.entity.AttributesBlob;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.hl7.HL7SenderUtils;
import org.dcm4chee.arc.id.IDService;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.patient.CircularPatientMergeException;
import org.dcm4chee.arc.patient.NonUniquePatientException;
import org.dcm4chee.arc.patient.PatientAlreadyExistsException;
import org.dcm4chee.arc.patient.PatientMergedException;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.patient.PatientTrackingNotAllowedException;
import org.dcm4chee.arc.patient.PatientUnmergedException;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.scu.CFindSCU;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.rs.client.RSForward;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=PamRS.class)
public class PamRS {
    private static final Logger LOG = LoggerFactory.getLogger(PamRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private IDService idService;
    @Inject
    private RSForward rsForward;
    @Inject
    private PatientService patientService;
    @Inject
    private DeletionService deletionService;
    @Inject
    private HL7Sender hl7Sender;
    @Inject
    private QueryService queryService;
    @Inject
    private CFindSCU cfindscu;
    @PathParam(value="AETitle")
    private String aet;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    @DELETE
    @Path(value="/patients/{PatientID}")
    public Response deletePatient(@PathParam(value="PatientID") IDWithIssuer patientID) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            String patientDeleteForbidden;
            Patient patient = this.patientService.findPatient(patientID);
            if (patient == null) {
                return this.errResponse("Patient having patient ID : " + patientID + " not found.", Response.Status.NOT_FOUND);
            }
            AllowDeletePatient allowDeletePatient = arcAE.allowDeletePatient();
            String string = allowDeletePatient == AllowDeletePatient.NEVER ? "Patient deletion as per configuration is never allowed." : (patientDeleteForbidden = allowDeletePatient == AllowDeletePatient.WITHOUT_STUDIES && patient.getNumberOfStudies() > 0 ? "Patient having patient ID : " + patientID + " has non empty studies." : null);
            if (patientDeleteForbidden != null) {
                return this.errResponse(patientDeleteForbidden, Response.Status.FORBIDDEN);
            }
            PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setArchiveAEExtension(arcAE);
            ctx.setPatientID(patientID);
            ctx.setAttributes(patient.getAttributes());
            ctx.setEventActionCode("D");
            ctx.setPatient(patient);
            this.deletionService.deletePatient(ctx, arcAE);
            this.rsForward.forward(RSOperation.DeletePatient, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (NonUniquePatientException | PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/patients")
    @Consumes(value={"application/dicom+json,application/json"})
    @Produces(value={"application/json"})
    public Response createPatient(InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            PatientMgtContext ctx = this.patientMgtCtx(in);
            ctx.setArchiveAEExtension(arcAE);
            if (!ctx.getAttributes().containsValue(0x100020)) {
                this.idService.newPatientID(ctx.getAttributes());
                ctx.setPatientID(IDWithIssuer.pidOf((Attributes)ctx.getAttributes()));
            }
            this.patientService.updatePatient(ctx);
            this.rsForward.forward(RSOperation.CreatePatient, arcAE, ctx.getAttributes(), this.request);
            this.notifyHL7Receivers("ADT^A28^ADT_A05", ctx);
            return Response.ok((Object)("{\"PatientID\":\"" + IDWithIssuer.pidOf((Attributes)ctx.getAttributes()) + "\"}")).build();
        }
        catch (NonUniquePatientException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private PatientMgtContext patientMgtCtx(InputStream in) {
        PatientMgtContext ctx = this.patientMgtCtx();
        ctx.setAttributes(this.toAttributes(in));
        return ctx;
    }

    private PatientMgtContext patientMgtCtx() {
        PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        ctx.setAttributeUpdatePolicy(Attributes.UpdatePolicy.REPLACE);
        return ctx;
    }

    @PUT
    @Path(value="/patients/{priorPatientID}")
    @Consumes(value={"application/dicom+json,application/json"})
    public Response updatePatient(@PathParam(value="priorPatientID") IDWithIssuer priorPatientID, @javax.ws.rs.QueryParam(value="merge") @Pattern(regexp="true|false") @DefaultValue(value="false") @Pattern(regexp="true|false") String merge, InputStream in) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        PatientMgtContext ctx = this.patientMgtCtx(in);
        ctx.setArchiveAEExtension(arcAE);
        IDWithIssuer targetPatientID = ctx.getPatientID();
        if (targetPatientID == null) {
            return this.errResponse("missing Patient ID in message body", Response.Status.BAD_REQUEST);
        }
        boolean mergePatients = Boolean.parseBoolean(merge);
        boolean patientMatch = priorPatientID.equals((Object)targetPatientID);
        if (patientMatch && mergePatients) {
            return this.errResponse("Circular Merge of Patients not allowed.", Response.Status.BAD_REQUEST);
        }
        RSOperation rsOp = RSOperation.CreatePatient;
        String msgType = "ADT^A28^ADT_A05";
        try {
            if (patientMatch) {
                this.patientService.updatePatient(ctx);
                if (ctx.getEventActionCode().equals("U")) {
                    rsOp = RSOperation.UpdatePatient;
                    msgType = "ADT^A31^ADT_A05";
                }
            } else {
                ctx.setPreviousAttributes(priorPatientID.exportPatientIDWithIssuer(null));
                if (mergePatients) {
                    msgType = "ADT^A40^ADT_A39";
                    rsOp = RSOperation.MergePatient2;
                    this.patientService.mergePatient(ctx);
                } else {
                    msgType = "ADT^A47^ADT_A30";
                    rsOp = RSOperation.ChangePatientID2;
                    this.patientService.changePatientID(ctx);
                }
            }
            if (!ctx.getEventActionCode().equals("R") || rsOp == RSOperation.MergePatient2) {
                this.rsForward.forward(rsOp, arcAE, ctx.getAttributes(), this.request);
                this.notifyHL7Receivers(msgType, ctx);
            }
            return Response.noContent().build();
        }
        catch (CircularPatientMergeException | NonUniquePatientException | PatientAlreadyExistsException | PatientTrackingNotAllowedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/patients/{patientID}/merge")
    @Consumes(value={"application/json"})
    public Response mergePatients(@PathParam(value="patientID") IDWithIssuer patientID, InputStream in) {
        Iterator iterator;
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            ByteArrayInputStream is1 = new ByteArrayInputStream(baos.toByteArray());
            Attributes attrs = this.parseOtherPatientIDs(is1);
            for (Attributes otherPID : attrs.getSequence(0x101002)) {
                this.mergePatient(patientID, otherPID, arcAE);
            }
            this.rsForward.forward(RSOperation.MergePatient, arcAE, baos.toByteArray(), null, this.request);
            iterator = Response.noContent().build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParsingException e) {
                return this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST);
            }
            catch (CircularPatientMergeException | NonUniquePatientException | PatientMergedException e) {
                return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
            }
            catch (Exception e) {
                return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        baos.close();
        return iterator;
    }

    @POST
    @Path(value="/patients/{priorPatientID}/merge/{patientID}")
    public Response mergePatient(@PathParam(value="priorPatientID") IDWithIssuer priorPatientID, @PathParam(value="patientID") IDWithIssuer patientID, @javax.ws.rs.QueryParam(value="verify") String findSCP) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            if (findSCP != null) {
                this.verifyMergePatient(priorPatientID, patientID, findSCP, this.cfindscu, arcAE.getApplicationEntity());
            }
            this.mergePatient(patientID, priorPatientID.exportPatientIDWithIssuer(null), arcAE);
            this.rsForward.forward(RSOperation.MergePatient, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (VerifyMergePatientException | CircularPatientMergeException | NonUniquePatientException | PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/patients/{PatientID}/unmerge")
    public Response unmergePatient(@PathParam(value="PatientID") IDWithIssuer patientID) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            PatientMgtContext patMgtCtx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            patMgtCtx.setArchiveAEExtension(arcAE);
            patMgtCtx.setPatientID(patientID);
            patMgtCtx.setAttributes(patientID.exportPatientIDWithIssuer(null));
            if (!this.patientService.unmergePatient(patMgtCtx)) {
                return this.errResponse("Patient with patient ID " + patientID + " not found.", Response.Status.NOT_FOUND);
            }
            this.rsForward.forward(RSOperation.UnmergePatient, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (NonUniquePatientException | PatientUnmergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="/patients/issuer/{issuer}")
    public Response supplementIssuer(@PathParam(value="issuer") AttributesFormat issuer, @javax.ws.rs.QueryParam(value="test") @Pattern(regexp="true|false") @DefaultValue(value="false") @Pattern(regexp="true|false") String test) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        HashSet<IDWithIssuer> success = new HashSet<IDWithIssuer>();
        HashMap<IDWithIssuer, Long> ambiguous = new HashMap<IDWithIssuer, Long>();
        HashMap<String, String> failures = new HashMap<String, String>();
        try {
            QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
            Attributes queryKeys = queryAttrs.getQueryKeys();
            if (queryKeys.getString(0x100021) != null || queryKeys.getNestedDataset(1048612) != null) {
                return this.errResponse("Issuer of Patient ID or Issuer of Patient ID Qualifiers Sequence not allowed in query filters", Response.Status.BAD_REQUEST);
            }
            CriteriaQuery query = this.queryService.createPatientWithUnknownIssuerQuery(this.queryParam(arcAE.getApplicationEntity(), true), queryKeys);
            String toManyDuplicates = null;
            int supplementIssuerFetchSize = arcAE.getArchiveDeviceExtension().getSupplementIssuerFetchSize();
            boolean testIssuer = Boolean.parseBoolean(test);
            if (testIssuer) {
                this.patientService.testSupplementIssuers(query, supplementIssuerFetchSize, success, ambiguous, issuer);
            } else {
                boolean remaining;
                HashSet failedPks = new HashSet();
                int carry = 0;
                do {
                    int limit;
                    List matches;
                    remaining = (matches = this.patientService.queryWithOffsetAndLimit(query, 0, limit = supplementIssuerFetchSize + failedPks.size() + carry)).size() == limit;
                    matches.removeIf(p -> failedPks.contains(p.getPk()));
                    if (matches.isEmpty()) break;
                    carry = 0;
                    if (remaining) {
                        try {
                            ListIterator itr = matches.listIterator(matches.size());
                            toManyDuplicates = ((Patient)itr.previous()).getPatientID().getID();
                            do {
                                itr.remove();
                                ++carry;
                            } while (toManyDuplicates.equals(((Patient)itr.previous()).getPatientID().getID()));
                            toManyDuplicates = null;
                        }
                        catch (NoSuchElementException e) {
                            break;
                        }
                    }
                    matches.stream().collect(Collectors.groupingBy(p -> new IDWithIssuer(p.getPatientID().getID(), issuer.format((Object)p.getAttributes())))).forEach((idWithIssuer, patients) -> {
                        if (patients.size() > 1) {
                            ambiguous.put((IDWithIssuer)idWithIssuer, Long.valueOf(patients.size()));
                            patients.stream().map(Patient::getPk).forEach(failedPks::add);
                        } else {
                            Patient patient = (Patient)patients.get(0);
                            try {
                                if (this.patientService.supplementIssuer(this.patientMgtCtx(), patient, idWithIssuer, ambiguous)) {
                                    success.add((IDWithIssuer)idWithIssuer);
                                } else {
                                    failedPks.add(patient.getPk());
                                }
                            }
                            catch (Exception e) {
                                failures.put(idWithIssuer.toString(), e.getMessage());
                                failedPks.add(patient.getPk());
                            }
                        }
                    });
                } while (remaining && failedPks.size() < supplementIssuerFetchSize);
                if (!success.isEmpty()) {
                    this.rsForward.forward(RSOperation.SupplementIssuer, arcAE, null, this.request);
                }
            }
            return PamRS.supplementIssuerResponse(success, ambiguous, failures, toManyDuplicates).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static Response.ResponseBuilder supplementIssuerResponse(Set<IDWithIssuer> success, Map<IDWithIssuer, Long> ambiguous, Map<String, String> failures, String toManyDuplicates) {
        boolean ok;
        boolean bl = ok = ambiguous.isEmpty() && failures.isEmpty() && toManyDuplicates == null;
        return ok && success.isEmpty() ? Response.status((Response.Status)Response.Status.NO_CONTENT) : Response.status((Response.Status)(ok ? Response.Status.OK : (success.isEmpty() ? Response.Status.CONFLICT : Response.Status.ACCEPTED))).entity(out -> PamRS.supplementIssuerResponsePayload(success, ambiguous, failures, toManyDuplicates, out));
    }

    private static void supplementIssuerResponsePayload(Set<IDWithIssuer> success, Map<IDWithIssuer, Long> ambiguous, Map<String, String> failures, String toManyDuplicates, OutputStream out) {
        JsonGenerator gen = Json.createGenerator((OutputStream)out);
        gen.writeStartObject();
        if (!success.isEmpty()) {
            gen.writeStartArray("pids");
            success.stream().map(Object::toString).forEach(arg_0 -> ((JsonGenerator)gen).write(arg_0));
            gen.writeEnd();
        }
        if (!ambiguous.isEmpty()) {
            gen.writeStartArray("ambiguous");
            ambiguous.forEach((idWithIssuer, count) -> {
                gen.writeStartObject();
                gen.write("pid", idWithIssuer.toString());
                gen.write("count", count.longValue());
                gen.writeEnd();
            });
            gen.writeEnd();
        }
        if (!failures.isEmpty()) {
            gen.writeStartArray("failures");
            failures.forEach((pid, errorMsg) -> {
                gen.writeStartObject();
                gen.write("pid", pid);
                gen.write("errorMessage", errorMsg);
                gen.writeEnd();
            });
            gen.writeEnd();
        }
        if (toManyDuplicates != null) {
            gen.write("tooManyDuplicates", toManyDuplicates);
        }
        gen.writeEnd();
        gen.flush();
    }

    private Attributes toAttributes(InputStream in) {
        try {
            return new JSONReader(Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8))).readDataset(null);
        }
        catch (JsonParsingException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage() + " at location : " + e.getLocation(), Response.Status.BAD_REQUEST));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private QueryParam queryParam(ApplicationEntity ae, boolean withoutIssuer) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setWithoutIssuer(withoutIssuer);
        return queryParam;
    }

    private void verifyMergePatient(IDWithIssuer priorPatientID, IDWithIssuer patientID, String findSCP, CFindSCU cfindscu, ApplicationEntity localAE) throws Exception {
        try {
            List studiesOfPriorPatient = cfindscu.findStudiesOfPatient(localAE, findSCP, 0, priorPatientID, new int[0]);
            if (!studiesOfPriorPatient.isEmpty()) {
                throw new VerifyMergePatientException("Found " + studiesOfPriorPatient.size() + " studies of prior Patient[id=" + priorPatientID + "] at " + findSCP);
            }
            Patient priorPatient = this.patientService.findPatient(priorPatientID);
            if (priorPatient != null) {
                for (String studyIUID : this.patientService.studyInstanceUIDsOf(priorPatient)) {
                    IDWithIssuer findPatientID;
                    studiesOfPriorPatient = cfindscu.findStudy(localAE, findSCP, 0, studyIUID, new int[]{0x100020, 0x100021, 1048612});
                    if (studiesOfPriorPatient.isEmpty() || (findPatientID = IDWithIssuer.pidOf((Attributes)((Attributes)studiesOfPriorPatient.get(0)))).matches(patientID)) continue;
                    throw new VerifyMergePatientException("Found Study[uid=" + studyIUID + "] of different Patient[id=" + findPatientID + "] than target Patient[id=" + patientID + "] at " + findSCP);
                }
            }
        }
        catch (ConfigurationNotFoundException e) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + findSCP, Response.Status.NOT_FOUND));
        }
        catch (ConnectException | DicomServiceException e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString((Exception)e), Response.Status.BAD_GATEWAY));
        }
    }

    private void mergePatient(IDWithIssuer patientID, Attributes priorPatAttr, ArchiveAEExtension arcAE) throws Exception {
        PatientMgtContext patMgtCtx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
        patMgtCtx.setArchiveAEExtension(arcAE);
        patMgtCtx.setPatientID(patientID);
        patMgtCtx.setAttributes(patientID.exportPatientIDWithIssuer(null));
        patMgtCtx.setPreviousAttributes(priorPatAttr);
        LOG.info("Prior patient ID {} and target patient ID {}", (Object)patMgtCtx.getPreviousPatientID(), (Object)patMgtCtx.getPatientID());
        this.patientService.mergePatient(patMgtCtx);
        this.notifyHL7Receivers("ADT^A40^ADT_A39", patMgtCtx);
    }

    @POST
    @Path(value="/patients/{priorPatientID}/changeid/{patientID}")
    public Response changePatientID(@PathParam(value="priorPatientID") IDWithIssuer priorPatientID, @PathParam(value="patientID") IDWithIssuer patientID) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            Patient prevPatient = this.patientService.findPatient(priorPatientID);
            PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request));
            ctx.setArchiveAEExtension(arcAE);
            ctx.setAttributeUpdatePolicy(Attributes.UpdatePolicy.REPLACE);
            ctx.setPreviousAttributes(priorPatientID.exportPatientIDWithIssuer(null));
            ctx.setAttributes(patientID.exportPatientIDWithIssuer(prevPatient.getAttributes()));
            this.patientService.changePatientID(ctx);
            this.notifyHL7Receivers("ADT^A47^ADT_A30", ctx);
            this.rsForward.forward(RSOperation.ChangePatientID, arcAE, null, this.request);
            return Response.noContent().build();
        }
        catch (CircularPatientMergeException | NonUniquePatientException | PatientAlreadyExistsException | PatientTrackingNotAllowedException e) {
            return this.errResponse(e.getMessage(), Response.Status.CONFLICT);
        }
        catch (PatientMergedException e) {
            return this.errResponse(e.getMessage(), Response.Status.FORBIDDEN);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this, this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    public void validate() {
        this.logRequest();
        String[] uriPath = StringUtils.split((String)this.uriInfo.getPath(), (char)'/');
        if ("issuer".equals(uriPath[uriPath.length - 2])) {
            new QueryAttributes(this.uriInfo, null);
        }
    }

    private Attributes parseOtherPatientIDs(InputStream in) {
        JsonParser parser = Json.createParser((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        Attributes attrs = new Attributes(10);
        this.expect(parser, JsonParser.Event.START_ARRAY);
        Sequence otherPIDseq = attrs.newSequence(0x101002, 10);
        while (parser.next() == JsonParser.Event.START_OBJECT) {
            Attributes otherPID = new Attributes(5);
            block11: while (parser.next() == JsonParser.Event.KEY_NAME) {
                switch (parser.getString()) {
                    case "PatientID": {
                        this.expect(parser, JsonParser.Event.VALUE_STRING);
                        otherPID.setString(0x100020, VR.LO, parser.getString());
                        continue block11;
                    }
                    case "IssuerOfPatientID": {
                        this.expect(parser, JsonParser.Event.VALUE_STRING);
                        otherPID.setString(0x100021, VR.LO, parser.getString());
                        continue block11;
                    }
                    case "IssuerOfPatientIDQualifiers": {
                        this.expect(parser, JsonParser.Event.START_OBJECT);
                        otherPID.newSequence(1048612, 2).add(this.parseIssuerOfPIDQualifier(parser));
                        continue block11;
                    }
                }
                throw new WebApplicationException(this.errResponse("Unexpected Key name", Response.Status.BAD_REQUEST));
            }
            otherPIDseq.add(otherPID);
        }
        if (otherPIDseq.isEmpty()) {
            throw new WebApplicationException(this.errResponse("Patients to be merged not sent in the request.", Response.Status.BAD_REQUEST));
        }
        return attrs;
    }

    private Attributes parseIssuerOfPIDQualifier(JsonParser parser) {
        Attributes attr = new Attributes(2);
        block8: while (parser.next() == JsonParser.Event.KEY_NAME) {
            switch (parser.getString()) {
                case "UniversalEntityID": {
                    this.expect(parser, JsonParser.Event.VALUE_STRING);
                    attr.setString(4194354, VR.UT, parser.getString());
                    continue block8;
                }
                case "UniversalEntityIDType": {
                    this.expect(parser, JsonParser.Event.VALUE_STRING);
                    attr.setString(0x400033, VR.CS, parser.getString());
                    continue block8;
                }
            }
            throw new WebApplicationException(this.errResponse("Unexpected Key name", Response.Status.BAD_REQUEST));
        }
        return attr;
    }

    private void expect(JsonParser parser, JsonParser.Event expected) {
        JsonParser.Event next = parser.next();
        if (next != expected) {
            throw new WebApplicationException(this.errResponse("Unexpected " + next, Response.Status.BAD_REQUEST));
        }
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.info("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public void notifyHL7Receivers(String msgType, PatientMgtContext ctx) throws Exception {
        ArchiveDeviceExtension arcDev = (ArchiveDeviceExtension)this.device.getDeviceExtension(ArchiveDeviceExtension.class);
        String sendingAppFacility = arcDev.getHL7ADTSendingApplication();
        if (sendingAppFacility == null) {
            return;
        }
        HL7Application sender = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(sendingAppFacility);
        if (sender == null) {
            LOG.info("Sending HL7 Application not configured : {}", (Object)sendingAppFacility);
            return;
        }
        for (String receivingAppFacility : arcDev.getHL7ADTReceivingApplication()) {
            try {
                HL7Application receiver = this.hl7AppCache.findHL7Application(receivingAppFacility);
                byte[] data = HL7SenderUtils.data((HL7Application)sender, (HL7Application)receiver, (Attributes)ctx.getAttributes(), (Attributes)ctx.getPreviousAttributes(), (String)msgType, (String)arcDev.getOutgoingPatientUpdateTemplateURI(), null, null);
                this.hl7Sender.scheduleMessage(ctx.getHttpServletRequestInfo(), data);
            }
            catch (ConfigurationException e) {
                LOG.info("Unknown HL7 receiving application and facility {} to send message type {}", (Object)receivingAppFacility, (Object)msgType);
            }
            catch (UnsupportedEncodingException | TransformerConfigurationException | SAXException e) {
                LOG.info("Failed in stylesheet {} transformation for message type {} \n", new Object[]{arcDev.getOutgoingPatientUpdateTemplateURI(), msgType, e});
            }
            catch (Exception e) {
                LOG.info("Failed to notify HL7 receiver {} for message type {} \n", new Object[]{receivingAppFacility, msgType, e});
            }
        }
    }

    @POST
    @Path(value="/patients/charset/{charset}")
    public Response updateCharset(@Pattern(regexp="ISO_IR 100|ISO_IR 101|ISO_IR 109|ISO_IR 110|ISO_IR 144|ISO_IR 127|ISO_IR 126|ISO_IR 138|ISO_IR 148|ISO_IR 13|ISO_IR 166|ISO_IR 192|GB18030|GBK") @PathParam(value="charset") @Pattern(regexp="ISO_IR 100|ISO_IR 101|ISO_IR 109|ISO_IR 110|ISO_IR 144|ISO_IR 127|ISO_IR 126|ISO_IR 138|ISO_IR 148|ISO_IR 13|ISO_IR 166|ISO_IR 192|GB18030|GBK") String charset, @javax.ws.rs.QueryParam(value="test") @Pattern(regexp="true|false") @DefaultValue(value="false") @Pattern(regexp="true|false") String test) {
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        if (this.aet.equals(arcAE.getApplicationEntity().getAETitle())) {
            this.validateWebAppServiceClass();
        }
        boolean update = !Boolean.parseBoolean(test);
        int updated = 0;
        ArrayList<IDWithIssuer> failures = new ArrayList<IDWithIssuer>();
        try {
            QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
            Attributes queryKeys = queryAttrs.getQueryKeys();
            CriteriaQuery query = this.queryService.createPatientAttributesQuery(this.queryParam(arcAE.getApplicationEntity(), false), queryKeys);
            int limit = arcAE.getArchiveDeviceExtension().getUpdateCharsetFetchSize();
            int offset = 0;
            List blobs = this.patientService.queryWithOffsetAndLimit(query, offset, limit);
            if (blobs.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            while (true) {
                for (AttributesBlob blob : blobs) {
                    Attributes attrs = blob.getAttributes();
                    if (charset.equals(attrs.getString(524293))) continue;
                    attrs.setSpecificCharacterSet(new String[]{charset});
                    blob.setAttributes(attrs);
                    if (attrs.equals((Object)AttributesBlob.decodeAttributes((byte[])blob.getEncodedAttributes(), null))) {
                        if (update) {
                            this.patientService.merge((Object)blob);
                        }
                        ++updated;
                        continue;
                    }
                    failures.add(IDWithIssuer.pidOf((Attributes)attrs));
                }
                if (blobs.size() < limit) break;
                offset += blobs.size();
            }
            if (updated > 0) {
                this.rsForward.forward(RSOperation.UpdateCharset, arcAE, null, this.request);
            }
            return PamRS.updateCharsetResponse(updated, failures).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private static Response.ResponseBuilder updateCharsetResponse(int updated, List<IDWithIssuer> failures) {
        return Response.status((Response.Status)(failures.isEmpty() ? Response.Status.OK : (updated == 0 ? Response.Status.CONFLICT : Response.Status.ACCEPTED))).entity(out -> PamRS.updateCharsetResponsePayload(updated, failures, out));
    }

    private static void updateCharsetResponsePayload(int updated, List<IDWithIssuer> failures, OutputStream out) {
        JsonGenerator gen = Json.createGenerator((OutputStream)out);
        gen.writeStartObject();
        gen.write("updated", updated);
        if (!failures.isEmpty()) {
            gen.writeStartArray("failures");
            failures.forEach(s -> gen.write(s != null ? s.toString() : "w/o Patient ID"));
            gen.writeEnd();
        }
        gen.writeEnd();
        gen.flush();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private static class VerifyMergePatientException
    extends Exception {
        public VerifyMergePatientException(String message) {
            super(message);
        }
    }
}

