/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Code;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.RejectionNote;
import org.dcm4chee.arc.delete.DeletionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="reject")
@RequestScoped
public class DeleteRejected {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteRejected.class);
    @Inject
    private Device device;
    @Inject
    private DeletionService service;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="rejectedBefore")
    @Pattern(regexp="(19|20)\\d{2}\\-\\d{2}\\-\\d{2}")
    private @Pattern(regexp="(19|20)\\d{2}\\-\\d{2}\\-\\d{2}") String rejectedBefore;
    @QueryParam(value="keepRejectionNote")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String keepRejectionNote;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    private Date parseDate(String s) {
        try {
            return s != null ? new SimpleDateFormat("yyyy-MM-dd").parse(s) : null;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @DELETE
    @Path(value="{CodeValue}^{CodingSchemeDesignator}")
    @Produces(value={"application/json"})
    public String delete(@PathParam(value="CodeValue") String codeValue, @PathParam(value="CodingSchemeDesignator") String designator) {
        this.logRequest();
        ArchiveDeviceExtension arcDev = this.arcDev();
        Code code = new Code(codeValue, designator, null, "?");
        RejectionNote rjNote = arcDev.getRejectionNote(code);
        if (rjNote == null) {
            throw new WebApplicationException(this.errResponse("Unknown Rejection Note Code: " + code, Response.Status.NOT_FOUND));
        }
        try {
            Date before = this.parseDate(this.rejectedBefore);
            int fetchSize = arcDev.getDeleteRejectedFetchSize();
            int deleted = this.service.deleteRejectedInstancesBefore(rjNote.getRejectionNoteCode(), before, fetchSize);
            if (!Boolean.parseBoolean(this.keepRejectionNote)) {
                deleted += this.service.deleteRejectionNotesBefore(rjNote.getRejectionNoteCode(), before, fetchSize);
            }
            LOG.info("Deleted {} instances permanently", (Object)deleted);
            return "{\"deleted\":" + deleted + "}";
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ArchiveDeviceExtension arcDev() {
        try {
            return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        }
        catch (IllegalStateException e) {
            throw new WebApplicationException(this.errResponse("Archive Device Extension not configured for device: " + this.device.getDeviceName(), Response.Status.NOT_FOUND));
        }
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

