/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.iocm.rs;

import java.net.InetAddress;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4chee.arc.HL7ConnectionEvent;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.ArchiveHL7ApplicationExtension;
import org.dcm4chee.arc.conf.HL7Fields;
import org.dcm4chee.arc.conf.HL7StudyRetentionPolicy;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.study.StudyMgtContext;
import org.dcm4chee.arc.study.StudyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ApplyHL7RetentionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ApplyHL7RetentionPolicy.class);
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private StudyService studyService;

    public void onHL7Connection(@Observes HL7ConnectionEvent event) {
        if (event.getType() != HL7ConnectionEvent.Type.MESSAGE_PROCESSED || event.getException() != null) {
            return;
        }
        UnparsedHL7Message msg = event.getHL7Message();
        HL7Application hl7App = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(msg.msh().getReceivingApplicationWithFacility(), true);
        if (hl7App == null) {
            return;
        }
        ArchiveHL7ApplicationExtension arcHL7App = (ArchiveHL7ApplicationExtension)hl7App.getHL7ApplicationExtension(ArchiveHL7ApplicationExtension.class);
        if (arcHL7App == null || !arcHL7App.hasHL7StudyRetentionPolicies()) {
            return;
        }
        String host = ReverseDNS.hostNameOf((InetAddress)event.getSocket().getInetAddress());
        HL7Fields hl7Fields = new HL7Fields(msg, hl7App.getHL7DefaultCharacterSet());
        arcHL7App.hl7StudyRetentionPolicies().sorted(Comparator.comparingInt(HL7StudyRetentionPolicy::getPriority).reversed()).filter(rule -> rule.getConditions().match(host, hl7Fields)).findFirst().ifPresent(policy -> this.apply(event, (HL7StudyRetentionPolicy)policy, hl7Fields));
    }

    private void apply(HL7ConnectionEvent event, HL7StudyRetentionPolicy policy, HL7Fields hl7Fields) {
        LOG.info("{}: Apply {}:", (Object)event.getSocket(), (Object)policy);
        IDWithIssuer pid = new IDWithIssuer(hl7Fields.get("PID-3", null));
        ArchiveDeviceExtension arcdev = (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
        ApplicationEntity ae = this.device.getApplicationEntity(policy.getAETitle(), true);
        QueryParam queryParam = this.queryParam(policy, ae);
        QueryContext queryCtx = this.queryService.newQueryContext(ae, queryParam);
        queryCtx.setQueryRetrieveLevel(QueryRetrieveLevel2.STUDY);
        queryCtx.setPatientIDs(new IDWithIssuer[]{pid});
        queryCtx.setQueryKeys(new Attributes(0));
        queryCtx.setReturnPrivate(true);
        try (Query query = this.queryService.createStudyQuery(queryCtx);){
            query.executeQuery(arcdev.getQueryFetchSize());
            while (query.hasMoreMatches()) {
                Attributes match = query.nextMatch();
                if (match == null) continue;
                this.updateExpirationDate(event, policy, match);
            }
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to apply {}:\n", new Object[]{event.getSocket(), policy, e});
        }
    }

    private QueryParam queryParam(HL7StudyRetentionPolicy policy, ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        if (policy.protectStudy()) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.UPDATEABLE, ExpirationState.FROZEN});
        } else {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.UPDATEABLE});
        }
        return queryParam;
    }

    private void updateExpirationDate(HL7ConnectionEvent event, HL7StudyRetentionPolicy policy, Attributes match) {
        StudyMgtContext ctx = this.studyService.createStudyMgtContextHL7(event.getSocket(), event.getHL7Message());
        String suid = match.getString(0x20000D);
        ctx.setStudyInstanceUID(suid);
        ctx.setExpirationExporterID(policy.getExporterID());
        ctx.setFreezeExpirationDate(policy.isFreezeExpirationDate());
        if (policy.protectStudy()) {
            ctx.setExpirationDate(null);
            this.updateExpirationDate(ctx, event);
        } else {
            LocalDate prevExpirationDate;
            LocalDate expirationDate = prevExpirationDate = this.studyExpirationDateOf(match);
            LocalDate retentionStartDate = policy.retentionStartDate(match);
            if (policy.getMinRetentionPeriod() != null) {
                LocalDate minExpirationDate = retentionStartDate.plus(policy.getMinRetentionPeriod());
                if (expirationDate == null || expirationDate.isBefore(minExpirationDate)) {
                    expirationDate = minExpirationDate;
                }
            }
            if (policy.getMaxRetentionPeriod() != null) {
                LocalDate maxExpirationDate = retentionStartDate.plus(policy.getMaxRetentionPeriod());
                if (expirationDate == null || expirationDate.isAfter(maxExpirationDate)) {
                    expirationDate = maxExpirationDate;
                }
            }
            if (expirationDate != prevExpirationDate) {
                ctx.setExpirationDate(expirationDate);
                this.updateExpirationDate(ctx, event);
            }
        }
    }

    private void updateExpirationDate(StudyMgtContext ctx, HL7ConnectionEvent event) {
        try {
            this.studyService.updateExpirationDate(ctx);
            LOG.info("{}: Update expiration date of Study[uid={}]", (Object)event.getSocket(), (Object)ctx.getStudyInstanceUID());
        }
        catch (Exception e) {
            LOG.warn("{}: Failed to update expiration date of Study[uid={}]:\n", new Object[]{event.getSocket(), ctx.getStudyInstanceUID(), e});
        }
    }

    private LocalDate studyExpirationDateOf(Attributes match) {
        String s = match.getString("DCM4CHEE Archive 5", 2004287523);
        return s != null ? LocalDate.parse(s, DateTimeFormatter.BASIC_ISO_DATE) : null;
    }
}

