/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impax.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.ws.WebServiceException;
import org.dcm4chee.arc.impax.report.ReportServiceProvider;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="impax/reports")
public class QueryImpaxReportRS {
    private static final Logger LOG = LoggerFactory.getLogger(QueryImpaxReportRS.class);
    @Context
    private HttpServletRequest request;
    @Inject
    private ReportServiceProvider service;

    @GET
    @NoCache
    @Path(value="/studies/{studyUID}")
    @Produces(value={"multipart/related;type=text/xml"})
    public MultipartRelatedOutput queryReportByStudyUid(@PathParam(value="studyUID") String studyUID) {
        List reports;
        this.logRequest();
        try {
            reports = this.service.queryReportByStudyUid(studyUID);
        }
        catch (WebServiceException e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString((Exception)((Object)e)), Response.Status.BAD_GATEWAY));
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
        if (reports.isEmpty()) {
            String errorMessage = "SR Reports not found for the study";
            LOG.warn("Response Status : Conflict. Error message : {}", (Object)errorMessage);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"errorMessage\":\"" + errorMessage + "\"}")).build());
        }
        try {
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            reports.forEach(report -> output.addPart(report, MediaType.TEXT_XML_TYPE));
            return output;
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

