/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.ian.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.ian.scu.IANSCU;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.query.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{aet}/rs")
public class IANSCURS {
    private static final Logger LOG = LoggerFactory.getLogger(IANSCURS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private Device device;
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private IANSCU ianSCU;
    @Inject
    private QueryService queryService;
    @PathParam(value="aet")
    private String aet;
    @Context
    private HttpServletRequest request;

    @POST
    @Path(value="/studies/{StudyInstanceUID}/ian/dicom:{externalAET}")
    @Produces(value={"application/json"})
    public Response studyIAN(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="externalAET") String externalAET) {
        return this.ian(studyUID, null, null, externalAET);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/ian/dicom:{externalAET}")
    @Produces(value={"application/json"})
    public Response seriesIAN(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="SeriesInstanceUID") String seriesUID, @PathParam(value="externalAET") String externalAET) {
        return this.ian(studyUID, seriesUID, null, externalAET);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/{SOPInstanceUID}/ian/dicom:{externalAET}")
    @Produces(value={"application/json"})
    public Response instanceIAN(@PathParam(value="StudyInstanceUID") String studyUID, @PathParam(value="SeriesInstanceUID") String seriesUID, @PathParam(value="SOPInstanceUID") String sopUID, @PathParam(value="externalAET") String externalAET) {
        return this.ian(studyUID, seriesUID, sopUID, externalAET);
    }

    private Response ian(String studyUID, String seriesUID, String sopUID, String externalAET) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (this.aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        Response.Status rspStatus = Response.Status.BAD_GATEWAY;
        try {
            ApplicationEntity remoteAE = this.aeCache.findApplicationEntity(externalAET);
            Attributes ian = this.queryService.createIAN(ae, studyUID, new String[]{seriesUID}, sopUID, null, null, null);
            if (ian == null) {
                return this.errResponse("No matching instances", Response.Status.NOT_FOUND);
            }
            DimseRSP dimseRSP = this.ianSCU.sendIANRQ(ae, remoteAE, UIDUtils.createUID(), ian);
            dimseRSP.next();
            if (dimseRSP.getCommand().getInt(2304, -1) == 0) {
                rspStatus = Response.Status.OK;
            }
            return Response.status((Response.Status)rspStatus).entity((Object)this.entity(ian, dimseRSP)).build();
        }
        catch (ConfigurationException e) {
            return this.errResponse(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (IOException e) {
            return this.errResponse(e.getMessage(), rspStatus);
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private StreamingOutput entity(Attributes ian, DimseRSP dimseRSP) {
        return out -> {
            try (JsonGenerator gen = Json.createGenerator((OutputStream)out);){
                JsonWriter writer = new JsonWriter(gen);
                gen.writeStartObject();
                writer.writeNotNullOrDef("status", (Object)TagUtils.shortToHexString((int)dimseRSP.getCommand().getInt(2304, -1)), null);
                writer.writeNotNullOrDef("error", (Object)dimseRSP.getCommand().getString(2306), null);
                writer.writeNotNullOrDef("instances", (Object)ian.getSequence(528661).stream().mapToInt(a -> a.getSequence(528793).size()).sum(), (Object)0);
                gen.writeEnd();
            }
        };
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse("No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet, Response.Status.NOT_FOUND)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }
}

