/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.dimse.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.pdu.AAbort;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/dimse/{RemoteAET}")
public class EchoRS {
    private static final Logger LOG = LoggerFactory.getLogger(EchoRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @Inject
    private DicomConfiguration conf;
    @Inject
    private Device device;
    @PathParam(value="AETitle")
    private String aet;
    @PathParam(value="RemoteAET")
    private String remoteAET;
    @Context
    private HttpServletRequest request;
    @QueryParam(value="host")
    private String host;
    @QueryParam(value="port")
    @Pattern(regexp="^[1-9]\\d{0,4}+$")
    private @Pattern(regexp="^[1-9]\\d{0,4}+$") String port;

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    private ApplicationEntity getRemoteApplicationEntity() {
        try {
            return this.conf.findApplicationEntity(this.remoteAET);
        }
        catch (ConfigurationException e) {
            throw new WebApplicationException(this.errResponse(e.getMessage(), Response.Status.NOT_FOUND));
        }
    }

    private Response errResponse(String msg, Response.Status status) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + msg + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private AAssociateRQ createAARQ() {
        AAssociateRQ aarq = new AAssociateRQ();
        aarq.addPresentationContextFor("1.2.840.10008.1.1", "1.2.840.10008.1.2");
        return aarq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    public StreamingOutput echo() {
        this.logRequest();
        int remotePort = EchoRS.parseInt(this.port);
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            throw new WebApplicationException(this.errResponse("No such Application Entity: " + this.aet, Response.Status.NOT_FOUND));
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity remote = this.host != null && remotePort > 0 ? this.createRemoteAE(remotePort) : this.getRemoteApplicationEntity();
        try {
            Association as = null;
            Result result = new Result();
            try {
                long t1 = System.currentTimeMillis();
                as = arcAE.getApplicationEntity().connect(remote, this.createAARQ());
                long t2 = System.currentTimeMillis();
                result.connectionTime = Long.toString(t2 - t1);
                try {
                    DimseRSP rsp = as.cecho();
                    try {
                        rsp.next();
                        t1 = System.currentTimeMillis();
                        result.echoTime = Long.toString(t1 - t2);
                    }
                    catch (IOException e) {
                        result.error(Result.Code.FailedToSendCEchoRQ, e);
                    }
                }
                catch (IOException e) {
                    result.error(Result.Code.FailedToReceiveCEchoRSP, e);
                }
            }
            catch (IncompatibleConnectionException e) {
                result.error(Result.Code.IncompatibleConnection, (Exception)((Object)e));
            }
            catch (AAssociateRJ e) {
                result.error(Result.Code.AssociationRejected, (Exception)((Object)e));
            }
            catch (IOException e) {
                result.error(Result.Code.FailedToConnect, e);
            }
            finally {
                if (as != null) {
                    try {
                        long t1 = System.currentTimeMillis();
                        as.release();
                        long t2 = System.currentTimeMillis();
                        result.releaseTime = Long.toString(t2 - t1);
                    }
                    catch (IOException e) {
                        result.error(Result.Code.FailedToRelease, e);
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new WebApplicationException(this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ApplicationEntity createRemoteAE(int remotePort) {
        Device device = new Device();
        device.setDeviceName(this.remoteAET.toLowerCase());
        device.setInstalled(true);
        Connection conn = new Connection();
        conn.setHostname(this.host);
        conn.setPort(remotePort);
        device.addConnection(conn);
        ApplicationEntity remoteAE = new ApplicationEntity();
        remoteAE.setAETitle(this.remoteAET);
        remoteAE.addConnection(conn);
        device.addApplicationEntity(remoteAE);
        return remoteAE;
    }

    private static int parseInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private static class Result
    implements StreamingOutput {
        Code code = Code.Success;
        Exception exception;
        String connectionTime;
        String echoTime;
        String releaseTime;

        private Result() {
        }

        void error(Code code, Exception e) {
            if (this.exception == null) {
                this.code = code;
                this.exception = e;
            }
        }

        public void write(OutputStream out) {
            JsonGenerator gen = Json.createGenerator((OutputStream)out);
            JsonWriter writer = new JsonWriter(gen);
            gen.writeStartObject();
            writer.writeNotNullOrDef("result", (Object)Integer.toString(this.code.ordinal()), null);
            if (this.exception != null) {
                writer.writeNotNullOrDef("errorMessage", (Object)this.code.errorMessage(this.exception), null);
            }
            writer.writeNotNullOrDef("connectionTime", (Object)this.connectionTime, null);
            writer.writeNotNullOrDef("echoTime", (Object)this.echoTime, null);
            writer.writeNotNullOrDef("releaseTime", (Object)this.releaseTime, null);
            gen.writeEnd();
            gen.flush();
        }

        static enum Code {
            Success(null),
            IncompatibleConnection("Incompatible Connection: "),
            FailedToConnect("Failed to connect: "),
            AssociationRejected("Association rejected: "),
            FailedToSendCEchoRQ("Failed to send C-ECHO-RSP: "),
            FailedToReceiveCEchoRSP("Failed to receive C-ECHO-RSP: "),
            FailedToRelease("Failed to release association: ");

            final String prefix;

            private Code(String prefix) {
                this.prefix = prefix;
            }

            String errorMessage(Exception ex) {
                return this.prefix + (Serializable)(ex instanceof IncompatibleConnectionException || ex instanceof AAssociateRJ || ex instanceof AAbort ? ex.getMessage() : ex);
            }
        }
    }
}

