/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.conf.rs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.dcm4che3.conf.json.JsonWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="aets")
@RequestScoped
public class QueryAETs {
    private static final Logger LOG = LoggerFactory.getLogger(QueryAETs.class);
    @Inject
    private Device device;
    @Context
    private HttpServletRequest request;

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response query() {
        this.logRequest();
        try {
            return Response.ok(out -> {
                JsonGenerator gen = Json.createGenerator((OutputStream)out);
                gen.writeStartArray();
                for (ApplicationEntity ae : this.sortedApplicationEntities()) {
                    this.writeTo(ae, gen);
                }
                gen.writeEnd();
                gen.flush();
            }).build();
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeTo(ApplicationEntity ae, JsonGenerator gen) {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
        JsonWriter writer = new JsonWriter(gen);
        gen.writeStartObject();
        gen.write("dicomAETitle", ae.getAETitle());
        writer.writeNotNullOrDef("dicomDescription", (Object)ae.getDescription(), null);
        writer.writeNotEmpty("dcmOtherAETitle", (Object[])ae.getOtherAETitles(), (Object[])new String[0]);
        if (arcAE != null) {
            QueryRetrieveView queryRetrieveView = arcAE.getQueryRetrieveView();
            writer.writeNotDef("dcmHideNotRejectedInstances", queryRetrieveView != null && queryRetrieveView.isHideNotRejectedInstances(), false);
            writer.writeNotNullOrDef("dcmAllowDeletePatient", (Object)arcAE.allowDeletePatient(), null);
            writer.writeNotNullOrDef("dcmAllowDeleteStudyPermanently", (Object)arcAE.allowDeleteStudy(), null);
        }
        gen.writeEnd();
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.request.getRequestURI(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private ApplicationEntity[] sortedApplicationEntities() {
        return (ApplicationEntity[])this.device.getApplicationEntities().stream().sorted(Comparator.comparing(ApplicationEntity::getAETitle)).toArray(ApplicationEntity[]::new);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

