/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stow.client.impl;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.enterprise.event.Event;
import javax.json.Json;
import javax.json.JsonException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.json.JSONReader;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.ws.rs.MediaTypes;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.stream.DicomObjectOutput;
import org.dcm4chee.arc.rs.util.MediaTypeUtils;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.stow.client.StowTask;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StowTaskImpl
implements StowTask {
    private static final Logger LOG = LoggerFactory.getLogger(StowTaskImpl.class);
    private final Event<RetrieveContext> retrieveStart;
    private final Event<RetrieveContext> retrieveEnd;
    private final RetrieveContext ctx;
    private final BlockingQueue<WrappedInstanceLocations> matches = new LinkedBlockingQueue<WrappedInstanceLocations>();
    private final ResteasyWebTarget target;
    private final String authorization;
    private final Collection<String> acceptableTransferSyntaxes;
    private final int concurrency;
    private final Semaphore semaphore;
    private volatile boolean canceled;

    public StowTaskImpl(RetrieveContext ctx, Event<RetrieveContext> retrieveStart, Event<RetrieveContext> retrieveEnd, ResteasyWebTarget target, String authorization, Collection<String> acceptableTransferSyntaxes, int concurrency) {
        this.ctx = ctx;
        this.retrieveStart = retrieveStart;
        this.retrieveEnd = retrieveEnd;
        this.target = target;
        this.authorization = authorization;
        this.acceptableTransferSyntaxes = acceptableTransferSyntaxes;
        this.concurrency = concurrency;
        this.semaphore = concurrency > 1 ? new Semaphore(concurrency) : null;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void run() {
        this.retrieveStart.fire((Object)this.ctx);
        try {
            for (InstanceLocations match : this.ctx.getMatches()) {
                if (this.ctx.copyToRetrieveCache(match)) continue;
                this.matches.offer(new WrappedInstanceLocations(match));
            }
            this.ctx.copyToRetrieveCache(null);
            this.matches.offer(new WrappedInstanceLocations(null));
            this.runStoreOperations();
        }
        finally {
            if (this.semaphore != null) {
                try {
                    this.semaphore.acquire(this.concurrency);
                }
                catch (InterruptedException e) {
                    LOG.warn("{}: failed to wait for pending responses:\n", (Object)this.target, (Object)e);
                }
            }
            this.target.getResteasyClient().close();
            this.ctx.getRetrieveService().updateLocations(this.ctx);
            SafeClose.close((Closeable)this.ctx);
        }
        this.retrieveEnd.fire((Object)this.ctx);
    }

    private void runStoreOperations() {
        try {
            InstanceLocations match;
            while (!this.canceled && (match = this.matches.take().instanceLocations) != null) {
                this.store(match);
            }
            while (!this.canceled && (match = this.ctx.copiedToRetrieveCache()) != null) {
                this.store(match);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{}: failed to fetch next match from queue:\n", (Object)this.target, (Object)e);
        }
    }

    private void store(final InstanceLocations inst) {
        MultipartRelatedOutput output = new MultipartRelatedOutput();
        output.addPart((Object)new DicomObjectOutput(this.ctx, inst, this.acceptableTransferSyntaxes), MediaTypes.applicationDicomWithTransferSyntax((String)MediaTypeUtils.selectTransferSyntax(this.acceptableTransferSyntaxes, (String)((Location)inst.getLocations().get(0)).getTransferSyntaxUID())));
        Entity entity = Entity.entity((Object)output, (MediaType)MediaTypes.MULTIPART_RELATED_APPLICATION_DICOM_TYPE);
        Invocation.Builder request = this.target.request(new String[]{"application/dicom+json"});
        if (this.authorization != null) {
            request.header("Authorization", (Object)this.authorization);
        }
        InvocationCallback<Response> callback = new InvocationCallback<Response>(){

            public void completed(Response response) {
                StowTaskImpl.this.onStowRsp(StowTaskImpl.this.toAttributes(response));
                response.close();
                if (StowTaskImpl.this.semaphore != null) {
                    StowTaskImpl.this.semaphore.release();
                }
            }

            public void failed(Throwable e) {
                StowTaskImpl.this.ctx.incrementFailed();
                StowTaskImpl.this.ctx.addFailedMatch(inst);
                LOG.warn("{}: failed to send {} to {}:\n", new Object[]{StowTaskImpl.this.target, inst, StowTaskImpl.this.ctx.getDestinationWebApp(), e});
                if (StowTaskImpl.this.semaphore != null) {
                    StowTaskImpl.this.semaphore.release();
                }
            }
        };
        if (this.async()) {
            request.async().post(entity, (InvocationCallback)callback);
        } else {
            try {
                callback.completed((Object)request.post(entity));
            }
            catch (Throwable e) {
                callback.failed(e);
            }
        }
    }

    private boolean async() {
        if (this.semaphore != null) {
            try {
                this.semaphore.acquire();
                return true;
            }
            catch (InterruptedException e) {
                LOG.info("{}: failed to wait for pending responses:\n", (Object)this.target, (Object)e);
            }
        }
        return false;
    }

    private void onStowRsp(Attributes rsp) {
        if (rsp == null) {
            return;
        }
        if (rsp.contains(528792)) {
            this.ctx.incrementFailed();
            return;
        }
        Attributes refSOP = rsp.getNestedDataset(528793);
        if (refSOP.contains(528790)) {
            this.ctx.incrementWarning();
        } else {
            this.ctx.incrementCompleted();
        }
    }

    private Attributes toAttributes(Response response) {
        Attributes rsp = null;
        try {
            rsp = new JSONReader(Json.createParser((Reader)new InputStreamReader((InputStream)response.readEntity(InputStream.class), StandardCharsets.UTF_8))).readDataset(null);
        }
        catch (JsonException e) {
            LOG.info("Invalid JSON payload");
            this.ctx.incrementFailed();
        }
        catch (Exception e) {
            this.ctx.incrementFailed();
        }
        return rsp;
    }

    private static class WrappedInstanceLocations {
        final InstanceLocations instanceLocations;

        private WrappedInstanceLocations(InstanceLocations instanceLocations) {
            this.instanceLocations = instanceLocations;
        }
    }
}

