/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.store.scu.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4chee.arc.entity.Location;
import org.dcm4chee.arc.retrieve.RetrieveContext;
import org.dcm4chee.arc.retrieve.RetrieveEnd;
import org.dcm4chee.arc.retrieve.RetrieveStart;
import org.dcm4chee.arc.store.InstanceLocations;
import org.dcm4chee.arc.store.scu.CStoreSCU;
import org.dcm4chee.arc.store.scu.impl.RetrieveTaskImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CStoreSCUImpl
implements CStoreSCU {
    static final Logger LOG = LoggerFactory.getLogger(CStoreSCUImpl.class);
    @Inject
    @RetrieveStart
    private Event<RetrieveContext> retrieveStart;
    @Inject
    @RetrieveEnd
    private Event<RetrieveContext> retrieveEnd;

    private Association openAssociation(RetrieveContext ctx) throws DicomServiceException {
        try {
            try {
                ApplicationEntity localAE = ctx.getLocalApplicationEntity();
                Association storeas = localAE.connect(ctx.getDestinationAE(), this.createAARQ(ctx));
                Iterator iter = ctx.getMatches().iterator();
                while (iter.hasNext()) {
                    InstanceLocations inst = (InstanceLocations)iter.next();
                    if (!storeas.getTransferSyntaxesFor(inst.getSopClassUID()).isEmpty()) continue;
                    iter.remove();
                    ctx.incrementFailed();
                    ctx.addFailedMatch(inst);
                    LOG.info("{}: failed to send {} to {} - no Presentation Context accepted", new Object[]{ctx.getRequestAssociation(), inst, ctx.getDestinationAETitle()});
                }
                return storeas;
            }
            catch (Exception e) {
                throw new DicomServiceException(42754, (Throwable)e);
            }
        }
        catch (DicomServiceException e) {
            ctx.setException((Throwable)e);
            this.retrieveStart.fire((Object)ctx);
            throw e;
        }
    }

    private AAssociateRQ createAARQ(RetrieveContext ctx) {
        AAssociateRQ aarq = new AAssociateRQ();
        ApplicationEntity localAE = ctx.getLocalApplicationEntity();
        ApplicationEntity destAE = ctx.getDestinationAE();
        if (!localAE.isMasqueradeCallingAETitle(ctx.getDestinationAETitle())) {
            aarq.setCallingAET(ctx.getCallingAET());
        }
        boolean noDestinationRestriction = destAE.getTransferCapabilitiesWithRole(TransferCapability.Role.SCP).isEmpty();
        for (InstanceLocations inst : ctx.getMatches()) {
            TransferCapability destTC;
            String cuid = inst.getSopClassUID();
            TransferCapability localTC = localAE.getTransferCapabilityFor(cuid, TransferCapability.Role.SCU);
            TransferCapability transferCapability = destTC = noDestinationRestriction ? null : destAE.getTransferCapabilityFor(cuid, TransferCapability.Role.SCP);
            if (!aarq.containsPresentationContextFor(cuid) && !this.isVideo(inst)) {
                if (noDestinationRestriction) {
                    CStoreSCUImpl.addPresentationContext(aarq, cuid, "1.2.840.10008.1.2", localTC);
                    CStoreSCUImpl.addPresentationContext(aarq, cuid, "1.2.840.10008.1.2.1", localTC);
                } else {
                    CStoreSCUImpl.addPresentationContext(aarq, cuid, "1.2.840.10008.1.2", localTC, destTC);
                    CStoreSCUImpl.addPresentationContext(aarq, cuid, "1.2.840.10008.1.2.1", localTC, destTC);
                }
            }
            for (Location location : inst.getLocations()) {
                String tsuid = location.getTransferSyntaxUID();
                if (tsuid.equals("1.2.840.10008.1.2") || tsuid.equals("1.2.840.10008.1.2.1")) continue;
                if (noDestinationRestriction) {
                    CStoreSCUImpl.addPresentationContext(aarq, cuid, tsuid, localTC);
                    continue;
                }
                CStoreSCUImpl.addPresentationContext(aarq, cuid, tsuid, localTC, destTC);
            }
        }
        return aarq;
    }

    private boolean isVideo(InstanceLocations inst) {
        switch (((Location)inst.getLocations().get(0)).getTransferSyntaxUID()) {
            case "1.2.840.10008.1.2.4.100": 
            case "1.2.840.10008.1.2.4.100.1": 
            case "1.2.840.10008.1.2.4.101": 
            case "1.2.840.10008.1.2.4.101.1": 
            case "1.2.840.10008.1.2.4.102": 
            case "1.2.840.10008.1.2.4.102.1": 
            case "1.2.840.10008.1.2.4.103": 
            case "1.2.840.10008.1.2.4.103.1": 
            case "1.2.840.10008.1.2.4.104": 
            case "1.2.840.10008.1.2.4.104.1": 
            case "1.2.840.10008.1.2.4.105": 
            case "1.2.840.10008.1.2.4.105.1": 
            case "1.2.840.10008.1.2.4.106": 
            case "1.2.840.10008.1.2.4.106.1": 
            case "1.2.840.10008.1.2.4.107": 
            case "1.2.840.10008.1.2.4.108": {
                return true;
            }
        }
        return false;
    }

    private static void addPresentationContext(AAssociateRQ aarq, String cuid, String ts, TransferCapability tc1, TransferCapability tc2) {
        if (tc1 != null && tc1.containsTransferSyntax(ts)) {
            CStoreSCUImpl.addPresentationContext(aarq, cuid, ts, tc2);
        }
    }

    private static void addPresentationContext(AAssociateRQ aarq, String cuid, String ts, TransferCapability tc) {
        if (tc != null && tc.containsTransferSyntax(ts)) {
            aarq.addPresentationContextFor(cuid, ts);
        }
    }

    @Override
    public RetrieveTask newRetrieveTaskSTORE(RetrieveContext ctx) throws DicomServiceException {
        return new RetrieveTaskImpl(ctx, this.retrieveStart, this.retrieveEnd, this.openMultipleAssocations(ctx));
    }

    @Override
    public RetrieveTask newRetrieveTaskMOVE(Association as, PresentationContext pc, Attributes rq, RetrieveContext ctx) throws DicomServiceException {
        RetrieveTaskImpl retrieveTask = new RetrieveTaskImpl(ctx, this.retrieveStart, this.retrieveEnd, this.openMultipleAssocations(ctx));
        retrieveTask.setRequestAssociation(Dimse.C_MOVE_RQ, as, pc, rq);
        return retrieveTask;
    }

    private Association[] openMultipleAssocations(RetrieveContext ctx) throws DicomServiceException {
        Association storeas = this.openAssociation(ctx);
        ctx.setStoreAssociation(storeas);
        Association[] storeass = new Association[Math.min(ctx.getArchiveAEExtension().maxStoreAssociationsTo(ctx.getDestinationAETitle()), Math.max(ctx.getNumberOfMatches(), 1))];
        storeass[0] = storeas;
        ApplicationEntity localAE = ctx.getLocalApplicationEntity();
        ApplicationEntity destinationAE = ctx.getDestinationAE();
        AAssociateRQ acrq = storeas.getAAssociateRQ();
        int count = 0;
        while (++count < storeass.length) {
            try {
                storeass[count] = localAE.connect(destinationAE, acrq);
            }
            catch (Exception e) {
                LOG.warn("failed to open additional association to {}:\n", (Object)ctx.getDestinationAETitle());
                return Arrays.copyOf(storeass, count);
            }
        }
        return storeass;
    }

    @Override
    public RetrieveTask newRetrieveTaskGET(Association as, PresentationContext pc, Attributes rq, RetrieveContext ctx) throws DicomServiceException {
        ctx.setStoreAssociation(as);
        RetrieveTaskImpl retrieveTask = new RetrieveTaskImpl(ctx, this.retrieveStart, this.retrieveEnd, as);
        retrieveTask.setRequestAssociation(Dimse.C_GET_RQ, as, pc, rq);
        return retrieveTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes store(ApplicationEntity localAE, ApplicationEntity remoteAE, int priority, Attributes inst) throws Exception {
        String cuid = inst.getString(524310);
        String iuid = inst.getString(524312);
        Association as = localAE.connect(remoteAE, this.createAARQ(localAE, remoteAE.getAETitle(), cuid));
        try {
            DimseRSP rsp = as.cstore(cuid, iuid, priority, (DataWriter)new DataWriterAdapter(inst), this.selectTransferSyntax(as.getTransferSyntaxesFor(cuid)));
            rsp.next();
            Attributes attributes = rsp.getCommand();
            return attributes;
        }
        finally {
            as.release();
        }
    }

    private String selectTransferSyntax(Set<String> accepted) {
        return accepted.contains("1.2.840.10008.1.2.1") ? "1.2.840.10008.1.2.1" : "1.2.840.10008.1.2";
    }

    private AAssociateRQ createAARQ(ApplicationEntity localAE, String calledAET, String cuid) {
        AAssociateRQ aarq = new AAssociateRQ();
        if (!localAE.isMasqueradeCallingAETitle(calledAET)) {
            aarq.setCallingAET(localAE.getAETitle());
        }
        aarq.addPresentationContextFor(cuid, "1.2.840.10008.1.2.1");
        aarq.addPresentationContextFor(cuid, "1.2.840.10008.1.2");
        return aarq;
    }
}

