/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.storage.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.dcm4chee.arc.storage.CacheInputStream;
import org.dcm4chee.arc.storage.cloud.Uploader;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.ObjectMetadataBuilder;
import org.jclouds.s3.options.PutObjectOptions;

class S3Uploader
extends CacheInputStream
implements Uploader {
    S3Uploader() {
    }

    @Override
    public void upload(BlobStoreContext context, InputStream in, long length, BlobStore blobStore, String container, String storagePath) throws IOException {
        if (this.fillBuffers(in)) {
            this.uploadMultipleParts(context, in, container, storagePath);
        } else {
            this.uploadSinglePart(blobStore, container, storagePath);
        }
    }

    private void uploadSinglePart(BlobStore blobStore, String container, String storagePath) {
        Blob blob = blobStore.blobBuilder(storagePath).payload(this.createPayload()).build();
        blobStore.putBlob(container, blob);
    }

    private Payload createPayload() {
        InputStreamPayload payload = new InputStreamPayload((InputStream)((Object)this));
        payload.getContentMetadata().setContentLength(new Long(this.available()));
        return payload;
    }

    private void uploadMultipleParts(BlobStoreContext context, InputStream in, String container, String storagePath) throws IOException {
        S3Client client = (S3Client)context.unwrapApi(S3Client.class);
        String uploadId = client.initiateMultipartUpload(container, ObjectMetadataBuilder.create().key(storagePath).build(), new PutObjectOptions[0]);
        HashMap<Integer, String> parts = new HashMap<Integer, String>();
        int partNumber = 1;
        do {
            parts.put(partNumber, client.uploadPart(container, storagePath, partNumber, uploadId, this.createPayload()));
            ++partNumber;
        } while (this.fillBuffers(in));
        if (this.available() > 0) {
            parts.put(partNumber, client.uploadPart(container, storagePath, partNumber, uploadId, this.createPayload()));
        }
        client.completeMultipartUpload(container, storagePath, uploadId, parts);
    }
}

