/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.stgcmt.rs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Pattern;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.StorageVerificationPolicy;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.keycloak.KeycloakContext;
import org.dcm4chee.arc.qmgt.TaskManager;
import org.dcm4chee.arc.query.Query;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.QueryAttributes;
import org.dcm4chee.arc.query.util.QueryParam;
import org.dcm4chee.arc.stgcmt.StgCmtManager;
import org.dcm4chee.arc.validation.ParseDateTime;
import org.dcm4chee.arc.validation.constraints.InvokeValidate;
import org.dcm4chee.arc.validation.constraints.ValidValueOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Path(value="aets/{AETitle}/rs")
@InvokeValidate(type=StgVerMatchingRS.class)
public class StgVerMatchingRS {
    private static final Logger LOG = LoggerFactory.getLogger(StgVerMatchingRS.class);
    private static final String SUPER_USER_ROLE = "super-user-role";
    @PathParam(value="AETitle")
    private String aet;
    @Context
    private HttpServletRequest request;
    @Context
    private UriInfo uriInfo;
    @Inject
    private Device device;
    @Inject
    private QueryService queryService;
    @Inject
    private StgCmtManager stgCmtMgr;
    @Inject
    private TaskManager taskManager;
    @Inject
    private RunInTransaction runInTx;
    @javax.ws.rs.QueryParam(value="fuzzymatching")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String fuzzymatching;
    @javax.ws.rs.QueryParam(value="incomplete")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String incomplete;
    @javax.ws.rs.QueryParam(value="retrievefailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String retrievefailed;
    @javax.ws.rs.QueryParam(value="storageVerificationFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationFailed;
    @javax.ws.rs.QueryParam(value="metadataUpdateFailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String metadataUpdateFailed;
    @javax.ws.rs.QueryParam(value="compressionfailed")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String compressionfailed;
    @javax.ws.rs.QueryParam(value="ExpirationDate")
    private String expirationDate;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET")
    private String externalRetrieveAET;
    @javax.ws.rs.QueryParam(value="ExternalRetrieveAET!")
    private String externalRetrieveAETNot;
    @javax.ws.rs.QueryParam(value="patientVerificationStatus")
    @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED")
    private @Pattern(regexp="UNVERIFIED|VERIFIED|NOT_FOUND|VERIFICATION_FAILED") String patientVerificationStatus;
    @javax.ws.rs.QueryParam(value="batchID")
    private String batchID;
    @javax.ws.rs.QueryParam(value="scheduledTime")
    @ValidValueOf(type=ParseDateTime.class)
    private String scheduledTime;
    @javax.ws.rs.QueryParam(value="storageVerificationPolicy")
    @Pattern(regexp="DB_RECORD_EXISTS|OBJECT_EXISTS|OBJECT_SIZE|OBJECT_FETCH|OBJECT_CHECKSUM|S3_MD5SUM")
    private @Pattern(regexp="DB_RECORD_EXISTS|OBJECT_EXISTS|OBJECT_SIZE|OBJECT_FETCH|OBJECT_CHECKSUM|S3_MD5SUM") String storageVerificationPolicy;
    @javax.ws.rs.QueryParam(value="storageVerificationUpdateLocationStatus")
    @Pattern(regexp="true|false")
    private @Pattern(regexp="true|false") String storageVerificationUpdateLocationStatus;
    @javax.ws.rs.QueryParam(value="storageVerificationStorageID")
    private List<String> storageVerificationStorageIDs;
    @javax.ws.rs.QueryParam(value="StudySizeInKB")
    @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}")
    private @Pattern(regexp="\\d{1,9}(-\\d{0,9})?|-\\d{1,9}") String studySizeInKB;
    @javax.ws.rs.QueryParam(value="ExpirationState")
    @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT")
    private @Pattern(regexp="UPDATEABLE|FROZEN|REJECTED|EXPORT_SCHEDULED|FAILED_TO_EXPORT|FAILED_TO_REJECT") String expirationState;

    @POST
    @Path(value="/studies/stgver")
    @Produces(value={"application/json"})
    public Response verifyStorageOfStudies() {
        return this.verifyStorageOf(this.aet, "verifyStorageOfStudies", QueryRetrieveLevel2.STUDY, null, null);
    }

    @POST
    @Path(value="/series/stgver")
    @Produces(value={"application/json"})
    public Response verifyStorageOfSeries() {
        return this.verifyStorageOf(this.aet, "verifyStorageOfSeries", QueryRetrieveLevel2.SERIES, null, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/stgver")
    @Produces(value={"application/json"})
    public Response verifyStorageOfSeriesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        return this.verifyStorageOf(this.aet, "verifyStorageOfSeriesOfStudy", QueryRetrieveLevel2.SERIES, studyInstanceUID, null);
    }

    @POST
    @Path(value="/instances/stgver")
    @Produces(value={"application/json"})
    public Response verifyStorageOfInstances() {
        return this.verifyStorageOf(this.aet, "verifyStorageOfInstances", QueryRetrieveLevel2.IMAGE, null, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/instances/stgver")
    @Produces(value={"application/json"})
    public Response verifyStorageOfInstancesOfStudy(@PathParam(value="StudyInstanceUID") String studyInstanceUID) {
        return this.verifyStorageOf(this.aet, "verifyStorageOfInstancesOfStudy", QueryRetrieveLevel2.IMAGE, studyInstanceUID, null);
    }

    @POST
    @Path(value="/studies/{StudyInstanceUID}/series/{SeriesInstanceUID}/instances/stgver")
    @Produces(value={"application/json"})
    public Response verifyStorageOfInstancesOfSeries(@PathParam(value="StudyInstanceUID") String studyInstanceUID, @PathParam(value="SeriesInstanceUID") String seriesInstanceUID) {
        return this.verifyStorageOf(this.aet, "verifyStorageOfInstancesOfSeries", QueryRetrieveLevel2.IMAGE, studyInstanceUID, seriesInstanceUID);
    }

    public String toString() {
        String requestURI = this.request.getRequestURI();
        String queryString = this.request.getQueryString();
        return queryString == null ? requestURI : requestURI + "?" + queryString;
    }

    public void validate() {
        this.logRequest();
        new QueryAttributes(this.uriInfo, null);
    }

    private Date scheduledTime() {
        if (this.scheduledTime != null) {
            try {
                return new SimpleDateFormat("yyyyMMddhhmmss").parse(this.scheduledTime);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
        return new Date();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Response verifyStorageOf(String aet, String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, String seriesInstanceUID) {
        this.logRequest();
        ArchiveAEExtension arcAE = this.getArchiveAE();
        if (arcAE == null) {
            return this.errResponse(Response.Status.NOT_FOUND, "No such Application Entity: " + aet);
        }
        this.validateAcceptedUserRoles(arcAE);
        ApplicationEntity ae = arcAE.getApplicationEntity();
        if (aet.equals(ae.getAETitle())) {
            this.validateWebAppServiceClass();
        }
        try {
            String warning;
            int count;
            QueryContext ctx = this.queryContext(method, qrlevel, studyInstanceUID, seriesInstanceUID, ae);
            Response.Status status = Response.Status.ACCEPTED;
            try (Query query = this.queryService.createQuery(ctx);){
                int queryMaxNumberOfResults = ctx.getArchiveAEExtension().queryMaxNumberOfResults();
                if (queryMaxNumberOfResults > 0 && !ctx.containsUniqueKey() && query.fetchCount() > (long)queryMaxNumberOfResults) {
                    Response response = this.errResponse(Response.Status.BAD_REQUEST, "Request entity too large");
                    return response;
                }
                StgVerMatchingObjects stgVerMatchingObjects = new StgVerMatchingObjects(aet, qrlevel, query, status);
                this.runInTx.execute((Runnable)stgVerMatchingObjects);
                count = stgVerMatchingObjects.getCount();
                status = stgVerMatchingObjects.getStatus();
                warning = stgVerMatchingObjects.getWarning();
            }
            Response.ResponseBuilder builder = Response.status((Response.Status)status);
            if (warning == null) return builder.entity((Object)("{\"count\":" + count + "}")).build();
            LOG.warn("Response {} caused by {}", (Object)status, (Object)warning);
            builder.header("Warning", (Object)warning);
            return builder.entity((Object)("{\"count\":" + count + "}")).build();
        }
        catch (IllegalStateException e) {
            return this.errResponse(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (Exception e) {
            return this.errResponseAsTextPlain(this.exceptionAsString(e), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void logRequest() {
        LOG.info("Process {} {} from {}@{}", new Object[]{this.request.getMethod(), this.toString(), this.request.getRemoteUser(), this.request.getRemoteHost()});
    }

    private Response errResponse(Response.Status status, String message) {
        return this.errResponseAsTextPlain("{\"errorMessage\":\"" + message + "\"}", status);
    }

    private Response errResponseAsTextPlain(String errorMsg, Response.Status status) {
        LOG.warn("Response {} caused by {}", (Object)status, (Object)errorMsg);
        return Response.status((Response.Status)status).entity((Object)errorMsg).type("text/plain").build();
    }

    private String exceptionAsString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private QueryContext queryContext(String method, QueryRetrieveLevel2 qrlevel, String studyInstanceUID, String seriesInstanceUID, ApplicationEntity ae) {
        QueryContext ctx = this.queryService.newQueryContextQIDO(HttpServletRequestInfo.valueOf((HttpServletRequest)this.request), method, this.aet, ae, this.queryParam(ae));
        ctx.setQueryRetrieveLevel(qrlevel);
        QueryAttributes queryAttrs = new QueryAttributes(this.uriInfo, null);
        Attributes keys = queryAttrs.getQueryKeys();
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        if (studyInstanceUID != null) {
            keys.setString(0x20000D, VR.UI, studyInstanceUID);
        }
        if (seriesInstanceUID != null) {
            keys.setString(0x20000E, VR.UI, seriesInstanceUID);
        }
        ctx.setQueryKeys(keys);
        Attributes returnKeys = new Attributes(3);
        returnKeys.setNull(0x20000D, VR.UI);
        switch (qrlevel) {
            case IMAGE: {
                returnKeys.setNull(524312, VR.UI);
            }
            case SERIES: {
                returnKeys.setNull(0x20000E, VR.UI);
            }
        }
        ctx.setReturnKeys(returnKeys);
        return ctx;
    }

    private QueryParam queryParam(ApplicationEntity ae) {
        QueryParam queryParam = new QueryParam(ae);
        queryParam.setCombinedDatetimeMatching(true);
        queryParam.setFuzzySemanticMatching(Boolean.parseBoolean(this.fuzzymatching));
        queryParam.setIncomplete(Boolean.parseBoolean(this.incomplete));
        queryParam.setRetrieveFailed(Boolean.parseBoolean(this.retrievefailed));
        queryParam.setStorageVerificationFailed(Boolean.parseBoolean(this.storageVerificationFailed));
        queryParam.setMetadataUpdateFailed(Boolean.parseBoolean(this.metadataUpdateFailed));
        queryParam.setCompressionFailed(Boolean.parseBoolean(this.compressionfailed));
        queryParam.setExternalRetrieveAET(this.externalRetrieveAET);
        queryParam.setExternalRetrieveAETNot(this.externalRetrieveAETNot);
        queryParam.setExpirationDate(this.expirationDate);
        if (this.patientVerificationStatus != null) {
            queryParam.setPatientVerificationStatus(Patient.VerificationStatus.valueOf((String)this.patientVerificationStatus));
        }
        queryParam.setStudySizeRange(this.studySizeInKB);
        if (this.expirationState != null) {
            queryParam.setExpirationState(new ExpirationState[]{ExpirationState.valueOf((String)this.expirationState)});
        }
        return queryParam;
    }

    private void validateAcceptedUserRoles(ArchiveAEExtension arcAE) {
        KeycloakContext keycloakContext = KeycloakContext.valueOf((HttpServletRequest)this.request);
        if (keycloakContext.isSecured() && !keycloakContext.isUserInRole(System.getProperty(SUPER_USER_ROLE)) && !arcAE.isAcceptedUserRole(keycloakContext.getRoles())) {
            throw new WebApplicationException("Application Entity " + arcAE.getApplicationEntity().getAETitle() + " does not list role of accessing user", Response.Status.FORBIDDEN);
        }
    }

    private void validateWebAppServiceClass() {
        this.device.getWebApplications().stream().filter(webApp -> this.request.getRequestURI().startsWith(webApp.getServicePath()) && Arrays.asList(webApp.getServiceClasses()).contains(WebApplication.ServiceClass.DCM4CHEE_ARC_AET)).findFirst().orElseThrow(() -> new WebApplicationException(this.errResponse(Response.Status.NOT_FOUND, "No Web Application with DCM4CHEE_ARC_AET service class found for Application Entity: " + this.aet)));
    }

    private ArchiveAEExtension getArchiveAE() {
        ApplicationEntity ae = this.device.getApplicationEntity(this.aet, true);
        return ae == null || !ae.isInstalled() ? null : (ArchiveAEExtension)ae.getAEExtension(ArchiveAEExtension.class);
    }

    class StgVerMatchingObjects
    implements Runnable {
        private int count;
        private final String aet;
        private final QueryRetrieveLevel2 qrLevel;
        private final Query query;
        private final Date scheduledTime;
        private Response.Status status;
        private String warning;

        StgVerMatchingObjects(String aet, QueryRetrieveLevel2 qrLevel, Query query, Response.Status status) {
            this.scheduledTime = StgVerMatchingRS.this.scheduledTime();
            this.aet = aet;
            this.qrLevel = qrLevel;
            this.query = query;
            this.status = status;
        }

        int getCount() {
            return this.count;
        }

        Response.Status getStatus() {
            return this.status;
        }

        String getWarning() {
            return this.warning;
        }

        @Override
        public void run() {
            try {
                this.query.executeQuery(((ArchiveDeviceExtension)StgVerMatchingRS.this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class)).getQueryFetchSize());
                while (this.query.hasMoreMatches()) {
                    Attributes match = this.query.nextMatch();
                    if (match == null) continue;
                    HttpServletRequestInfo httpServletRequestInfo = HttpServletRequestInfo.valueOf((HttpServletRequest)StgVerMatchingRS.this.request);
                    if (!StgVerMatchingRS.this.stgCmtMgr.scheduleStgVerTask(this.aet, this.qrLevel, httpServletRequestInfo, match.getString(0x20000D), match.getString(0x20000E), match.getString(524312), StgVerMatchingRS.this.batchID, this.scheduledTime, StgVerMatchingRS.this.storageVerificationPolicy != null ? StorageVerificationPolicy.valueOf((String)StgVerMatchingRS.this.storageVerificationPolicy) : null, StgVerMatchingRS.this.storageVerificationUpdateLocationStatus != null ? Boolean.valueOf(StgVerMatchingRS.this.storageVerificationUpdateLocationStatus) : null, StgVerMatchingRS.this.storageVerificationStorageIDs.toArray(StringUtils.EMPTY_STRING))) continue;
                    ++this.count;
                }
            }
            catch (Exception e) {
                this.warning = e.getMessage();
                this.status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
    }
}

