/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.impl;

import java.io.IOException;
import java.net.InetAddress;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationHandler;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.KeycloakClient;
import org.dcm4che3.net.pdu.AAssociateAC;
import org.dcm4che3.net.pdu.AAssociateRJ;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.UserIdentityAC;
import org.dcm4che3.net.pdu.UserIdentityRQ;
import org.dcm4che3.util.StringUtils;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.keycloak.AccessTokenRequestor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ArchiveAssociationHandler
extends AssociationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveAssociationHandler.class);
    @Inject
    private IApplicationEntityCache aeCache;
    @Inject
    private AccessTokenRequestor accessTokenRequestor;

    protected AAssociateAC makeAAssociateAC(Association as, AAssociateRQ rq, UserIdentityAC userIdentity) throws IOException {
        ArchiveAEExtension arcAE = (ArchiveAEExtension)as.getApplicationEntity().getAEExtension(ArchiveAEExtension.class);
        if (arcAE != null) {
            if (!this.validateUserIdentity(as, arcAE, rq.getUserIdentityRQ())) {
                throw new AAssociateRJ(1, 2, 1);
            }
            if (arcAE.validateCallingAEHostname() && !this.validateCallingAEHostname(as)) {
                throw new AAssociateRJ(1, 1, 3);
            }
        }
        return super.makeAAssociateAC(as, rq, userIdentity);
    }

    private boolean validateUserIdentity(Association as, ArchiveAEExtension arcAE, UserIdentityRQ userIdentityRQ) {
        switch (arcAE.userIdentityNegotiation()) {
            case SUPPORTS: {
                return this.validateUserIdentity(as, arcAE, userIdentityRQ, true);
            }
            case REQUIRED: {
                return this.validateUserIdentity(as, arcAE, userIdentityRQ, false);
            }
        }
        return true;
    }

    private boolean validateUserIdentity(Association as, ArchiveAEExtension arcAE, UserIdentityRQ userIdentityRQ, boolean optional) {
        KeycloakClient kc;
        if (userIdentityRQ != null && (userIdentityRQ.getType() == 2 || userIdentityRQ.getType() == 5) && (kc = this.keycloakClient(arcAE)) != null) {
            try {
                switch (userIdentityRQ.getType()) {
                    case 2: {
                        kc.setKeycloakGrantType(KeycloakClient.GrantType.password);
                        kc.setUserID(userIdentityRQ.getUsername());
                        kc.setPassword(new String(userIdentityRQ.getPasscode()));
                        return this.accessTokenRequestor.verifyUsernamePasscode(kc, arcAE.userIdentityNegotiationRole());
                    }
                    case 5: {
                        return this.accessTokenRequestor.verifyJWT(userIdentityRQ.getUsername(), kc, arcAE.userIdentityNegotiationRole());
                    }
                }
            }
            catch (Exception e) {
                LOG.info("{}: validation of {} failed:\n", new Object[]{as, userIdentityRQ, e});
                return false;
            }
        }
        return optional;
    }

    private KeycloakClient keycloakClient(ArchiveAEExtension arcAE) {
        String keycloakClientID = arcAE.userIdentityNegotiationKeycloakClientID();
        if (keycloakClientID != null) {
            KeycloakClient kc = arcAE.getApplicationEntity().getDevice().getKeycloakClient(keycloakClientID);
            return kc != null ? kc.clone() : null;
        }
        if (System.getProperty("auth-server-url") != null) {
            KeycloakClient kc = new KeycloakClient();
            kc.setKeycloakServerURL(System.getProperty("auth-server-url"));
            kc.setKeycloakRealm(System.getProperty("realm-name", "dcm4che"));
            kc.setKeycloakClientID(System.getProperty("ui-client-id", "dcm4chee-arc-ui"));
            kc.setTLSDisableTrustManager(Boolean.parseBoolean(System.getProperty("disable-trust-manager", "false")));
            kc.setTLSAllowAnyHostname(Boolean.parseBoolean(System.getProperty("allow-any-hostname", "true")));
            return kc;
        }
        return null;
    }

    private boolean validateCallingAEHostname(Association as) {
        try {
            ApplicationEntity ae = this.aeCache.get(as.getAAssociateRQ().getCallingAET());
            if (ae != null) {
                InetAddress remote = as.getSocket().getInetAddress();
                for (Connection c : ae.getConnections()) {
                    if (!this.equalsHost(c.getHostname(), remote)) continue;
                    return true;
                }
                LOG.info("{}: Host {} of Calling AE does not match configuration", (Object)as, (Object)remote);
            } else {
                LOG.info("{}: Calling AE not configured", (Object)as);
            }
        }
        catch (ConfigurationException e) {
            LOG.warn("{}: Failed to lookup configuration for Calling AE:\n", (Object)as, (Object)e);
        }
        return false;
    }

    private boolean equalsHost(String configuredHostname, InetAddress addr) {
        if (StringUtils.isIPAddr((String)configuredHostname)) {
            return configuredHostname.equals(addr.getHostAddress());
        }
        String canonicalHostName = addr.getCanonicalHostName();
        return configuredHostname.equalsIgnoreCase(configuredHostname.indexOf(46) < 0 ? StringUtils.split((String)canonicalHostName, (char)'.')[0] : canonicalHostName);
    }
}

