/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.restore.impl;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.net.Device;
import org.dcm4che3.util.TagUtils;
import org.dcm4chee.arc.code.CodeCache;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.Availability;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.entity.CodeEntity;
import org.dcm4chee.arc.entity.Completeness;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Metadata;
import org.dcm4chee.arc.entity.Patient;
import org.dcm4chee.arc.entity.RejectionState;
import org.dcm4chee.arc.entity.Series;
import org.dcm4chee.arc.entity.SeriesQueryAttributes;
import org.dcm4chee.arc.entity.SeriesRequestAttributes;
import org.dcm4chee.arc.entity.Study;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.patient.PatientMgtContext;
import org.dcm4chee.arc.patient.PatientService;
import org.dcm4chee.arc.restore.RestoreFromMetadata;
import org.dcm4chee.arc.storage.ReadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class RestoreFromMetadataEJB
implements RestoreFromMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreFromMetadataEJB.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    @Inject
    private CodeCache codeCache;
    @Inject
    private PatientService patientService;
    @Inject
    private Device device;

    @Override
    public void restore(ReadContext readContext, List<Attributes> seriesMetadata, HttpServletRequestInfo httpRequest) {
        ArchiveDeviceExtension arcDev = this.getArchiveDeviceExtension();
        Attributes attrs = seriesMetadata.get(0);
        Series series = this.createSeries(arcDev, attrs, RestoreFromMetadataEJB.calculateSeriesSize(seriesMetadata), this.findOrCreateStudy(arcDev, attrs, httpRequest), this.createMetadata(readContext));
        for (QueryRetrieveView qrView : arcDev.getQueryRetrieveViews()) {
            this.createSeriesQueryAttributes(qrView, seriesMetadata, series);
        }
        LOG.info("Restore {}", (Object)series);
    }

    private void createSeriesQueryAttributes(QueryRetrieveView qrView, List<Attributes> seriesMetadata, Series series) {
        SeriesQueryAttributes queryAttrs = new SeriesQueryAttributes();
        int numberOfInstances = 0;
        for (Attributes attrs : seriesMetadata) {
            if (qrView.hideRejectionNote(attrs) || qrView.hideRejectedInstance(attrs.getNestedDataset("DCM4CHEE Archive 5", 2004287554))) continue;
            ++numberOfInstances;
            queryAttrs.retainRetrieveAETs(attrs.getStrings(524372));
            queryAttrs.floorAvailability(Availability.valueOf((String)attrs.getString(524374)));
            queryAttrs.addSOPClassInSeries(attrs.getString(524310));
        }
        queryAttrs.setNumberOfInstances(numberOfInstances);
        queryAttrs.setViewID(qrView.getViewID());
        queryAttrs.setSeries(series);
        this.em.persist((Object)queryAttrs);
    }

    private static long calculateSeriesSize(List<Attributes> seriesMetadata) {
        return seriesMetadata.stream().mapToLong(attrs -> attrs.getInt("DCM4CHEE Archive 5", 2004287571, 0, 0)).sum();
    }

    private ArchiveDeviceExtension getArchiveDeviceExtension() {
        return (ArchiveDeviceExtension)this.device.getDeviceExtensionNotNull(ArchiveDeviceExtension.class);
    }

    private Metadata createMetadata(ReadContext readContext) {
        Metadata metadata = new Metadata();
        metadata.setStorageID(readContext.getStorage().getStorageDescriptor().getStorageID());
        metadata.setStoragePath(readContext.getStoragePath());
        metadata.setSize(readContext.getSize());
        metadata.setDigest(readContext.getDigest());
        this.em.persist((Object)metadata);
        return metadata;
    }

    private Study findOrCreateStudy(ArchiveDeviceExtension arcDev, Attributes attrs, HttpServletRequestInfo httpRequest) {
        try {
            return (Study)this.em.createNamedQuery("Study.findByStudyIUID", Study.class).setParameter(1, (Object)attrs.getString(0x20000D)).getSingleResult();
        }
        catch (NoResultException e) {
            return this.createStudy(arcDev, attrs, this.findOrCreatePatient(attrs, httpRequest));
        }
    }

    private Patient findOrCreatePatient(Attributes attrs, HttpServletRequestInfo httpRequest) {
        PatientMgtContext ctx = this.patientService.createPatientMgtContextWEB(httpRequest);
        ctx.setAttributes(attrs);
        Patient pat = this.patientService.findPatient(ctx);
        return pat != null ? pat : this.patientService.createPatient(ctx);
    }

    private Study createStudy(ArchiveDeviceExtension arcDev, Attributes attrs, Patient patient) {
        Study study = new Study();
        study.addStorageID(attrs.getString("DCM4CHEE Archive 5", 0x77770050));
        Sequence seq = attrs.getSequence("DCM4CHEE Archive 5", 0x77770055);
        if (seq != null) {
            for (Attributes item : seq) {
                study.addStorageID(item.getString("DCM4CHEE Archive 5", 0x77770050));
            }
        }
        study.setAccessControlID(attrs.getString("DCM4CHEE Archive 5", 0x77770027));
        study.setCompleteness(Completeness.COMPLETE);
        study.setExpirationDate(RestoreFromMetadataEJB.toLocalDate(attrs.getDate("DCM4CHEE Archive 5", 2004287523)));
        study.setExpirationState(ExpirationState.UPDATEABLE);
        study.setAttributes(attrs, arcDev.getAttributeFilter(Entity.Study), false, arcDev.getFuzzyStr());
        this.setCodes(study.getProcedureCodes(), attrs, 528434);
        study.setPatient(patient);
        study.setRejectionState(RejectionState.NONE);
        patient.incrementNumberOfStudies();
        this.em.persist((Object)study);
        LOG.info("Create {}", (Object)study);
        return study;
    }

    private Series createSeries(ArchiveDeviceExtension arcDev, Attributes attrs, long seriesSize, Study study, Metadata metadata) {
        Series series = new Series();
        series.setAttributes(attrs, arcDev.getAttributeFilter(Entity.Series), false, arcDev.getFuzzyStr());
        series.setInstitutionCode(this.findOrCreateCode(attrs, 524418));
        series.setInstitutionalDepartmentTypeCode(this.findOrCreateCode(attrs, 528449));
        Sequence seq = attrs.getSequence(4194933);
        Collection requestAttributes = series.getRequestAttributes();
        if (seq != null) {
            for (Attributes item : seq) {
                SeriesRequestAttributes request = new SeriesRequestAttributes(item, arcDev.getFuzzyStr());
                requestAttributes.add(request);
            }
        }
        series.setSendingAET(attrs.getString("DCM4CHEE Archive 5", 0x77770037));
        series.setReceivingAET(attrs.getString("DCM4CHEE Archive 5", 2004287592));
        series.setSendingPresentationAddress(attrs.getString("DCM4CHEE Archive 5", 2004287593));
        series.setReceivingPresentationAddress(attrs.getString("DCM4CHEE Archive 5", 2004287594));
        series.setSopClassUID(attrs.getString(524310));
        series.setTransferSyntaxUID(attrs.getString("DCM4CHEE Archive 5", 2004287570));
        series.setInstancePurgeState(Series.InstancePurgeState.PURGED);
        series.setExpirationDate(RestoreFromMetadataEJB.toLocalDate(attrs.getDate("DCM4CHEE Archive 5", 0x77770033)));
        series.setExpirationState(ExpirationState.UPDATEABLE);
        series.setCompleteness(Completeness.COMPLETE);
        series.setRejectionState(RejectionState.NONE);
        series.setSize(seriesSize);
        series.setStudy(study);
        series.setMetadata(metadata);
        this.em.persist((Object)series);
        return series;
    }

    private static LocalDate toLocalDate(Date dateToConvert) {
        return dateToConvert != null ? dateToConvert.toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : null;
    }

    private CodeEntity findOrCreateCode(Attributes attrs, int seqTag) {
        Attributes item = attrs.getNestedDataset(seqTag);
        if (item != null) {
            try {
                return this.codeCache.findOrCreate(new Code(item));
            }
            catch (Exception e) {
                LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
            }
        }
        return null;
    }

    private void setCodes(Collection<CodeEntity> codes, Attributes attrs, int seqTag) {
        Sequence seq = attrs.getSequence(seqTag);
        codes.clear();
        if (seq != null) {
            for (Attributes item : seq) {
                try {
                    codes.add(this.codeCache.findOrCreate(new Code(item)));
                }
                catch (Exception e) {
                    LOG.info("Illegal code item in Sequence {}:\n{}", (Object)TagUtils.toString((int)seqTag), (Object)item);
                }
            }
        }
    }
}

