/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.query.util;

import java.util.List;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.soundex.FuzzyStr;
import org.dcm4chee.arc.conf.ArchiveAEExtension;
import org.dcm4chee.arc.conf.ArchiveDeviceExtension;
import org.dcm4chee.arc.conf.AttributeFilter;
import org.dcm4chee.arc.conf.Entity;
import org.dcm4chee.arc.conf.QueryRetrieveView;
import org.dcm4chee.arc.conf.SPSStatus;
import org.dcm4chee.arc.entity.ExpirationState;
import org.dcm4chee.arc.entity.Patient;

public class QueryParam {
    private final ArchiveAEExtension arcAE;
    private final ArchiveDeviceExtension arcDev;
    private final QueryRetrieveView qrView;
    private boolean combinedDatetimeMatching;
    private boolean fuzzySemanticMatching;
    private boolean allOfModalitiesInStudy;
    private boolean onlyWithStudies;
    private boolean incomplete;
    private boolean retrieveFailed;
    private boolean storageVerificationFailed;
    private boolean metadataUpdateFailed;
    private boolean compressionfailed;
    private boolean template;
    private boolean merged;
    private String externalRetrieveAET;
    private String externalRetrieveAETNot;
    private String subscriberAET;
    private String notSubscribedByAET;
    private String calledAET;
    private Patient.VerificationStatus patientVerificationStatus;
    private ExpirationState[] expirationState;
    private String expirationDate;
    private List<String> studyStorageIDs;
    private long minStudySize;
    private long maxStudySize;
    private boolean withoutIssuer;
    private String requested;
    private SPSStatus[] hideSPSWithStatusFromMWL = new SPSStatus[0];

    public QueryParam(ApplicationEntity ae) {
        this((ArchiveAEExtension)ae.getAEExtensionNotNull(ArchiveAEExtension.class));
    }

    public QueryParam(ArchiveAEExtension arcAE) {
        this.arcAE = arcAE;
        this.arcDev = arcAE.getArchiveDeviceExtension();
        this.qrView = arcAE.getQueryRetrieveView();
        this.calledAET = arcAE.getApplicationEntity().getAETitle();
    }

    public void setCalledAET(String calledAET) {
        this.calledAET = calledAET;
    }

    public String getCalledAET() {
        return this.calledAET;
    }

    public String[] getAccessControlIDs() {
        return this.arcAE.getAccessControlIDs();
    }

    public SPSStatus[] getHideSPSWithStatusFromMWL() {
        return this.hideSPSWithStatusFromMWL;
    }

    public void setHideSPSWithStatusFromMWL(SPSStatus ... hideSPSWithStatusFromMWL) {
        this.hideSPSWithStatusFromMWL = hideSPSWithStatusFromMWL;
    }

    public FuzzyStr getFuzzyStr() {
        return this.arcDev.getFuzzyStr();
    }

    public boolean isPersonNameComponentOrderInsensitiveMatching() {
        return this.arcAE.personNameComponentOrderInsensitiveMatching();
    }

    public boolean isHideNotRejectedInstances() {
        return this.qrView.isHideNotRejectedInstances();
    }

    public boolean isFilterByIssuerOfPatientID() {
        return this.arcAE.filterByIssuerOfPatientID();
    }

    public boolean isMatchSOPClassOnInstanceLevel() {
        return this.arcAE.matchSOPClassOnInstanceLevel();
    }

    public AttributeFilter getAttributeFilter(Entity entity) {
        return this.arcDev.getAttributeFilter(entity);
    }

    public String getViewID() {
        return this.qrView.getViewID();
    }

    public QueryRetrieveView getQueryRetrieveView() {
        return this.qrView;
    }

    public Issuer getDefaultIssuerOfAccessionNumber() {
        return null;
    }

    public Issuer getDefaultIssuerOfAdmissionID() {
        return null;
    }

    public boolean isCombinedDatetimeMatching() {
        return this.combinedDatetimeMatching;
    }

    public void setCombinedDatetimeMatching(boolean combinedDatetimeMatching) {
        this.combinedDatetimeMatching = combinedDatetimeMatching;
    }

    public boolean isFuzzySemanticMatching() {
        return this.fuzzySemanticMatching;
    }

    public void setFuzzySemanticMatching(boolean fuzzySemanticMatching) {
        this.fuzzySemanticMatching = fuzzySemanticMatching;
    }

    public boolean isAllOfModalitiesInStudy() {
        return this.allOfModalitiesInStudy;
    }

    public void setAllOfModalitiesInStudy(boolean allOfModalitiesInStudy) {
        this.allOfModalitiesInStudy = allOfModalitiesInStudy;
    }

    public boolean isOnlyWithStudies() {
        return this.onlyWithStudies;
    }

    public void setOnlyWithStudies(boolean onlyWithStudies) {
        this.onlyWithStudies = onlyWithStudies;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public boolean isRetrieveFailed() {
        return this.retrieveFailed;
    }

    public void setRetrieveFailed(boolean retrieveFailed) {
        this.retrieveFailed = retrieveFailed;
    }

    public boolean isStorageVerificationFailed() {
        return this.storageVerificationFailed;
    }

    public void setStorageVerificationFailed(boolean storageVerificationFailed) {
        this.storageVerificationFailed = storageVerificationFailed;
    }

    public boolean isMetadataUpdateFailed() {
        return this.metadataUpdateFailed;
    }

    public void setMetadataUpdateFailed(boolean metadataUpdateFailed) {
        this.metadataUpdateFailed = metadataUpdateFailed;
    }

    public boolean isCompressionFailed() {
        return this.compressionfailed;
    }

    public void setCompressionFailed(boolean compressionfailed) {
        this.compressionfailed = compressionfailed;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public String getExternalRetrieveAETNot() {
        return this.externalRetrieveAETNot;
    }

    public void setExternalRetrieveAETNot(String externalRetrieveAETNot) {
        this.externalRetrieveAETNot = externalRetrieveAETNot;
    }

    public String getNotSubscribedByAET() {
        return this.notSubscribedByAET;
    }

    public void setNotSubscribedByAET(String notSubscribedByAET) {
        this.notSubscribedByAET = notSubscribedByAET;
    }

    public Patient.VerificationStatus getPatientVerificationStatus() {
        return this.patientVerificationStatus;
    }

    public void setPatientVerificationStatus(Patient.VerificationStatus patientVerificationStatus) {
        this.patientVerificationStatus = patientVerificationStatus;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public List<String> getStudyStorageIDs() {
        return this.studyStorageIDs;
    }

    public void setStudyStorageIDs(List<String> studyStorageIDs) {
        this.studyStorageIDs = studyStorageIDs;
    }

    public boolean noMatches() {
        return this.studyStorageIDs != null && this.studyStorageIDs.isEmpty();
    }

    public long getMinStudySize() {
        return this.minStudySize;
    }

    public long getMaxStudySize() {
        return this.maxStudySize;
    }

    public void setStudySizeRange(String studySizeInKB) {
        if (studySizeInKB == null || studySizeInKB.isEmpty()) {
            return;
        }
        int delim = studySizeInKB.indexOf(45);
        if (delim == -1) {
            long size;
            this.minStudySize = size = Long.parseLong(studySizeInKB) * 1000L;
            this.maxStudySize = size + 999L;
        } else {
            if (delim > 0) {
                this.minStudySize = Long.parseLong(studySizeInKB.substring(0, delim)) * 1000L;
            }
            if (delim < studySizeInKB.length() - 1) {
                this.maxStudySize = Long.parseLong(studySizeInKB.substring(delim + 1)) * 1000L + 999L;
            }
        }
    }

    public ExpirationState[] getExpirationState() {
        return this.expirationState;
    }

    public void setExpirationState(ExpirationState ... expirationState) {
        this.expirationState = expirationState;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public boolean isWithoutIssuer() {
        return this.withoutIssuer;
    }

    public void setWithoutIssuer(boolean withoutIssuer) {
        this.withoutIssuer = withoutIssuer;
    }

    public String getRequested() {
        return this.requested;
    }

    public void setRequested(String requested) {
        this.requested = requested;
    }
}

