/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.procedure.scp;

import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IDWithIssuer;
import org.dcm4che3.data.Issuer;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicCFindSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.QueryTask;
import org.dcm4chee.arc.procedure.scp.MWLQueryTask;
import org.dcm4chee.arc.query.QueryContext;
import org.dcm4chee.arc.query.QueryService;
import org.dcm4chee.arc.query.RunInTransaction;
import org.dcm4chee.arc.query.util.OrderByTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Typed(value={DicomService.class})
public class MWLCFindSCP
extends BasicCFindSCP {
    private static final Logger LOG = LoggerFactory.getLogger(MWLCFindSCP.class);
    @Inject
    private QueryService queryService;
    @EJB
    private RunInTransaction runInTx;

    public MWLCFindSCP() {
        super(new String[]{"1.2.840.10008.5.1.4.31"});
    }

    protected QueryTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
        String mwlWorklistLabel;
        LOG.info("{}: Process MWL C-FIND RQ:\n{}", (Object)as, (Object)keys.toString(keys.size(), 78));
        String sopClassUID = rq.getString(2);
        EnumSet queryOpts = as.getQueryOptionsFor(sopClassUID);
        QueryContext ctx = this.queryService.newQueryContextFIND(as, sopClassUID, queryOpts);
        ctx.setQueryKeys(keys);
        ctx.setReturnKeys(this.createReturnKeys(keys));
        if (!keys.containsValue(7606786) && (mwlWorklistLabel = ctx.getArchiveAEExtension().getMWLWorklistLabel()) != null) {
            keys.setString(7606786, VR.LO, mwlWorklistLabel);
        }
        try {
            this.queryService.coerceAttributes(ctx);
        }
        catch (DicomServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DicomServiceException(272, (Throwable)e);
        }
        IDWithIssuer idWithIssuer = IDWithIssuer.pidOf((Attributes)keys);
        if (idWithIssuer != null && !idWithIssuer.getID().equals("*")) {
            ctx.setPatientIDs(new IDWithIssuer[]{idWithIssuer});
        } else if (ctx.getArchiveAEExtension().filterByIssuerOfPatientID()) {
            ctx.setIssuerOfPatientID(Issuer.fromIssuerOfPatientID((Attributes)keys));
        }
        Sequence sortingOperationSeq = (Sequence)keys.remove(7472640);
        if (sortingOperationSeq != null) {
            ctx.setOrderByTags(sortingOperationSeq.stream().map(OrderByTag::valueOf).collect(Collectors.toList()));
        }
        return new MWLQueryTask(as, pc, rq, keys, this.queryService.createMWLQuery(ctx), this.queryService.getAttributesCoercion(ctx), this.runInTx);
    }

    private Attributes createReturnKeys(Attributes keys) {
        Attributes returnKeys = new Attributes(keys.size() + 3);
        returnKeys.addAll(keys);
        returnKeys.setNull(524293, VR.CS);
        return returnKeys;
    }
}

