/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.arc.hl7.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4chee.arc.entity.Task;
import org.dcm4chee.arc.hl7.ArchiveHL7Message;
import org.dcm4chee.arc.hl7.HL7Sender;
import org.dcm4chee.arc.keycloak.HttpServletRequestInfo;
import org.dcm4chee.arc.qmgt.Outcome;
import org.dcm4chee.arc.qmgt.TaskProcessor;

@ApplicationScoped
@Named(value="HL7")
public class HL7SenderTaskProcessor
implements TaskProcessor {
    @Inject
    private Device device;
    @Inject
    private IHL7ApplicationCache hl7AppCache;
    @Inject
    private HL7Sender hl7Sender;

    public Outcome process(Task task) throws Exception {
        ArchiveHL7Message hl7Msg = new ArchiveHL7Message((byte[])task.getPayload(byte[].class));
        HL7Application sender = ((HL7DeviceExtension)this.device.getDeviceExtension(HL7DeviceExtension.class)).getHL7Application(task.getSendingApplicationWithFacility(), true);
        HL7Application receiver = this.hl7AppCache.findHL7Application(task.getReceivingApplicationWithFacility());
        hl7Msg.setHttpServletRequestInfo(HttpServletRequestInfo.valueOf((String)task.getRequesterUserID(), (String)task.getRequesterHost(), (String)task.getRequestURI()));
        UnparsedHL7Message rsp = this.hl7Sender.sendMessage(sender, receiver, hl7Msg);
        return this.toOutcome(rsp.data(), sender);
    }

    private Outcome toOutcome(byte[] rsp, HL7Application sender) {
        HL7Segment msa = HL7Message.parse((byte[])rsp, (String)sender.getHL7DefaultCharacterSet()).getSegment("MSA");
        if (msa == null) {
            return new Outcome(Task.Status.WARNING, "Missing MSA segment in response message");
        }
        return new Outcome(this.status(msa), msa.toString());
    }

    private Task.Status status(HL7Segment msa) {
        return "AA".equals(msa.getField(1, null)) ? Task.Status.COMPLETED : Task.Status.WARNING;
    }
}

